/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NumericValidation
implements JsonSchemaValidation {
    public static final NumericValidation INSTANCE = new NumericValidation();

    private static boolean checkNumber(PsiElement propValue, JsonSchemaObject schema, JsonSchemaType schemaType, JsonValidationHost consumer, @NotNull JsonComplianceCheckerOptions options) {
        double leftOver;
        Number multipleOf;
        Number value;
        String valueText;
        if (options == null) {
            NumericValidation.$$$reportNull$$$0(0);
        }
        if ((valueText = JsonSchemaAnnotatorChecker.getValue(propValue, schema)) == null) {
            return true;
        }
        if (JsonSchemaType._integer.equals((Object)schemaType)) {
            value = JsonSchemaType.getIntegerValue(valueText);
            if (value == null) {
                consumer.error(JsonBundle.message((String)"schema.validation.integer.expected", (Object[])new Object[0]), propValue, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData(new JsonSchemaType[]{schemaType}), JsonErrorPriority.TYPE_MISMATCH);
                return false;
            }
        } else {
            try {
                value = Double.valueOf(valueText);
            }
            catch (NumberFormatException e) {
                if (!JsonSchemaType._string_number.equals((Object)schemaType)) {
                    consumer.error(JsonBundle.message((String)"schema.validation.number.expected", (Object[])new Object[0]), propValue, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData(new JsonSchemaType[]{schemaType}), JsonErrorPriority.TYPE_MISMATCH);
                    return false;
                }
                return true;
            }
        }
        if ((multipleOf = schema.getMultipleOf()) != null && (leftOver = value.doubleValue() % multipleOf.doubleValue()) > 1.0E-6) {
            String multipleOfValue = String.valueOf(Math.abs(multipleOf.doubleValue() - (double)multipleOf.intValue()) < 1.0E-6 ? (Number)multipleOf.intValue() : (Number)multipleOf);
            consumer.error(JsonBundle.message((String)"schema.validation.not.multiple.of", (Object[])new Object[]{multipleOfValue}), propValue, JsonErrorPriority.LOW_PRIORITY);
            return false;
        }
        return NumericValidation.checkMinimum(schema, value, propValue, consumer, options) & NumericValidation.checkMaximum(schema, value, propValue, consumer, options);
    }

    private static boolean checkMaximum(JsonSchemaObject schema, Number value, PsiElement propertyValue, JsonValidationHost consumer, @NotNull JsonComplianceCheckerOptions options) {
        Number maximum;
        if (options == null) {
            NumericValidation.$$$reportNull$$$0(1);
        }
        boolean isValid = true;
        Number exclusiveMaximumNumber = schema.getExclusiveMaximumNumber();
        if (exclusiveMaximumNumber != null) {
            double doubleValue = exclusiveMaximumNumber.doubleValue();
            if (value.doubleValue() >= doubleValue) {
                consumer.error(JsonBundle.message((String)"schema.validation.greater.than.exclusive.maximum", (Object[])new Object[]{exclusiveMaximumNumber}), propertyValue, JsonErrorPriority.LOW_PRIORITY);
                isValid = false;
                if (options.shouldStopValidationAfterAnyErrorFound()) {
                    return false;
                }
            }
        }
        if ((maximum = schema.getMaximum()) == null) {
            return isValid;
        }
        boolean isExclusive = Boolean.TRUE.equals(schema.isExclusiveMaximum());
        double doubleValue = maximum.doubleValue();
        if (isExclusive) {
            if (value.doubleValue() >= doubleValue) {
                consumer.error(JsonBundle.message((String)"schema.validation.greater.than.exclusive.maximum", (Object[])new Object[]{maximum}), propertyValue, JsonErrorPriority.LOW_PRIORITY);
                isValid = false;
                if (options.shouldStopValidationAfterAnyErrorFound()) {
                    return false;
                }
            }
        } else if (value.doubleValue() > doubleValue) {
            consumer.error(JsonBundle.message((String)"schema.validation.greater.than.maximum", (Object[])new Object[]{maximum}), propertyValue, JsonErrorPriority.LOW_PRIORITY);
            isValid = false;
            if (options.shouldStopValidationAfterAnyErrorFound()) {
                return false;
            }
        }
        return isValid;
    }

    private static boolean checkMinimum(JsonSchemaObject schema, Number value, PsiElement propertyValue, JsonValidationHost consumer, @NotNull JsonComplianceCheckerOptions options) {
        Number minimum;
        if (options == null) {
            NumericValidation.$$$reportNull$$$0(2);
        }
        boolean isValid = true;
        Number exclusiveMinimumNumber = schema.getExclusiveMinimumNumber();
        if (exclusiveMinimumNumber != null) {
            double doubleValue = exclusiveMinimumNumber.doubleValue();
            if (value.doubleValue() <= doubleValue) {
                consumer.error(JsonBundle.message((String)"schema.validation.less.than.exclusive.minimum", (Object[])new Object[]{exclusiveMinimumNumber}), propertyValue, JsonErrorPriority.LOW_PRIORITY);
                isValid = false;
                if (options.shouldStopValidationAfterAnyErrorFound()) {
                    return false;
                }
            }
        }
        if ((minimum = schema.getMinimum()) == null) {
            return isValid;
        }
        boolean isExclusive = Boolean.TRUE.equals(schema.isExclusiveMinimum());
        double doubleValue = minimum.doubleValue();
        if (isExclusive) {
            if (value.doubleValue() <= doubleValue) {
                consumer.error(JsonBundle.message((String)"schema.validation.less.than.exclusive.minimum", (Object[])new Object[]{minimum}), propertyValue, JsonErrorPriority.LOW_PRIORITY);
                isValid = false;
                if (options.shouldStopValidationAfterAnyErrorFound()) {
                    return false;
                }
            }
        } else if (value.doubleValue() < doubleValue) {
            consumer.error(JsonBundle.message((String)"schema.validation.less.than.minimum", (Object[])new Object[]{minimum}), propertyValue, JsonErrorPriority.LOW_PRIORITY);
            isValid = false;
            if (options.shouldStopValidationAfterAnyErrorFound()) {
                return false;
            }
        }
        return isValid;
    }

    @Override
    public boolean validate(@NotNull JsonValueAdapter propValue, @NotNull JsonSchemaObject schema, @Nullable JsonSchemaType schemaType, @NotNull JsonValidationHost consumer, @NotNull JsonComplianceCheckerOptions options) {
        if (propValue == null) {
            NumericValidation.$$$reportNull$$$0(3);
        }
        if (schema == null) {
            NumericValidation.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            NumericValidation.$$$reportNull$$$0(5);
        }
        if (options == null) {
            NumericValidation.$$$reportNull$$$0(6);
        }
        return NumericValidation.checkNumber(propValue.getDelegate(), schema, schemaType, consumer, options);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/validations/NumericValidation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNumber";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMaximum";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMinimum";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

