/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.xml.dom.impl;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.intellij.plugins.relaxNG.xml.dom.impl.DefinitionReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CreatePatternFix
implements IntentionAction,
LocalQuickFix {
    private final PsiReference myReference;

    CreatePatternFix(PsiReference reference) {
        this.myReference = reference;
    }

    @NotNull
    public String getText() {
        String string = RelaxngBundle.message("relaxng.quickfix.create-pattern.name", this.myReference.getCanonicalText());
        if (string == null) {
            CreatePatternFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RelaxngBundle.message("relaxng.quickfix.create-pattern.family", new Object[0]);
        if (string == null) {
            CreatePatternFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            CreatePatternFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            CreatePatternFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            CreatePatternFix.$$$reportNull$$$0(4);
        }
        if (!this.isAvailable()) {
            return;
        }
        try {
            this.doFix();
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
        }
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            CreatePatternFix.$$$reportNull$$$0(5);
        }
        return this.isAvailable();
    }

    private boolean isAvailable() {
        if (!(this.myReference instanceof DefinitionReference) || !this.myReference.getElement().isValid()) {
            return false;
        }
        RngGrammar grammar = ((DefinitionReference)this.myReference).getScope();
        if (grammar == null) {
            return false;
        }
        return grammar.getXmlTag() != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project2 == null) {
            CreatePatternFix.$$$reportNull$$$0(6);
        }
        this.doFix();
    }

    private void doFix() throws IncorrectOperationException {
        XmlTag[] tags;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myReference.getElement(), XmlTag.class);
        assert (tag != null);
        XmlTag defineTag = tag.createChildTag("define", "http://relaxng.org/ns/structure/1.0", "\n \n", false);
        defineTag.setAttribute("name", this.myReference.getCanonicalText());
        RngGrammar grammar = ((DefinitionReference)this.myReference).getScope();
        if (grammar == null) {
            return;
        }
        XmlTag root = grammar.getXmlTag();
        if (root == null) {
            return;
        }
        for (XmlTag xmlTag : tags = root.getSubTags()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)xmlTag, (PsiElement)tag, (boolean)false)) continue;
            XmlElementFactory ef = XmlElementFactory.getInstance((Project)tag.getProject());
            XmlText text = ef.createDisplayText(" ");
            PsiElement e = root.addAfter((PsiElement)text, (PsiElement)xmlTag);
            root.addAfter((PsiElement)defineTag, e);
            return;
        }
        root.add((PsiElement)defineTag);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            CreatePatternFix.$$$reportNull$$$0(7);
        }
        PsiElement copy = PsiTreeUtil.findSameElementInCopy((PsiElement)this.myReference.getElement(), (PsiFile)target);
        return new CreatePatternFix(copy.getReference());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/xml/dom/impl/CreatePatternFix";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/xml/dom/impl/CreatePatternFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

