/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.compact;

import com.thaiopensource.relaxng.parse.Annotations;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.CommentList;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.relaxng.parse.DataPatternBuilder;
import com.thaiopensource.relaxng.parse.Div;
import com.thaiopensource.relaxng.parse.ElementAnnotationBuilder;
import com.thaiopensource.relaxng.parse.Grammar;
import com.thaiopensource.relaxng.parse.GrammarSection;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Include;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.Location;
import com.thaiopensource.relaxng.parse.ParsedElementAnnotation;
import com.thaiopensource.relaxng.parse.ParsedNameClass;
import com.thaiopensource.relaxng.parse.ParsedPattern;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.compact.CompactSyntaxConstants;
import com.thaiopensource.relaxng.parse.compact.CompactSyntaxTokenManager;
import com.thaiopensource.relaxng.parse.compact.EscapeSyntaxException;
import com.thaiopensource.relaxng.parse.compact.ParseException;
import com.thaiopensource.relaxng.parse.compact.Token;
import com.thaiopensource.relaxng.parse.compact.UCode_UCodeESC_CharStream;
import com.thaiopensource.util.Localizer;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class CompactSyntax
implements Context,
CompactSyntaxConstants {
    private static final int IN_ELEMENT = 0;
    private static final int IN_ATTRIBUTE = 1;
    private static final int IN_ANY_NAME = 2;
    private static final int IN_NS_NAME = 4;
    private String defaultNamespace = SchemaBuilder.INHERIT_NS;
    private String compatibilityPrefix = null;
    private SchemaBuilder sb;
    private String sourceUri;
    private ErrorHandler eh;
    private final Hashtable namespaceTable = new Hashtable();
    private final Hashtable datatypesTable = new Hashtable();
    private boolean hadError = false;
    private static final Localizer localizer = new Localizer(class$com$thaiopensource$relaxng$parse$compact$CompactSyntax == null ? (class$com$thaiopensource$relaxng$parse$compact$CompactSyntax = CompactSyntax.class$("com.thaiopensource.relaxng.parse.compact.CompactSyntax")) : class$com$thaiopensource$relaxng$parse$compact$CompactSyntax);
    private final Hashtable attributeNameTable = new Hashtable();
    private boolean annotationsIncludeElements = false;
    private CommentList topLevelComments;
    private Token lastCommentSourceToken = null;
    public CompactSyntaxTokenManager token_source;
    UCode_UCodeESC_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[71];
    private final int[] jj_la1_0 = new int[]{-1676803070, 30, 2, 226, 28, 224, 224, 0, 0, 0, -1945115162, -1945115162, 1026, 90112, 90112, -1945115424, 24576, 32768, 0, -1676803072, 0x100000, 0x200000, 0x400000, 0x700000, 0x700000, 0x3800000, 0, 0x3800000, -1643125536, 0, 0x100000, 0x100000, -1643125536, -1676679968, 0x2000000, 0x40000000, 0x40000000, 226, 224, 32, 28, 2048, 98, 96, 32768, 0x40000000, 0x40000000, 2048, 0, 0, 0, -1945115424, -1945115424, -1945115422, 0, 0, 0, 0, -1945115424, 2, -1945115424, -1945115424, 0, -1945115424, 256, -1945115424, 256, 256, 256, 256, -1945115424};
    private final int[] jj_la1_1 = new int[]{113248543, 0, 0, 46139648, 0, 0xC00000, 0, 2304, 512, 2304, 113246239, 113246239, 2304, 0, 0, 12582943, 0, 0x4000000, 0x8000000, 113246239, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 62914591, 0x8000000, 0, 0, 62914591, 46137375, 0x1000000, 0, 0, 0xC00900, 0xC00000, 0xC00000, 0, 0, 0xC00900, 0xC00000, 0, 0, 0, 0, 0x4000000, 33554456, 0xC00000, 12582943, 12582943, 12585247, 2304, 512, 2304, 2304, 46137375, 0, 46137375, 46137375, 0x2C00000, 113246239, 0, 113246239, 0, 0, 0, 0, 31};
    private final JJCalls[] jj_2_rtns = new JJCalls[8];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    static /* synthetic */ Class class$com$thaiopensource$relaxng$parse$compact$CompactSyntax;

    public CompactSyntax(Reader reader, String string, SchemaBuilder schemaBuilder, ErrorHandler errorHandler) {
        this(reader);
        this.sourceUri = string;
        this.sb = schemaBuilder;
        this.eh = errorHandler;
        this.topLevelComments = schemaBuilder.makeCommentList();
    }

    ParsedPattern parse(Scope scope) throws IllegalSchemaException {
        try {
            ParsedPattern parsedPattern = this.Input(scope);
            if (!this.hadError) {
                return parsedPattern;
            }
        }
        catch (ParseException parseException) {
            this.error("syntax_error", parseException.currentToken.next);
        }
        catch (EscapeSyntaxException escapeSyntaxException) {
            this.reportEscapeSyntaxException(escapeSyntaxException);
        }
        throw new IllegalSchemaException();
    }

    ParsedPattern parseInclude(IncludedGrammar includedGrammar) throws IllegalSchemaException {
        try {
            ParsedPattern parsedPattern = this.IncludedGrammar(includedGrammar);
            if (!this.hadError) {
                return parsedPattern;
            }
        }
        catch (ParseException parseException) {
            this.error("syntax_error", parseException.currentToken.next);
        }
        catch (EscapeSyntaxException escapeSyntaxException) {
            this.reportEscapeSyntaxException(escapeSyntaxException);
        }
        throw new IllegalSchemaException();
    }

    private void checkNsName(int n, LocatedString locatedString) {
        if ((n & 4) != 0) {
            this.error("ns_name_except_contains_ns_name", locatedString.getToken());
        }
    }

    private void checkAnyName(int n, Token token) {
        if ((n & 4) != 0) {
            this.error("ns_name_except_contains_any_name", token);
        }
        if ((n & 2) != 0) {
            this.error("any_name_except_contains_any_name", token);
        }
    }

    private void error(String string, Token token) {
        this.doError(localizer.message(string), token);
    }

    private void error(String string, String string2, Token token) {
        this.doError(localizer.message(string, string2), token);
    }

    private void error(String string, String string2, String string3, Token token) {
        this.doError(localizer.message(string, string2, string3), token);
    }

    private void doError(String string, Token token) {
        this.hadError = true;
        if (this.eh != null) {
            LocatorImpl locatorImpl = new LocatorImpl();
            locatorImpl.setLineNumber(token.beginLine);
            locatorImpl.setColumnNumber(token.beginColumn);
            locatorImpl.setSystemId(this.sourceUri);
            try {
                this.eh.error(new SAXParseException(string, locatorImpl));
            }
            catch (SAXException sAXException) {
                throw new BuildException(sAXException);
            }
        }
    }

    private void reportEscapeSyntaxException(EscapeSyntaxException escapeSyntaxException) {
        if (this.eh != null) {
            LocatorImpl locatorImpl = new LocatorImpl();
            locatorImpl.setLineNumber(escapeSyntaxException.getLineNumber());
            locatorImpl.setColumnNumber(escapeSyntaxException.getColumnNumber());
            locatorImpl.setSystemId(this.sourceUri);
            try {
                this.eh.error(new SAXParseException(localizer.message(escapeSyntaxException.getKey()), locatorImpl));
            }
            catch (SAXException sAXException) {
                throw new BuildException(sAXException);
            }
        }
    }

    private static String unquote(String string) {
        if (string.length() >= 6 && string.charAt(0) == string.charAt(1)) {
            string = string.replace('\u0000', '\n');
            return string.substring(3, string.length() - 3);
        }
        return string.substring(1, string.length() - 1);
    }

    Location makeLocation(Token token) {
        return this.sb.makeLocation(this.sourceUri, token.beginLine, token.beginColumn);
    }

    private static ParsedPattern[] addPattern(ParsedPattern[] parsedPatternArray, int n, ParsedPattern parsedPattern) {
        if (n >= parsedPatternArray.length) {
            ParsedPattern[] parsedPatternArray2 = parsedPatternArray;
            parsedPatternArray = new ParsedPattern[parsedPatternArray2.length * 2];
            System.arraycopy(parsedPatternArray2, 0, parsedPatternArray, 0, parsedPatternArray2.length);
        }
        parsedPatternArray[n] = parsedPattern;
        return parsedPatternArray;
    }

    String getCompatibilityPrefix() {
        if (this.compatibilityPrefix == null) {
            this.compatibilityPrefix = "a";
            while (this.namespaceTable.get(this.compatibilityPrefix) != null) {
                this.compatibilityPrefix = this.compatibilityPrefix + "a";
            }
        }
        return this.compatibilityPrefix;
    }

    public String resolveNamespacePrefix(String string) {
        String string2 = (String)this.namespaceTable.get(string);
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public Enumeration prefixes() {
        return this.namespaceTable.keys();
    }

    public String getBaseUri() {
        return this.sourceUri;
    }

    public boolean isUnparsedEntity(String string) {
        return false;
    }

    public boolean isNotation(String string) {
        return false;
    }

    public Context copy() {
        return this;
    }

    private Context getContext() {
        return this;
    }

    private CommentList getComments() {
        return this.getComments(this.getTopLevelComments());
    }

    private CommentList getTopLevelComments() {
        CommentList commentList = this.topLevelComments;
        this.topLevelComments = null;
        return commentList;
    }

    private void noteTopLevelComments() {
        this.topLevelComments = this.getComments(this.topLevelComments);
    }

    private void topLevelComments(GrammarSection grammarSection) {
        grammarSection.topLevelComment(this.getComments(null));
    }

    private CommentList getComments(CommentList commentList) {
        Token token = this.getToken(1);
        if (this.lastCommentSourceToken != token) {
            if (this.lastCommentSourceToken == null) {
                this.lastCommentSourceToken = this.token;
            }
            do {
                this.lastCommentSourceToken = this.lastCommentSourceToken.next;
                Token token2 = this.lastCommentSourceToken.specialToken;
                if (token2 == null) continue;
                while (token2.specialToken != null) {
                    token2 = token2.specialToken;
                }
                if (commentList == null) {
                    commentList = this.sb.makeCommentList();
                }
                while (token2 != null) {
                    String string = CompactSyntax.mungeComment(token2.image);
                    Location location = this.makeLocation(token2);
                    if (token2.next != null && token2.next.kind == 44) {
                        StringBuffer stringBuffer = new StringBuffer(string);
                        do {
                            token2 = token2.next;
                            stringBuffer.append('\n');
                            stringBuffer.append(CompactSyntax.mungeComment(token2.image));
                        } while (token2.next != null && token2.next.kind == 44);
                        string = stringBuffer.toString();
                    }
                    commentList.addComment(string, location);
                    token2 = token2.next;
                }
            } while (this.lastCommentSourceToken != token);
        }
        return commentList;
    }

    private ParsedPattern afterComments(ParsedPattern parsedPattern) {
        CommentList commentList = this.getComments(null);
        if (commentList == null) {
            return parsedPattern;
        }
        return this.sb.commentAfter(parsedPattern, commentList);
    }

    private ParsedNameClass afterComments(ParsedNameClass parsedNameClass) {
        CommentList commentList = this.getComments(null);
        if (commentList == null) {
            return parsedNameClass;
        }
        return this.sb.commentAfter(parsedNameClass, commentList);
    }

    private static String mungeComment(String string) {
        int n = string.indexOf(35) + 1;
        while (n < string.length() && string.charAt(n) == '#') {
            ++n;
        }
        if (n < string.length() && string.charAt(n) == ' ') {
            ++n;
        }
        return string.substring(n);
    }

    private Annotations getCommentsAsAnnotations() {
        CommentList commentList = this.getComments();
        if (commentList == null) {
            return null;
        }
        return this.sb.makeAnnotations(commentList, this.getContext());
    }

    private Annotations addCommentsToChildAnnotations(Annotations annotations) {
        CommentList commentList = this.getComments();
        if (commentList == null) {
            return annotations;
        }
        if (annotations == null) {
            annotations = this.sb.makeAnnotations(null, this.getContext());
        }
        annotations.addComment(commentList);
        return annotations;
    }

    private Annotations addCommentsToLeadingAnnotations(Annotations annotations) {
        CommentList commentList = this.getComments();
        if (commentList == null) {
            return annotations;
        }
        if (annotations == null) {
            return this.sb.makeAnnotations(commentList, this.getContext());
        }
        annotations.addLeadingComment(commentList);
        return annotations;
    }

    private Annotations getTopLevelCommentsAsAnnotations() {
        CommentList commentList = this.getTopLevelComments();
        if (commentList == null) {
            return null;
        }
        return this.sb.makeAnnotations(commentList, this.getContext());
    }

    private void clearAttributeList() {
        this.attributeNameTable.clear();
    }

    private void addAttribute(Annotations annotations, String string, String string2, String string3, String string4, Token token) {
        String string5 = string + "#" + string2;
        if (this.attributeNameTable.get(string5) != null) {
            this.error("duplicate_attribute", string, string2, token);
        } else {
            this.attributeNameTable.put(string5, string5);
            annotations.addAttribute(string, string2, string3, string4, this.makeLocation(token));
        }
    }

    private void checkExcept(Token[] tokenArray) {
        if (tokenArray[0] != null) {
            this.error("except_missing_parentheses", tokenArray[0]);
        }
    }

    private String lookupPrefix(String string, Token token) {
        String string2 = (String)this.namespaceTable.get(string);
        if (string2 == null) {
            this.error("undeclared_prefix", string, token);
            return "#error";
        }
        return string2;
    }

    private String lookupDatatype(String string, Token token) {
        String string2 = (String)this.datatypesTable.get(string);
        if (string2 == null) {
            this.error("undeclared_prefix", string, token);
            return "";
        }
        return string2;
    }

    private String resolve(String string) {
        try {
            return new URL(new URL(this.sourceUri), string).toString();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    public final ParsedPattern Input(Scope scope) throws ParseException {
        ParsedPattern parsedPattern;
        this.Preamble();
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            parsedPattern = this.TopLevelGrammar(scope);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 10: 
                case 17: 
                case 18: 
                case 19: 
                case 26: 
                case 27: 
                case 28: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 40: 
                case 43: 
                case 54: 
                case 55: 
                case 57: 
                case 58: {
                    parsedPattern = this.Expr(true, scope, null, null);
                    parsedPattern = this.afterComments(parsedPattern);
                    this.jj_consume_token(0);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return parsedPattern;
    }

    public final void TopLevelLookahead() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                this.jj_consume_token(57);
                this.jj_consume_token(1);
                break;
            }
            case 54: 
            case 55: {
                this.Identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break block0;
                    }
                    case 2: {
                        this.jj_consume_token(2);
                        break block0;
                    }
                    case 3: {
                        this.jj_consume_token(3);
                        break block0;
                    }
                    case 4: {
                        this.jj_consume_token(4);
                        break block0;
                    }
                }
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 5: 
            case 6: 
            case 7: {
                this.LookaheadGrammarKeyword();
                break;
            }
            case 1: {
                this.LookaheadBody();
                this.LookaheadAfterAnnotations();
                break;
            }
            case 40: 
            case 43: {
                this.LookaheadDocumentation();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.LookaheadBody();
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                this.LookaheadAfterAnnotations();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void LookaheadAfterAnnotations() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: 
            case 55: {
                this.Identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: {
                        this.jj_consume_token(2);
                        break block0;
                    }
                    case 3: {
                        this.jj_consume_token(3);
                        break block0;
                    }
                    case 4: {
                        this.jj_consume_token(4);
                        break block0;
                    }
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 5: 
            case 6: 
            case 7: {
                this.LookaheadGrammarKeyword();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void LookaheadGrammarKeyword() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void LookaheadDocumentation() throws ParseException {
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 40: {
                    this.jj_consume_token(40);
                    break;
                }
                case 43: {
                    this.jj_consume_token(43);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 41: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(41);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 40: 
                case 43: {
                    continue block10;
                }
            }
            break;
        }
        this.jj_la1[9] = this.jj_gen;
    }

    public final void LookaheadBody() throws ParseException {
        block12: {
            this.jj_consume_token(1);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: 
                    case 57: 
                    case 58: {
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        break block12;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 57: {
                        this.jj_consume_token(57);
                        continue block11;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: {
                        this.UnprefixedName();
                        continue block11;
                    }
                    case 2: {
                        this.jj_consume_token(2);
                        continue block11;
                    }
                    case 58: {
                        this.jj_consume_token(58);
                        continue block11;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        continue block11;
                    }
                    case 1: {
                        this.LookaheadBody();
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[11] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(9);
    }

    public final ParsedPattern IncludedGrammar(IncludedGrammar includedGrammar) throws ParseException {
        Annotations annotations;
        this.Preamble();
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            annotations = this.GrammarBody(includedGrammar, includedGrammar, this.getTopLevelCommentsAsAnnotations());
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 10: 
                case 40: 
                case 43: {
                    annotations = this.Annotations();
                    this.jj_consume_token(10);
                    this.jj_consume_token(11);
                    annotations = this.GrammarBody(includedGrammar, includedGrammar, annotations);
                    this.topLevelComments(includedGrammar);
                    this.jj_consume_token(12);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        ParsedPattern parsedPattern = this.afterComments(includedGrammar.endIncludedGrammar(this.sb.makeLocation(this.sourceUri, 1, 1), annotations));
        this.jj_consume_token(0);
        return parsedPattern;
    }

    public final ParsedPattern TopLevelGrammar(Scope scope) throws ParseException {
        Annotations annotations = this.getTopLevelCommentsAsAnnotations();
        Grammar grammar = this.sb.makeGrammar(scope);
        annotations = this.GrammarBody(grammar, grammar, annotations);
        ParsedPattern parsedPattern = this.afterComments(grammar.endGrammar(this.sb.makeLocation(this.sourceUri, 1, 1), annotations));
        this.jj_consume_token(0);
        return parsedPattern;
    }

    public final void Preamble() throws ParseException {
        block9: {
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 16: {
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: {
                        this.NamespaceDecl();
                        continue block7;
                    }
                    case 16: {
                        this.DatatypesDecl();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[14] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.namespaceTable.put("xml", "http://www.w3.org/XML/1998/namespace");
        if (this.datatypesTable.get("xsd") == null) {
            this.datatypesTable.put("xsd", "http://www.w3.org/2001/XMLSchema-datatypes");
        }
    }

    public final void NamespaceDecl() throws ParseException {
        LocatedString locatedString = null;
        boolean bl = false;
        this.noteTopLevelComments();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                locatedString = this.UnprefixedName();
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                bl = true;
                this.jj_consume_token(13);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: {
                        locatedString = this.UnprefixedName();
                        break block0;
                    }
                }
                this.jj_la1[15] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(2);
        String string = this.NamespaceName();
        if (bl) {
            this.defaultNamespace = string;
        }
        if (locatedString != null) {
            if (locatedString.getString().equals("xmlns")) {
                this.error("xmlns_prefix", locatedString.getToken());
            } else if (locatedString.getString().equals("xml")) {
                if (!string.equals("http://www.w3.org/XML/1998/namespace")) {
                    this.error("xml_prefix_bad_uri", locatedString.getToken());
                }
            } else if (string.equals("http://www.w3.org/XML/1998/namespace")) {
                this.error("xml_uri_bad_prefix", locatedString.getToken());
            } else {
                if (string.equals("http://relaxng.org/ns/compatibility/annotations/1.0")) {
                    this.compatibilityPrefix = locatedString.getString();
                }
                this.namespaceTable.put(locatedString.getString(), string);
            }
        }
    }

    public final String NamespaceName() throws ParseException {
        String string;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                string = this.Literal();
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                string = SchemaBuilder.INHERIT_NS;
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string;
    }

    public final void DatatypesDecl() throws ParseException {
        this.noteTopLevelComments();
        this.jj_consume_token(16);
        LocatedString locatedString = this.UnprefixedName();
        this.jj_consume_token(2);
        String string = this.Literal();
        this.datatypesTable.put(locatedString.getString(), string);
    }

    public final ParsedPattern AnnotatedPrimaryExpr(boolean bl, Scope scope, Token[] tokenArray) throws ParseException {
        Annotations annotations = this.Annotations();
        ParsedPattern parsedPattern = this.PrimaryExpr(bl, scope, annotations, tokenArray);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block3;
                }
            }
            Token token = this.jj_consume_token(59);
            ParsedElementAnnotation parsedElementAnnotation = this.AnnotationElement(false);
            if (bl) {
                this.error("top_level_follow_annotation", token);
                continue;
            }
            parsedPattern = this.sb.annotateAfter(parsedPattern, parsedElementAnnotation);
        }
        return parsedPattern;
    }

    public final ParsedPattern PrimaryExpr(boolean bl, Scope scope, Annotations annotations, Token[] tokenArray) throws ParseException {
        ParsedPattern parsedPattern;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                parsedPattern = this.ElementExpr(scope, annotations);
                break;
            }
            case 27: {
                parsedPattern = this.AttributeExpr(scope, annotations);
                break;
            }
            case 10: {
                parsedPattern = this.GrammarExpr(scope, annotations);
                break;
            }
            case 33: {
                parsedPattern = this.ExternalRefExpr(scope, annotations);
                break;
            }
            case 31: {
                parsedPattern = this.ListExpr(scope, annotations);
                break;
            }
            case 32: {
                parsedPattern = this.MixedExpr(scope, annotations);
                break;
            }
            case 28: {
                parsedPattern = this.ParenExpr(bl, scope, annotations);
                break;
            }
            case 54: 
            case 55: {
                parsedPattern = this.IdentifierExpr(scope, annotations);
                break;
            }
            case 34: {
                parsedPattern = this.ParentExpr(scope, annotations);
                break;
            }
            case 35: 
            case 36: 
            case 57: {
                parsedPattern = this.DataExpr(bl, scope, annotations, tokenArray);
                break;
            }
            case 58: {
                parsedPattern = this.ValueExpr(bl, annotations);
                break;
            }
            case 18: {
                parsedPattern = this.TextExpr(annotations);
                break;
            }
            case 17: {
                parsedPattern = this.EmptyExpr(annotations);
                break;
            }
            case 19: {
                parsedPattern = this.NotAllowedExpr(annotations);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return parsedPattern;
    }

    public final ParsedPattern EmptyExpr(Annotations annotations) throws ParseException {
        Token token = this.jj_consume_token(17);
        return this.sb.makeEmpty(this.makeLocation(token), annotations);
    }

    public final ParsedPattern TextExpr(Annotations annotations) throws ParseException {
        Token token = this.jj_consume_token(18);
        return this.sb.makeText(this.makeLocation(token), annotations);
    }

    public final ParsedPattern NotAllowedExpr(Annotations annotations) throws ParseException {
        Token token = this.jj_consume_token(19);
        return this.sb.makeNotAllowed(this.makeLocation(token), annotations);
    }

    public final ParsedPattern Expr(boolean bl, Scope scope, Token token, Annotations annotations) throws ParseException {
        ParsedPattern parsedPattern;
        ParsedPattern[] parsedPatternArray = new ParsedPattern[2];
        int n = 1;
        boolean[] blArray = new boolean[1];
        Token[] tokenArray = new Token[1];
        parsedPatternArray[0] = parsedPattern = this.UnaryExpr(bl, scope, blArray, tokenArray);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: 
            case 21: 
            case 22: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        this.checkExcept(tokenArray);
                        block17: while (true) {
                            token = this.jj_consume_token(20);
                            parsedPattern = this.UnaryExpr(bl, scope, null, tokenArray);
                            parsedPatternArray = CompactSyntax.addPattern(parsedPatternArray, n++, parsedPattern);
                            this.checkExcept(tokenArray);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 20: {
                                    continue block17;
                                }
                            }
                            break;
                        }
                        this.jj_la1[20] = this.jj_gen;
                        parsedPattern = this.sb.makeChoice(parsedPatternArray, n, this.makeLocation(token), annotations);
                        break block0;
                    }
                    case 21: {
                        block18: while (true) {
                            token = this.jj_consume_token(21);
                            parsedPattern = this.UnaryExpr(bl, scope, null, tokenArray);
                            parsedPatternArray = CompactSyntax.addPattern(parsedPatternArray, n++, parsedPattern);
                            this.checkExcept(tokenArray);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 21: {
                                    continue block18;
                                }
                            }
                            break;
                        }
                        this.jj_la1[21] = this.jj_gen;
                        parsedPattern = this.sb.makeInterleave(parsedPatternArray, n, this.makeLocation(token), annotations);
                        break block0;
                    }
                    case 22: {
                        block19: while (true) {
                            token = this.jj_consume_token(22);
                            parsedPattern = this.UnaryExpr(bl, scope, null, tokenArray);
                            parsedPatternArray = CompactSyntax.addPattern(parsedPatternArray, n++, parsedPattern);
                            this.checkExcept(tokenArray);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 22: {
                                    continue block19;
                                }
                            }
                            break;
                        }
                        this.jj_la1[22] = this.jj_gen;
                        parsedPattern = this.sb.makeGroup(parsedPatternArray, n, this.makeLocation(token), annotations);
                        break block0;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        if (n == 1 && annotations != null) {
            parsedPattern = blArray[0] ? this.sb.annotate(parsedPattern, annotations) : this.sb.makeGroup(parsedPatternArray, n, this.makeLocation(token), annotations);
        }
        return parsedPattern;
    }

    public final ParsedPattern UnaryExpr(boolean bl, Scope scope, boolean[] blArray, Token[] tokenArray) throws ParseException {
        ParsedPattern parsedPattern = this.AnnotatedPrimaryExpr(bl, scope, tokenArray);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: 
            case 24: 
            case 25: {
                Token token;
                if (blArray != null) {
                    blArray[0] = true;
                }
                parsedPattern = this.afterComments(parsedPattern);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        token = this.jj_consume_token(23);
                        this.checkExcept(tokenArray);
                        parsedPattern = this.sb.makeOneOrMore(parsedPattern, this.makeLocation(token), null);
                        break;
                    }
                    case 24: {
                        token = this.jj_consume_token(24);
                        this.checkExcept(tokenArray);
                        parsedPattern = this.sb.makeOptional(parsedPattern, this.makeLocation(token), null);
                        break;
                    }
                    case 25: {
                        token = this.jj_consume_token(25);
                        this.checkExcept(tokenArray);
                        parsedPattern = this.sb.makeZeroOrMore(parsedPattern, this.makeLocation(token), null);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 59: {
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            break block0;
                        }
                    }
                    token = this.jj_consume_token(59);
                    ParsedElementAnnotation parsedElementAnnotation = this.AnnotationElement(false);
                    if (bl) {
                        this.error("top_level_follow_annotation", token);
                        continue;
                    }
                    parsedPattern = this.sb.annotateAfter(parsedPattern, parsedElementAnnotation);
                }
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        return parsedPattern;
    }

    public final ParsedPattern ElementExpr(Scope scope, Annotations annotations) throws ParseException {
        Token token = this.jj_consume_token(26);
        ParsedNameClass parsedNameClass = this.NameClass(0, null);
        this.jj_consume_token(11);
        ParsedPattern parsedPattern = this.Expr(false, scope, null, null);
        parsedPattern = this.afterComments(parsedPattern);
        this.jj_consume_token(12);
        return this.sb.makeElement(parsedNameClass, parsedPattern, this.makeLocation(token), annotations);
    }

    public final ParsedPattern AttributeExpr(Scope scope, Annotations annotations) throws ParseException {
        Token token = this.jj_consume_token(27);
        ParsedNameClass parsedNameClass = this.NameClass(1, null);
        this.jj_consume_token(11);
        ParsedPattern parsedPattern = this.Expr(false, scope, null, null);
        parsedPattern = this.afterComments(parsedPattern);
        this.jj_consume_token(12);
        return this.sb.makeAttribute(parsedNameClass, parsedPattern, this.makeLocation(token), annotations);
    }

    public final ParsedNameClass NameClass(int n, Annotations[] annotationsArray) throws ParseException {
        ParsedNameClass parsedNameClass;
        Annotations annotations = this.Annotations();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: 
            case 57: {
                parsedNameClass = this.PrimaryNameClass(n, annotations);
                parsedNameClass = this.AnnotateAfter(parsedNameClass);
                parsedNameClass = this.NameClassAlternatives(n, parsedNameClass, annotationsArray);
                break;
            }
            case 25: {
                parsedNameClass = this.AnyNameExceptClass(n, annotations, annotationsArray);
                break;
            }
            case 56: {
                parsedNameClass = this.NsNameExceptClass(n, annotations, annotationsArray);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return parsedNameClass;
    }

    public final ParsedNameClass AnnotateAfter(ParsedNameClass parsedNameClass) throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(59);
            ParsedElementAnnotation parsedElementAnnotation = this.AnnotationElement(false);
            parsedNameClass = this.sb.annotateAfter(parsedNameClass, parsedElementAnnotation);
        }
        return parsedNameClass;
    }

    public final ParsedNameClass NameClassAlternatives(int n, ParsedNameClass parsedNameClass, Annotations[] annotationsArray) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                Object object;
                Token token;
                ParsedNameClass[] parsedNameClassArray = new ParsedNameClass[2];
                parsedNameClassArray[0] = parsedNameClass;
                int n2 = 1;
                block6: while (true) {
                    token = this.jj_consume_token(20);
                    parsedNameClass = this.BasicNameClass(n);
                    parsedNameClass = this.AnnotateAfter(parsedNameClass);
                    if (n2 >= parsedNameClassArray.length) {
                        object = parsedNameClassArray;
                        parsedNameClassArray = new ParsedNameClass[((ParsedNameClass[])object).length * 2];
                        System.arraycopy(object, 0, parsedNameClassArray, 0, ((ParsedNameClass[])object).length);
                    }
                    parsedNameClassArray[n2++] = parsedNameClass;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 20: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[30] = this.jj_gen;
                if (annotationsArray == null) {
                    object = null;
                } else {
                    object = annotationsArray[0];
                    annotationsArray[0] = null;
                }
                parsedNameClass = this.sb.makeChoice(parsedNameClassArray, n2, this.makeLocation(token), (Annotations)object);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        return parsedNameClass;
    }

    public final ParsedNameClass BasicNameClass(int n) throws ParseException {
        ParsedNameClass parsedNameClass;
        Annotations annotations = this.Annotations();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: 
            case 57: {
                parsedNameClass = this.PrimaryNameClass(n, annotations);
                break;
            }
            case 25: 
            case 56: {
                parsedNameClass = this.OpenNameClass(n, annotations);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return parsedNameClass;
    }

    public final ParsedNameClass PrimaryNameClass(int n, Annotations annotations) throws ParseException {
        ParsedNameClass parsedNameClass;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: {
                parsedNameClass = this.UnprefixedNameClass(n, annotations);
                break;
            }
            case 57: {
                parsedNameClass = this.PrefixedNameClass(annotations);
                break;
            }
            case 28: {
                parsedNameClass = this.ParenNameClass(n, annotations);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return parsedNameClass;
    }

    public final ParsedNameClass OpenNameClass(int n, Annotations annotations) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                LocatedString locatedString = this.NsName();
                this.checkNsName(n, locatedString);
                return this.sb.makeNsName(locatedString.getString(), locatedString.getLocation(), annotations);
            }
            case 25: {
                Token token = this.jj_consume_token(25);
                this.checkAnyName(n, token);
                return this.sb.makeAnyName(this.makeLocation(token), annotations);
            }
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ParsedNameClass UnprefixedNameClass(int n, Annotations annotations) throws ParseException {
        LocatedString locatedString = this.UnprefixedName();
        String string = (n & 1) == 1 ? "" : this.defaultNamespace;
        return this.sb.makeName(string, locatedString.getString(), null, locatedString.getLocation(), annotations);
    }

    public final ParsedNameClass PrefixedNameClass(Annotations annotations) throws ParseException {
        Token token = this.jj_consume_token(57);
        String string = token.image;
        int n = string.indexOf(58);
        String string2 = string.substring(0, n);
        return this.sb.makeName(this.lookupPrefix(string2, token), string.substring(n + 1), string2, this.makeLocation(token), annotations);
    }

    public final ParsedNameClass NsNameExceptClass(int n, Annotations annotations, Annotations[] annotationsArray) throws ParseException {
        ParsedNameClass parsedNameClass;
        LocatedString locatedString = this.NsName();
        this.checkNsName(n, locatedString);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                parsedNameClass = this.ExceptNameClass(n | 4);
                parsedNameClass = this.sb.makeNsName(locatedString.getString(), parsedNameClass, locatedString.getLocation(), annotations);
                parsedNameClass = this.AnnotateAfter(parsedNameClass);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                parsedNameClass = this.sb.makeNsName(locatedString.getString(), locatedString.getLocation(), annotations);
                parsedNameClass = this.AnnotateAfter(parsedNameClass);
                parsedNameClass = this.NameClassAlternatives(n, parsedNameClass, annotationsArray);
            }
        }
        return parsedNameClass;
    }

    public final LocatedString NsName() throws ParseException {
        Token token = this.jj_consume_token(56);
        String string = token.image;
        String string2 = string.substring(0, string.length() - 2);
        return new LocatedString(this.lookupPrefix(string2, token), token);
    }

    public final ParsedNameClass AnyNameExceptClass(int n, Annotations annotations, Annotations[] annotationsArray) throws ParseException {
        ParsedNameClass parsedNameClass;
        Token token = this.jj_consume_token(25);
        this.checkAnyName(n, token);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                parsedNameClass = this.ExceptNameClass(n | 2);
                parsedNameClass = this.sb.makeAnyName(parsedNameClass, this.makeLocation(token), annotations);
                parsedNameClass = this.AnnotateAfter(parsedNameClass);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                parsedNameClass = this.sb.makeAnyName(this.makeLocation(token), annotations);
                parsedNameClass = this.AnnotateAfter(parsedNameClass);
                parsedNameClass = this.NameClassAlternatives(n, parsedNameClass, annotationsArray);
            }
        }
        return parsedNameClass;
    }

    public final ParsedNameClass ParenNameClass(int n, Annotations annotations) throws ParseException {
        Annotations[] annotationsArray = new Annotations[]{annotations};
        Token token = this.jj_consume_token(28);
        ParsedNameClass parsedNameClass = this.NameClass(n, annotationsArray);
        parsedNameClass = this.afterComments(parsedNameClass);
        this.jj_consume_token(29);
        if (annotationsArray[0] != null) {
            parsedNameClass = this.sb.makeChoice(new ParsedNameClass[]{parsedNameClass}, 1, this.makeLocation(token), annotationsArray[0]);
        }
        return parsedNameClass;
    }

    public final ParsedNameClass ExceptNameClass(int n) throws ParseException {
        this.jj_consume_token(30);
        ParsedNameClass parsedNameClass = this.BasicNameClass(n);
        return parsedNameClass;
    }

    public final ParsedPattern ListExpr(Scope scope, Annotations annotations) throws ParseException {
        Token token = this.jj_consume_token(31);
        this.jj_consume_token(11);
        ParsedPattern parsedPattern = this.Expr(false, scope, null, null);
        parsedPattern = this.afterComments(parsedPattern);
        this.jj_consume_token(12);
        return this.sb.makeList(parsedPattern, this.makeLocation(token), annotations);
    }

    public final ParsedPattern MixedExpr(Scope scope, Annotations annotations) throws ParseException {
        Token token = this.jj_consume_token(32);
        this.jj_consume_token(11);
        ParsedPattern parsedPattern = this.Expr(false, scope, null, null);
        parsedPattern = this.afterComments(parsedPattern);
        this.jj_consume_token(12);
        return this.sb.makeMixed(parsedPattern, this.makeLocation(token), annotations);
    }

    public final ParsedPattern GrammarExpr(Scope scope, Annotations annotations) throws ParseException {
        Token token = this.jj_consume_token(10);
        Grammar grammar = this.sb.makeGrammar(scope);
        this.jj_consume_token(11);
        annotations = this.GrammarBody(grammar, grammar, annotations);
        this.topLevelComments(grammar);
        this.jj_consume_token(12);
        return grammar.endGrammar(this.makeLocation(token), annotations);
    }

    public final ParsedPattern ParenExpr(boolean bl, Scope scope, Annotations annotations) throws ParseException {
        Token token = this.jj_consume_token(28);
        ParsedPattern parsedPattern = this.Expr(bl, scope, token, annotations);
        parsedPattern = this.afterComments(parsedPattern);
        this.jj_consume_token(29);
        return parsedPattern;
    }

    public final Annotations GrammarBody(GrammarSection grammarSection, Scope scope, Annotations annotations) throws ParseException {
        while (this.jj_2_3(2)) {
            ParsedElementAnnotation parsedElementAnnotation = this.AnnotationElementNotKeyword();
            if (annotations == null) {
                annotations = this.sb.makeAnnotations(null, this.getContext());
            }
            annotations.addElement(parsedElementAnnotation);
        }
        block4: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 40: 
                case 43: 
                case 54: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block4;
                }
            }
            this.GrammarComponent(grammarSection, scope);
        }
        return annotations;
    }

    public final void GrammarComponent(GrammarSection grammarSection, Scope scope) throws ParseException {
        Annotations annotations = this.Annotations();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 54: 
            case 55: {
                this.Definition(grammarSection, scope, annotations);
                break;
            }
            case 7: {
                this.Include(grammarSection, scope, annotations);
                break;
            }
            case 6: {
                this.Div(grammarSection, scope, annotations);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        while (this.jj_2_4(2)) {
            ParsedElementAnnotation parsedElementAnnotation = this.AnnotationElementNotKeyword();
            grammarSection.topLevelAnnotation(parsedElementAnnotation);
        }
    }

    public final void Definition(GrammarSection grammarSection, Scope scope, Annotations annotations) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: 
            case 55: {
                this.Define(grammarSection, scope, annotations);
                break;
            }
            case 5: {
                this.Start(grammarSection, scope, annotations);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Start(GrammarSection grammarSection, Scope scope, Annotations annotations) throws ParseException {
        Token token = this.jj_consume_token(5);
        GrammarSection.Combine combine = this.AssignOp();
        ParsedPattern parsedPattern = this.Expr(false, scope, null, null);
        grammarSection.define(GrammarSection.START, combine, parsedPattern, this.makeLocation(token), annotations);
    }

    public final void Define(GrammarSection grammarSection, Scope scope, Annotations annotations) throws ParseException {
        LocatedString locatedString = this.Identifier();
        GrammarSection.Combine combine = this.AssignOp();
        ParsedPattern parsedPattern = this.Expr(false, scope, null, null);
        grammarSection.define(locatedString.getString(), combine, parsedPattern, locatedString.getLocation(), annotations);
    }

    public final GrammarSection.Combine AssignOp() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                return null;
            }
            case 4: {
                this.jj_consume_token(4);
                return GrammarSection.COMBINE_CHOICE;
            }
            case 3: {
                this.jj_consume_token(3);
                return GrammarSection.COMBINE_INTERLEAVE;
            }
        }
        this.jj_la1[40] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void Include(GrammarSection grammarSection, Scope scope, Annotations annotations) throws ParseException {
        Include include = grammarSection.makeInclude();
        Token token = this.jj_consume_token(7);
        String string = this.Literal();
        String string2 = this.Inherit();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                annotations = this.IncludeBody(include, scope, annotations);
                this.topLevelComments(include);
                this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        try {
            include.endInclude(this.resolve(string), string2, this.makeLocation(token), annotations);
        }
        catch (IllegalSchemaException illegalSchemaException) {}
    }

    public final Annotations IncludeBody(GrammarSection grammarSection, Scope scope, Annotations annotations) throws ParseException {
        while (this.jj_2_5(2)) {
            ParsedElementAnnotation parsedElementAnnotation = this.AnnotationElementNotKeyword();
            if (annotations == null) {
                annotations = this.sb.makeAnnotations(null, this.getContext());
            }
            annotations.addElement(parsedElementAnnotation);
        }
        block4: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 5: 
                case 6: 
                case 40: 
                case 43: 
                case 54: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block4;
                }
            }
            this.IncludeComponent(grammarSection, scope);
        }
        return annotations;
    }

    public final void IncludeComponent(GrammarSection grammarSection, Scope scope) throws ParseException {
        Annotations annotations = this.Annotations();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 54: 
            case 55: {
                this.Definition(grammarSection, scope, annotations);
                break;
            }
            case 6: {
                this.IncludeDiv(grammarSection, scope, annotations);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        while (this.jj_2_6(2)) {
            ParsedElementAnnotation parsedElementAnnotation = this.AnnotationElementNotKeyword();
            grammarSection.topLevelAnnotation(parsedElementAnnotation);
        }
    }

    public final void Div(GrammarSection grammarSection, Scope scope, Annotations annotations) throws ParseException {
        Div div = grammarSection.makeDiv();
        Token token = this.jj_consume_token(6);
        this.jj_consume_token(11);
        annotations = this.GrammarBody(div, scope, annotations);
        this.topLevelComments(div);
        this.jj_consume_token(12);
        div.endDiv(this.makeLocation(token), annotations);
    }

    public final void IncludeDiv(GrammarSection grammarSection, Scope scope, Annotations annotations) throws ParseException {
        Div div = grammarSection.makeDiv();
        Token token = this.jj_consume_token(6);
        this.jj_consume_token(11);
        annotations = this.IncludeBody(div, scope, annotations);
        this.topLevelComments(div);
        this.jj_consume_token(12);
        div.endDiv(this.makeLocation(token), annotations);
    }

    public final ParsedPattern ExternalRefExpr(Scope scope, Annotations annotations) throws ParseException {
        Token token = this.jj_consume_token(33);
        String string = this.Literal();
        String string2 = this.Inherit();
        try {
            return this.sb.makeExternalRef(this.resolve(string), string2, scope, this.makeLocation(token), annotations);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            return this.sb.makeErrorPattern();
        }
    }

    public final String Inherit() throws ParseException {
        String string = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                this.jj_consume_token(2);
                string = this.Prefix();
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        if (string == null) {
            string = this.defaultNamespace;
        }
        return string;
    }

    public final ParsedPattern ParentExpr(Scope scope, Annotations annotations) throws ParseException {
        this.jj_consume_token(34);
        annotations = this.addCommentsToChildAnnotations(annotations);
        LocatedString locatedString = this.Identifier();
        return scope.makeParentRef(locatedString.getString(), locatedString.getLocation(), annotations);
    }

    public final ParsedPattern IdentifierExpr(Scope scope, Annotations annotations) throws ParseException {
        LocatedString locatedString = this.Identifier();
        return scope.makeRef(locatedString.getString(), locatedString.getLocation(), annotations);
    }

    public final ParsedPattern ValueExpr(boolean bl, Annotations annotations) throws ParseException {
        LocatedString locatedString = this.LocatedLiteral();
        if (bl && this.annotationsIncludeElements) {
            this.error("top_level_follow_annotation", locatedString.getToken());
            annotations = null;
        }
        return this.sb.makeValue("", "token", locatedString.getString(), this.getContext(), this.defaultNamespace, locatedString.getLocation(), annotations);
    }

    public final ParsedPattern DataExpr(boolean bl, Scope scope, Annotations annotations, Token[] tokenArray) throws ParseException {
        String string = null;
        String string2 = null;
        ParsedPattern parsedPattern = null;
        Token token = this.DatatypeName();
        String string3 = token.image;
        Location location = this.makeLocation(token);
        int n = string3.indexOf(58);
        if (n < 0) {
            string = "";
        } else {
            String string4 = string3.substring(0, n);
            string = this.lookupDatatype(string4, token);
            string3 = string3.substring(n + 1);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                string2 = this.Literal();
                if (bl && this.annotationsIncludeElements) {
                    this.error("top_level_follow_annotation", token);
                    annotations = null;
                }
                return this.sb.makeValue(string, string3, string2, this.getContext(), this.defaultNamespace, location, annotations);
            }
        }
        this.jj_la1[48] = this.jj_gen;
        DataPatternBuilder dataPatternBuilder = this.sb.makeDataPatternBuilder(string, string3, location);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.Params(dataPatternBuilder);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        parsedPattern = this.Except(scope, tokenArray);
                        break block3;
                    }
                }
                this.jj_la1[45] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        parsedPattern = this.Except(scope, tokenArray);
                        break block3;
                    }
                }
                this.jj_la1[46] = this.jj_gen;
            }
        }
        return parsedPattern == null ? dataPatternBuilder.makePattern(location, annotations) : dataPatternBuilder.makePattern(parsedPattern, location, annotations);
    }

    public final Token DatatypeName() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                token = this.jj_consume_token(35);
                break;
            }
            case 36: {
                token = this.jj_consume_token(36);
                break;
            }
            case 57: {
                token = this.jj_consume_token(57);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    public final LocatedString Identifier() throws ParseException {
        LocatedString locatedString;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                Token token = this.jj_consume_token(54);
                locatedString = new LocatedString(token.image, token);
                break;
            }
            case 55: {
                Token token = this.jj_consume_token(55);
                locatedString = new LocatedString(token.image.substring(1), token);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return locatedString;
    }

    public final String Prefix() throws ParseException {
        String string;
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                token = this.jj_consume_token(54);
                string = token.image;
                break;
            }
            case 55: {
                token = this.jj_consume_token(55);
                string = token.image.substring(1);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                token = this.Keyword();
                string = token.image;
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.lookupPrefix(string, token);
    }

    public final LocatedString UnprefixedName() throws ParseException {
        LocatedString locatedString;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: 
            case 55: {
                locatedString = this.Identifier();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                Token token = this.Keyword();
                locatedString = new LocatedString(token.image, token);
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return locatedString;
    }

    public final void Params(DataPatternBuilder dataPatternBuilder) throws ParseException {
        this.jj_consume_token(11);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 40: 
                case 43: 
                case 54: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break block3;
                }
            }
            this.Param(dataPatternBuilder);
        }
        this.jj_consume_token(12);
    }

    public final void Param(DataPatternBuilder dataPatternBuilder) throws ParseException {
        Annotations annotations = this.Annotations();
        LocatedString locatedString = this.UnprefixedName();
        this.jj_consume_token(2);
        annotations = this.addCommentsToLeadingAnnotations(annotations);
        String string = this.Literal();
        dataPatternBuilder.addParam(locatedString.getString(), string, this.getContext(), this.defaultNamespace, locatedString.getLocation(), annotations);
    }

    public final ParsedPattern Except(Scope scope, Token[] tokenArray) throws ParseException {
        Token[] tokenArray2 = new Token[1];
        Token token = this.jj_consume_token(30);
        Annotations annotations = this.Annotations();
        ParsedPattern parsedPattern = this.PrimaryExpr(false, scope, annotations, tokenArray2);
        this.checkExcept(tokenArray2);
        tokenArray[0] = token;
        return parsedPattern;
    }

    public final ParsedElementAnnotation Documentation() throws ParseException {
        Token token;
        CommentList commentList = this.getComments();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                token = this.jj_consume_token(40);
                break;
            }
            case 43: {
                token = this.jj_consume_token(43);
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ElementAnnotationBuilder elementAnnotationBuilder = this.sb.makeElementAnnotationBuilder("http://relaxng.org/ns/compatibility/annotations/1.0", "documentation", this.getCompatibilityPrefix(), this.makeLocation(token), commentList, this.getContext());
        elementAnnotationBuilder.addText(CompactSyntax.mungeComment(token.image), this.makeLocation(token), null);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block7;
                }
            }
            token = this.jj_consume_token(41);
            elementAnnotationBuilder.addText("\n" + CompactSyntax.mungeComment(token.image), this.makeLocation(token), null);
        }
        return elementAnnotationBuilder.makeElementAnnotation();
    }

    public final Annotations Annotations() throws ParseException {
        ParsedElementAnnotation parsedElementAnnotation;
        CommentList commentList = this.getComments();
        Annotations annotations = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: 
            case 43: {
                annotations = this.sb.makeAnnotations(commentList, this.getContext());
                block12: while (true) {
                    parsedElementAnnotation = this.Documentation();
                    annotations.addElement(parsedElementAnnotation);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 40: 
                        case 43: {
                            continue block12;
                        }
                    }
                    break;
                }
                this.jj_la1[56] = this.jj_gen;
                commentList = this.getComments();
                if (commentList == null) break;
                annotations.addLeadingComment(commentList);
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                if (annotations == null) {
                    annotations = this.sb.makeAnnotations(commentList, this.getContext());
                }
                this.clearAttributeList();
                this.annotationsIncludeElements = false;
                while (this.jj_2_7(2)) {
                    this.PrefixedAnnotationAttribute(annotations, false);
                }
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 10: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 26: 
                        case 27: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 54: 
                        case 55: 
                        case 57: {
                            break;
                        }
                        default: {
                            this.jj_la1[58] = this.jj_gen;
                            break block14;
                        }
                    }
                    parsedElementAnnotation = this.AnnotationElement(false);
                    annotations.addElement(parsedElementAnnotation);
                    this.annotationsIncludeElements = true;
                }
                annotations.addComment(this.getComments());
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
        if (annotations == null && commentList != null) {
            annotations = this.sb.makeAnnotations(commentList, this.getContext());
        }
        return annotations;
    }

    public final void AnnotationAttribute(Annotations annotations) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                this.PrefixedAnnotationAttribute(annotations, true);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: {
                this.UnprefixedAnnotationAttribute(annotations);
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PrefixedAnnotationAttribute(Annotations annotations, boolean bl) throws ParseException {
        Token token = this.jj_consume_token(57);
        this.jj_consume_token(2);
        String string = this.Literal();
        String string2 = token.image;
        int n = string2.indexOf(58);
        String string3 = string2.substring(0, n);
        String string4 = this.lookupPrefix(string3, token);
        if (string4 == SchemaBuilder.INHERIT_NS) {
            this.error("inherited_annotation_namespace", token);
        } else if (string4.length() == 0 && !bl) {
            this.error("unqualified_annotation_attribute", token);
        } else if (string4.equals("http://relaxng.org/ns/structure/1.0") && !bl) {
            this.error("relax_ng_namespace", token);
        } else if (string4.equals("http://www.w3.org/2000/xmlns")) {
            this.error("xmlns_annotation_attribute_uri", token);
        } else {
            if (string4.length() == 0) {
                string3 = null;
            }
            this.addAttribute(annotations, string4, string2.substring(n + 1), string3, string, token);
        }
    }

    public final void UnprefixedAnnotationAttribute(Annotations annotations) throws ParseException {
        LocatedString locatedString = this.UnprefixedName();
        this.jj_consume_token(2);
        String string = this.Literal();
        if (locatedString.getString().equals("xmlns")) {
            this.error("xmlns_annotation_attribute", locatedString.getToken());
        } else {
            this.addAttribute(annotations, "", locatedString.getString(), null, string, locatedString.getToken());
        }
    }

    public final ParsedElementAnnotation AnnotationElement(boolean bl) throws ParseException {
        ParsedElementAnnotation parsedElementAnnotation;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                parsedElementAnnotation = this.PrefixedAnnotationElement(bl);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: {
                parsedElementAnnotation = this.UnprefixedAnnotationElement();
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return parsedElementAnnotation;
    }

    public final ParsedElementAnnotation AnnotationElementNotKeyword() throws ParseException {
        ParsedElementAnnotation parsedElementAnnotation;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                parsedElementAnnotation = this.PrefixedAnnotationElement(false);
                break;
            }
            case 54: 
            case 55: {
                parsedElementAnnotation = this.IdentifierAnnotationElement();
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return parsedElementAnnotation;
    }

    public final ParsedElementAnnotation PrefixedAnnotationElement(boolean bl) throws ParseException {
        CommentList commentList = this.getComments();
        Token token = this.jj_consume_token(57);
        String string = token.image;
        int n = string.indexOf(58);
        String string2 = string.substring(0, n);
        String string3 = this.lookupPrefix(string2, token);
        if (string3 == SchemaBuilder.INHERIT_NS) {
            this.error("inherited_annotation_namespace", token);
            string3 = "";
        } else if (!bl && string3.equals("http://relaxng.org/ns/structure/1.0")) {
            this.error("relax_ng_namespace", token);
            string3 = "";
        } else if (string3.length() == 0) {
            string2 = null;
        }
        ElementAnnotationBuilder elementAnnotationBuilder = this.sb.makeElementAnnotationBuilder(string3, string.substring(n + 1), string2, this.makeLocation(token), commentList, this.getContext());
        this.AnnotationElementContent(elementAnnotationBuilder);
        return elementAnnotationBuilder.makeElementAnnotation();
    }

    public final ParsedElementAnnotation UnprefixedAnnotationElement() throws ParseException {
        CommentList commentList = this.getComments();
        LocatedString locatedString = this.UnprefixedName();
        ElementAnnotationBuilder elementAnnotationBuilder = this.sb.makeElementAnnotationBuilder("", locatedString.getString(), null, locatedString.getLocation(), commentList, this.getContext());
        this.AnnotationElementContent(elementAnnotationBuilder);
        return elementAnnotationBuilder.makeElementAnnotation();
    }

    public final ParsedElementAnnotation IdentifierAnnotationElement() throws ParseException {
        CommentList commentList = this.getComments();
        LocatedString locatedString = this.Identifier();
        ElementAnnotationBuilder elementAnnotationBuilder = this.sb.makeElementAnnotationBuilder("", locatedString.getString(), null, locatedString.getLocation(), commentList, this.getContext());
        this.AnnotationElementContent(elementAnnotationBuilder);
        return elementAnnotationBuilder.makeElementAnnotation();
    }

    public final void AnnotationElementContent(ElementAnnotationBuilder elementAnnotationBuilder) throws ParseException {
        block13: {
            this.jj_consume_token(1);
            this.clearAttributeList();
            while (this.jj_2_8(2)) {
                this.AnnotationAttribute(elementAnnotationBuilder);
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: 
                    case 57: 
                    case 58: {
                        break;
                    }
                    default: {
                        this.jj_la1[63] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: {
                        this.AnnotationElementLiteral(elementAnnotationBuilder);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 8: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[64] = this.jj_gen;
                                    continue block11;
                                }
                            }
                            this.jj_consume_token(8);
                            this.AnnotationElementLiteral(elementAnnotationBuilder);
                        }
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: 
                    case 57: {
                        ParsedElementAnnotation parsedElementAnnotation = this.AnnotationElement(true);
                        elementAnnotationBuilder.addElement(parsedElementAnnotation);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[65] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        elementAnnotationBuilder.addComment(this.getComments());
        this.jj_consume_token(9);
    }

    public final void AnnotationElementLiteral(ElementAnnotationBuilder elementAnnotationBuilder) throws ParseException {
        CommentList commentList = this.getComments();
        Token token = this.jj_consume_token(58);
        elementAnnotationBuilder.addText(CompactSyntax.unquote(token.image), this.makeLocation(token), commentList);
    }

    public final String Literal() throws ParseException {
        Token token = this.jj_consume_token(58);
        String string = CompactSyntax.unquote(token.image);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                StringBuffer stringBuffer = new StringBuffer(string);
                block6: while (true) {
                    this.jj_consume_token(8);
                    token = this.jj_consume_token(58);
                    stringBuffer.append(CompactSyntax.unquote(token.image));
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[66] = this.jj_gen;
                string = stringBuffer.toString();
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
            }
        }
        return string;
    }

    public final LocatedString LocatedLiteral() throws ParseException {
        Token token = this.jj_consume_token(58);
        String string = CompactSyntax.unquote(token.image);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                StringBuffer stringBuffer = new StringBuffer(string);
                block6: while (true) {
                    this.jj_consume_token(8);
                    Token token2 = this.jj_consume_token(58);
                    stringBuffer.append(CompactSyntax.unquote(token2.image));
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[68] = this.jj_gen;
                string = stringBuffer.toString();
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
            }
        }
        return new LocatedString(string, token);
    }

    public final Token Keyword() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                token = this.jj_consume_token(26);
                break;
            }
            case 27: {
                token = this.jj_consume_token(27);
                break;
            }
            case 13: {
                token = this.jj_consume_token(13);
                break;
            }
            case 31: {
                token = this.jj_consume_token(31);
                break;
            }
            case 32: {
                token = this.jj_consume_token(32);
                break;
            }
            case 10: {
                token = this.jj_consume_token(10);
                break;
            }
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            case 18: {
                token = this.jj_consume_token(18);
                break;
            }
            case 34: {
                token = this.jj_consume_token(34);
                break;
            }
            case 33: {
                token = this.jj_consume_token(33);
                break;
            }
            case 19: {
                token = this.jj_consume_token(19);
                break;
            }
            case 5: {
                token = this.jj_consume_token(5);
                break;
            }
            case 7: {
                token = this.jj_consume_token(7);
                break;
            }
            case 14: {
                token = this.jj_consume_token(14);
                break;
            }
            case 15: {
                token = this.jj_consume_token(15);
                break;
            }
            case 35: {
                token = this.jj_consume_token(35);
                break;
            }
            case 36: {
                token = this.jj_consume_token(36);
                break;
            }
            case 16: {
                token = this.jj_consume_token(16);
                break;
            }
            case 6: {
                token = this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_1();
        this.jj_save(0, n);
        return bl;
    }

    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_2();
        this.jj_save(1, n);
        return bl;
    }

    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_3();
        this.jj_save(2, n);
        return bl;
    }

    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_4();
        this.jj_save(3, n);
        return bl;
    }

    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_5();
        this.jj_save(4, n);
        return bl;
    }

    private final boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_6();
        this.jj_save(5, n);
        return bl;
    }

    private final boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_7();
        this.jj_save(6, n);
        return bl;
    }

    private final boolean jj_2_8(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_8();
        this.jj_save(7, n);
        return bl;
    }

    private final boolean jj_3R_92() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_91() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_90() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_89() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_88() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_87() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_86() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_85() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_84() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_83() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_82() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_81() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_80() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_79() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = token;
            if (this.jj_3R_81()) {
                this.jj_scanpos = token;
                if (this.jj_3R_82()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_83()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_84()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_85()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_86()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_87()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_88()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_89()) {
                                                this.jj_scanpos = token;
                                                if (this.jj_3R_90()) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_3R_91()) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_3R_92()) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_3R_93()) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_3R_94()) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_3R_95()) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_3R_96()) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_3R_97()) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_3R_98()) {
                                                                                    return true;
                                                                                }
                                                                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                    return false;
                                                                                }
                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                return false;
                                                                            }
                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                            return false;
                                                                        }
                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                        return false;
                                                                    }
                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                    return false;
                                                                }
                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                return false;
                                                            }
                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                            return false;
                                                        }
                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_39() {
        if (this.jj_3R_30()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_31() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = token;
            if (this.jj_3R_40()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_3R_30()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_70() {
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_76() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_3R_31()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_68() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_63() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_67() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_52() {
        if (this.jj_3R_41()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_3R_29()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_28()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_66() {
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_3R_29()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_75() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_78() {
        if (this.jj_3R_79()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_73() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_77() {
        if (this.jj_3R_41()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_45() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_64() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_77()) {
            this.jj_scanpos = token;
            if (this.jj_3R_78()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_58() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_50() {
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_59() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = token;
            if (this.jj_3R_66()) {
                this.jj_scanpos = token;
                if (this.jj_3R_67()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_68()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_69()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_70()) {
                                return true;
                            }
                            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_65() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        Token token;
        block5: {
            if (this.jj_scan_token(1)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_59()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_57() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_74() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_62() {
        Token token;
        block6: {
            token = this.jj_scanpos;
            if (this.jj_3R_74()) {
                this.jj_scanpos = token;
                if (this.jj_3R_75()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_76()) break block6;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_71() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        Token token;
        block3: {
            if (this.jj_3R_62()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_62()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = token;
            if (this.jj_3R_57()) {
                this.jj_scanpos = token;
                if (this.jj_3R_58()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_42() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_56() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_61() {
        if (this.jj_3R_46()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_41() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = token;
            if (this.jj_3R_55()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_51() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_60()) {
            this.jj_scanpos = token;
            if (this.jj_3R_61()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_60() {
        if (this.jj_3R_41()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = token;
            if (this.jj_3R_72()) {
                this.jj_scanpos = token;
                if (this.jj_3R_73()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_36() {
        if (this.jj_3R_49()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_48()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_35() {
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_48()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_34() {
        if (this.jj_3R_46()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_38() {
        if (this.jj_3R_52()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_28()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_33() {
        if (this.jj_3R_41()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = token;
            if (this.jj_3R_43()) {
                this.jj_scanpos = token;
                if (this.jj_3R_44()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_45()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_37() {
        if (this.jj_3R_51()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_28() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = token;
            if (this.jj_3R_33()) {
                this.jj_scanpos = token;
                if (this.jj_3R_34()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_35()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_36()) {
                            return true;
                        }
                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_29() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_37()) {
            this.jj_scanpos = token;
            if (this.jj_3R_38()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_3R_29()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_3R_53()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_98() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_3R_29()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_97() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_96() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_95() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_94() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_93() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public CompactSyntax(InputStream inputStream) {
        this.jj_input_stream = new UCode_UCodeESC_CharStream(inputStream, 1, 1);
        this.token_source = new CompactSyntaxTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 71) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 71) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public CompactSyntax(Reader reader) {
        this.jj_input_stream = new UCode_UCodeESC_CharStream(reader, 1, 1);
        this.token_source = new CompactSyntaxTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 71) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 71) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public CompactSyntax(CompactSyntaxTokenManager compactSyntaxTokenManager) {
        this.token_source = compactSyntaxTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 71) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public void ReInit(CompactSyntaxTokenManager compactSyntaxTokenManager) {
        this.token_source = compactSyntaxTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 71) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int n2 = 0;
                while (n2 < this.jj_2_rtns.length) {
                    JJCalls jJCalls = this.jj_2_rtns[n2];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                    ++n2;
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        return this.jj_scanpos.kind != n;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
            ++n2;
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int n3 = 0;
            while (n3 < this.jj_endpos) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
                ++n3;
            }
            boolean bl = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                bl = true;
                int n4 = 0;
                while (n4 < this.jj_expentry.length) {
                    if (nArray[n4] != this.jj_expentry[n4]) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (bl) break;
            }
            if (!bl) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public final ParseException generateParseException() {
        int n;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[61];
        int n2 = 0;
        while (n2 < 61) {
            blArray[n2] = false;
            ++n2;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int n3 = 0;
        while (n3 < 71) {
            if (this.jj_la1[n3] == this.jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((this.jj_la1_0[n3] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    if ((this.jj_la1_1[n3] & 1 << n) != 0) {
                        blArray[32 + n] = true;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < 61) {
            if (blArray[n]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = n;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++n;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        int n4 = 0;
        while (n4 < this.jj_expentries.size()) {
            nArrayArray[n4] = (int[])this.jj_expentries.elementAt(n4);
            ++n4;
        }
        return new ParseException(this.token, nArrayArray, CompactSyntaxConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int n = 0;
        while (n < 8) {
            JJCalls jJCalls = this.jj_2_rtns[n];
            do {
                if (jJCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                switch (n) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
            ++n;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    final class LocatedString {
        private final String str;
        private final Token tok;

        LocatedString(String string, Token token) {
            this.str = string;
            this.tok = token;
        }

        String getString() {
            return this.str;
        }

        Location getLocation() {
            return CompactSyntax.this.makeLocation(this.tok);
        }

        Token getToken() {
            return this.tok;
        }
    }
}

