/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class XmlReferenceInspectionBase
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XmlReferenceInspectionBase.$$$reportNull$$$0(0);
        }
        return new XmlElementVisitor(){

            public void visitXmlAttributeValue(@NotNull XmlAttributeValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                XmlReferenceInspectionBase.this.checkRefs((XmlElement)value, holder, 0);
            }

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                if (attribute == null) {
                    1.$$$reportNull$$$0(1);
                }
                int startIndex = !attribute.getNamespacePrefix().isEmpty() ? 2 : 1;
                XmlReferenceInspectionBase.this.checkRefs((XmlElement)attribute, holder, startIndex);
            }

            public void visitXmlDoctype(@NotNull XmlDoctype xmlDoctype) {
                if (xmlDoctype == null) {
                    1.$$$reportNull$$$0(2);
                }
                XmlReferenceInspectionBase.this.checkRefs((XmlElement)xmlDoctype, holder, 0);
            }

            public void visitXmlTag(@NotNull XmlTag tag) {
                if (tag == null) {
                    1.$$$reportNull$$$0(3);
                }
                XmlReferenceInspectionBase.this.checkRefs((XmlElement)tag, holder, 0);
            }

            public void visitXmlProcessingInstruction(@NotNull XmlProcessingInstruction processingInstruction) {
                if (processingInstruction == null) {
                    1.$$$reportNull$$$0(4);
                }
                XmlReferenceInspectionBase.this.checkRefs((XmlElement)processingInstruction, holder, 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attribute";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "xmlDoctype";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tag";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processingInstruction";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlReferenceInspectionBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlAttributeValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlAttribute";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlDoctype";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlTag";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlProcessingInstruction";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void checkRefs(@NotNull XmlElement element, @NotNull ProblemsHolder holder, int startIndex) {
        PsiReference[] references;
        if (element == null) {
            XmlReferenceInspectionBase.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            XmlReferenceInspectionBase.$$$reportNull$$$0(2);
        }
        if ((references = element.getReferences()).length <= startIndex) {
            return;
        }
        if (XmlHighlightVisitor.isInjectedWithoutValidation((PsiElement)element)) {
            return;
        }
        boolean isHtml = HtmlUtil.isHtmlTagContainingFile((PsiElement)element);
        if (!this.checkHtml(element, isHtml)) {
            return;
        }
        Collection<PsiReference> unresolved = this.getUnresolvedReferencesToAnnotate(Arrays.copyOfRange(references, startIndex, references.length));
        for (PsiReference reference : unresolved) {
            holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), isHtml ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    protected boolean checkHtml(@NotNull XmlElement element, boolean isHtml) {
        if (element == null) {
            XmlReferenceInspectionBase.$$$reportNull$$$0(3);
        }
        if (isHtml ^ this.isForHtml()) {
            return false;
        }
        return isHtml || !XmlHighlightVisitor.skipValidation((PsiElement)element);
    }

    @NotNull
    private Collection<PsiReference> getUnresolvedReferencesToAnnotate(PsiReference[] references) {
        HashMap<TextRange, PsiReference> unresolvedReferences = new HashMap<TextRange, PsiReference>();
        for (PsiReference reference : references) {
            TextRange rangeInElement;
            if (!this.needToCheckRef(reference)) continue;
            if (!this.checkRanges()) {
                if (!XmlHighlightVisitor.hasBadResolve(reference, false)) continue;
                unresolvedReferences.put(reference.getRangeInElement(), reference);
                continue;
            }
            TextRange elementRange = reference.getElement().getTextRange();
            if (elementRange == null || elementRange.isEmpty() || unresolvedReferences.containsKey(rangeInElement = reference.getRangeInElement()) && unresolvedReferences.get(rangeInElement) == null) continue;
            if (XmlHighlightVisitor.hasBadResolve(reference, true)) {
                if (reference.isSoft()) continue;
                unresolvedReferences.putIfAbsent(rangeInElement, reference);
                continue;
            }
            unresolvedReferences.put(rangeInElement, null);
        }
        List list2 = ContainerUtil.skipNulls(unresolvedReferences.values());
        if (list2 == null) {
            XmlReferenceInspectionBase.$$$reportNull$$$0(4);
        }
        return list2;
    }

    protected boolean checkRanges() {
        return true;
    }

    protected abstract boolean needToCheckRef(PsiReference var1);

    protected boolean isForHtml() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlReferenceInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlReferenceInspectionBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedReferencesToAnnotate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkRefs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkHtml";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

