'''OpenGL extension QCOM.YUV_texture_gather

This module customises the behaviour of the 
OpenGL.raw.GLES2.QCOM.YUV_texture_gather to provide a more 
Python-friendly API

Overview (from the spec)
	
	Extension EXT_gpu_shader5 introduced the texture gather built-in functions.
	Extension EXT_YUV_target adds the ability to sample from YUV textures, but
	does not include gather functions.   This extension allows gather function
	to be used in combination with the YUV textures exposed in EXT_YUV_target.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/QCOM/YUV_texture_gather.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.QCOM.YUV_texture_gather import *
from OpenGL.raw.GLES2.QCOM.YUV_texture_gather import _EXTENSION_NAME

def glInitYuvTextureGatherQCOM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION