/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor;

import jakarta.ws.rs.core.MediaType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;

public interface DefaultProducesHandler {
    public List<MediaType> handle(Context var1);

    public static class DelegatingDefaultProducesHandler
    implements DefaultProducesHandler {
        private final List<DefaultProducesHandler> delegates;

        public DelegatingDefaultProducesHandler(List<DefaultProducesHandler> delegates) {
            this.delegates = Objects.requireNonNull(delegates);
        }

        @Override
        public List<MediaType> handle(Context context) {
            for (DefaultProducesHandler delegate : this.delegates) {
                List<MediaType> result = delegate.handle(context);
                if (result == null || result.isEmpty()) continue;
                return result;
            }
            return Collections.emptyList();
        }
    }

    public static class Noop
    implements DefaultProducesHandler {
        public static Noop INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        public List<MediaType> handle(Context context) {
            return Collections.emptyList();
        }
    }

    public static interface Context {
        public Type nonAsyncReturnType();

        public DotName httpMethod();

        public IndexView index();

        public ResteasyReactiveConfig config();
    }
}

