/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;

public class UniCreateFromKnownFailure<T>
extends AbstractUni<T> {
    private final Throwable failure;

    public UniCreateFromKnownFailure(Throwable failure) {
        this.failure = failure;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        new KnownFailureSubscription(subscriber).forward();
    }

    private class KnownFailureSubscription
    implements UniSubscription {
        private final UniSubscriber<? super T> subscriber;
        private volatile boolean cancelled = false;

        private KnownFailureSubscription(UniSubscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        private void forward() {
            this.subscriber.onSubscribe(this);
            if (!this.cancelled) {
                this.subscriber.onFailure(UniCreateFromKnownFailure.this.failure);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }
    }
}

