<?php

declare(strict_types=1);

/*
 * eduVPN - End-user friendly VPN.
 *
 * Copyright: 2014-2023, The Commons Conservancy eduVPN Programme
 * SPDX-License-Identifier: AGPL-3.0+
 */

namespace Vpn\Portal\Cfg;

class OidcAuthConfig
{
    use ConfigTrait;

    private array $configData;

    public function __construct(array $configData)
    {
        $this->configData = $configData;
    }

    public function userIdAttribute(): string
    {
        return $this->requireString('userIdAttribute', 'REMOTE_USER');
    }

    /**
     * @return array<string>
     */
    public function permissionAttributeList(): array
    {
        return $this->requireStringArray('permissionAttributeList', []);
    }

    /**
     * Set this to the value of OIDCClaimDelimiter you use in your Apache
     * configuration. The default is ",", but this won't work well if the
     * values of your permissions themselves contain a ",".
     */
    public function claimDelimiter(): string
    {
        return $this->requireString('claimDelimiter', ',');
    }
}
