/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.InheritableItem;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItem;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlModuleDescriptorUpdater {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void update(InputStream inputStream, Resource resource, File object, UpdateOptions updateOptions) throws IOException, SAXException {
        if (((File)object).getParentFile() != null) {
            ((File)object).getParentFile().mkdirs();
        }
        object = new FileOutputStream((File)object);
        try {
            URL uRL = null;
            if (resource instanceof URLResource) {
                uRL = ((URLResource)resource).getURL();
            } else if (resource instanceof FileResource) {
                uRL = ((FileResource)resource).getFile().toURI().toURL();
            }
            XmlModuleDescriptorUpdater.update(uRL, inputStream, (OutputStream)object, updateOptions);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Message.warn("failed to close a stream : " + iOException.toString());
            }
            try {
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {
                Message.warn("failed to close a stream : " + iOException.toString());
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            Message.warn("failed to close a stream : " + iOException.toString());
        }
        try {
            ((OutputStream)object).close();
            return;
        }
        catch (IOException iOException) {
            Message.warn("failed to close a stream : " + iOException.toString());
            return;
        }
    }

    public static void update(URL uRL, InputStream object, OutputStream object2, UpdateOptions updateOptions) throws IOException, SAXException {
        object2 = new PrintWriter(new OutputStreamWriter((OutputStream)object2, "UTF-8"));
        ((PrintWriter)object2).write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ((PrintWriter)object2).write(LINE_SEPARATOR);
        try {
            object2 = new UpdaterHandler(uRL, (PrintWriter)object2, updateOptions);
            object = new InputSource(new BufferedInputStream((InputStream)object));
            if (uRL != null) {
                ((InputSource)object).setSystemId(uRL.toExternalForm());
            }
            Object object3 = object2;
            XMLHelper.parse((InputSource)object, null, (DefaultHandler)object3, (LexicalHandler)object3);
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            object = new IllegalStateException("impossible to update Ivy files: parser problem");
            ((Throwable)object).initCause(parserConfigurationException);
            throw object;
        }
    }

    protected static class ConfigurationPrinter
    implements ItemPrinter {
        public static final ConfigurationPrinter INSTANCE = new ConfigurationPrinter();

        protected ConfigurationPrinter() {
        }

        @Override
        public void print(ModuleDescriptor moduleDescriptor, Object object, PrintWriter printWriter) {
            XmlModuleDescriptorWriter.printConfiguration((Configuration)object, printWriter);
        }
    }

    protected static class DependencyPrinter
    implements ItemPrinter {
        public static final DependencyPrinter INSTANCE = new DependencyPrinter();

        protected DependencyPrinter() {
        }

        @Override
        public void print(ModuleDescriptor moduleDescriptor, Object object, PrintWriter printWriter) {
            XmlModuleDescriptorWriter.printDependency(moduleDescriptor, (DependencyDescriptor)object, printWriter);
        }
    }

    protected static interface ItemPrinter {
        public void print(ModuleDescriptor var1, Object var2, PrintWriter var3);
    }

    private static class ExtendedBuffer {
        private String context = null;
        private Boolean print = null;
        private boolean defaultPrint = false;
        private StringWriter buffer = new StringWriter();
        private PrintWriter writer = new PrintWriter(this.buffer);

        ExtendedBuffer(String string) {
            this.context = string;
        }

        boolean isPrint() {
            if (this.print == null) {
                return this.defaultPrint;
            }
            return this.print;
        }

        void setPrint(boolean bl) {
            this.print = bl;
        }

        void setDefaultPrint(boolean bl) {
            this.defaultPrint = bl;
        }

        PrintWriter getWriter() {
            return this.writer;
        }

        String getContext() {
            return this.context;
        }

        public String toString() {
            this.writer.flush();
            return this.buffer.toString();
        }
    }

    private static class UpdaterHandler
    extends DefaultHandler
    implements LexicalHandler {
        private static final Collection STD_ATTS = Arrays.asList("organisation", "module", "branch", "revision", "status", "publication", "namespace");
        private static final List MODULE_ELEMENTS = Arrays.asList("info", "configurations", "publications", "dependencies", "conflicts");
        private static final int CONFIGURATIONS_POSITION = MODULE_ELEMENTS.indexOf("configurations");
        private static final int DEPENDENCIES_POSITION = MODULE_ELEMENTS.indexOf("dependencies");
        private static final Collection INFO_ELEMENTS = Arrays.asList("extends", "ivyauthor", "license", "repository", "description");
        private final ParserSettings settings;
        private final PrintWriter out;
        private final Map resolvedRevisions;
        private final Map resolvedBranches;
        private final String status;
        private final String revision;
        private final Date pubdate;
        private final Namespace ns;
        private final boolean replaceInclude;
        private final boolean generateRevConstraint;
        private boolean inHeader = true;
        private final List confs;
        private final URL relativePathCtx;
        private final UpdateOptions options;
        private String organisation = null;
        private String defaultConfMapping = null;
        private Boolean confMappingOverride = null;
        private String justOpen = null;
        private boolean indenting;
        private StringBuffer currentIndent = new StringBuffer();
        private ArrayList indentLevels = new ArrayList();
        private boolean hasDescription = false;
        private boolean mergedConfigurations = false;
        private boolean mergedDependencies = false;
        private String newDefaultConf = null;
        private Stack context = new Stack();
        private Stack buffers = new Stack();
        private Stack confAttributeBuffers = new Stack();

        public UpdaterHandler(URL uRL, PrintWriter printWriter, UpdateOptions updateOptions) {
            this.options = updateOptions;
            this.settings = updateOptions.getSettings();
            this.out = printWriter;
            this.resolvedRevisions = updateOptions.getResolvedRevisions();
            this.resolvedBranches = updateOptions.getResolvedBranches();
            this.status = updateOptions.getStatus();
            this.revision = updateOptions.getRevision();
            this.pubdate = updateOptions.getPubdate();
            this.ns = updateOptions.getNamespace();
            this.replaceInclude = updateOptions.isReplaceInclude();
            this.generateRevConstraint = updateOptions.isGenerateRevConstraint();
            this.relativePathCtx = uRL;
            if (updateOptions.getConfsToExclude() != null) {
                this.confs = Arrays.asList(updateOptions.getConfsToExclude());
                return;
            }
            this.confs = Collections.EMPTY_LIST;
        }

        @Override
        public void startElement(String object, String object2, String string, Attributes attributes) throws SAXException {
            this.inHeader = false;
            this.endIndent();
            if (this.justOpen != null) {
                this.write(">");
            }
            this.flushMergedElementsBefore(string);
            if (this.options.isMerge() && ("exclude".equals(object2) || "override".equals(object2) || "conflict".equals(object2)) && "ivy-module/dependencies".equals(this.getContext())) {
                object = this.options.getMergedDescriptor();
                this.writeInheritedDependencies((ModuleDescriptor)object);
                this.out.println();
                this.out.print(this.getIndent());
            }
            this.context.push(string);
            object = this.getContext();
            if ("info".equals(string)) {
                this.infoStarted(attributes);
            } else if (this.replaceInclude && "include".equals(string) && this.context.contains("configurations")) {
                this.includeStarted(attributes);
            } else if ("ivy-module/info/extends".equals(object)) {
                this.startExtends(attributes);
            } else if ("ivy-module/dependencies/dependency".equals(object)) {
                this.startElementInDependency(attributes);
            } else if ("dependencies".equals(string)) {
                this.startDependencies(attributes);
            } else if ("ivy-module/configurations/conf".equals(object)) {
                this.startElementInConfigurationsConf(string, attributes);
            } else if ("ivy-module/publications/artifact/conf".equals(object) || "ivy-module/dependencies/dependency/conf".equals(object) || "ivy-module/dependencies/dependency/artifact/conf".equals(object)) {
                this.buffers.push(new ExtendedBuffer(this.getContext()));
                ((ExtendedBuffer)this.confAttributeBuffers.peek()).setDefaultPrint(false);
                UpdaterHandler updaterHandler = this;
                object2 = updaterHandler.substitute(updaterHandler.settings, attributes.getValue("name"));
                if (!this.confs.contains(object2)) {
                    ((ExtendedBuffer)this.confAttributeBuffers.peek()).setPrint(true);
                    ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                    this.write("<" + string);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        UpdaterHandler updaterHandler2 = this;
                        this.write(" " + attributes.getQName(i) + "=\"" + updaterHandler2.substitute(updaterHandler2.settings, attributes.getValue(i)) + "\"");
                    }
                }
            } else if ("ivy-module/publications/artifact".equals(object)) {
                object2 = new ExtendedBuffer(this.getContext());
                this.buffers.push(object2);
                this.confAttributeBuffers.push(object2);
                this.write("<" + string);
                ((ExtendedBuffer)object2).setDefaultPrint(attributes.getValue("conf") == null && (this.newDefaultConf == null || this.newDefaultConf.length() > 0));
                for (int i = 0; i < attributes.getLength(); ++i) {
                    object2 = attributes.getQName(i);
                    if ("conf".equals(object2)) {
                        UpdaterHandler updaterHandler = this;
                        object2 = updaterHandler.substitute(updaterHandler.settings, attributes.getValue("conf"));
                        if (((String)(object2 = this.removeConfigurationsFromList((String)object2, this.confs))).length() <= 0) continue;
                        this.write(" " + attributes.getQName(i) + "=\"" + (String)object2 + "\"");
                        ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                        continue;
                    }
                    UpdaterHandler updaterHandler = this;
                    this.write(" " + attributes.getQName(i) + "=\"" + updaterHandler.substitute(updaterHandler.settings, attributes.getValue(i)) + "\"");
                }
            } else if ("ivy-module/dependencies/dependency/artifact".equals(object)) {
                object2 = new ExtendedBuffer(this.getContext());
                this.buffers.push(object2);
                this.confAttributeBuffers.push(object2);
                this.write("<" + string);
                ((ExtendedBuffer)object2).setDefaultPrint(attributes.getValue("conf") == null);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    object2 = attributes.getQName(i);
                    if ("conf".equals(object2)) {
                        UpdaterHandler updaterHandler = this;
                        object2 = updaterHandler.substitute(updaterHandler.settings, attributes.getValue("conf"));
                        if (((String)(object2 = this.removeConfigurationsFromList((String)object2, this.confs))).length() <= 0) continue;
                        this.write(" " + attributes.getQName(i) + "=\"" + (String)object2 + "\"");
                        ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                        continue;
                    }
                    UpdaterHandler updaterHandler = this;
                    this.write(" " + attributes.getQName(i) + "=\"" + updaterHandler.substitute(updaterHandler.settings, attributes.getValue(i)) + "\"");
                }
            } else if ("ivy-module/publications".equals(object)) {
                this.startPublications(attributes);
            } else {
                if (this.options.isMerge() && ((String)object).startsWith("ivy-module/info")) {
                    object2 = this.options.getMergedDescriptor();
                    if (((String)object).equals("ivy-module/info/description")) {
                        this.hasDescription = true;
                    } else if (!INFO_ELEMENTS.contains(string)) {
                        this.writeInheritedDescription((ModuleDescriptor)object2);
                    }
                }
                this.write("<" + string);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    UpdaterHandler updaterHandler = this;
                    this.write(" " + attributes.getQName(i) + "=\"" + updaterHandler.substitute(updaterHandler.settings, attributes.getValue(i)) + "\"");
                }
            }
            this.justOpen = string;
        }

        private void startExtends(Attributes attributes) {
            if (this.options.isMerge()) {
                this.write("<!-- ");
            }
            this.write("<extends");
            UpdaterHandler updaterHandler = this;
            String string = updaterHandler.substitute(updaterHandler.settings, attributes.getValue("organisation"));
            UpdaterHandler updaterHandler2 = this;
            String string2 = updaterHandler2.substitute(updaterHandler2.settings, attributes.getValue("module"));
            ModuleId moduleId = new ModuleId(string, string2);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string3 = attributes.getQName(i);
                String string4 = null;
                if ("revision".equals(string3)) {
                    ExtendsDescriptor[] extendsDescriptorArray = this.options.getMergedDescriptor();
                    if (extendsDescriptorArray != null) {
                        extendsDescriptorArray = extendsDescriptorArray.getInheritedDescriptors();
                        for (int j = 0; string4 == null && j < extendsDescriptorArray.length; ++j) {
                            ModuleRevisionId moduleRevisionId = extendsDescriptorArray[j].getResolvedParentRevisionId();
                            if (!moduleId.equals(moduleRevisionId.getModuleId())) continue;
                            string4 = moduleRevisionId.getRevision();
                        }
                    }
                    if (string4 == null) {
                        UpdaterHandler updaterHandler3 = this;
                        string4 = updaterHandler3.substitute(updaterHandler3.settings, attributes.getValue(i));
                    }
                } else if ("organisation".equals(string3)) {
                    string4 = string;
                } else if ("module".equals(string3)) {
                    string4 = string2;
                } else {
                    UpdaterHandler updaterHandler4 = this;
                    string4 = updaterHandler4.substitute(updaterHandler4.settings, attributes.getValue(i));
                }
                this.write(" " + string3 + "=\"" + string4 + "\"");
            }
        }

        private void startElementInConfigurationsConf(String string, Attributes attributes) {
            this.buffers.push(new ExtendedBuffer(this.getContext()));
            UpdaterHandler updaterHandler = this;
            Object object = updaterHandler.substitute(updaterHandler.settings, attributes.getValue("name"));
            if (!this.confs.contains(object)) {
                ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                UpdaterHandler updaterHandler2 = this;
                object = updaterHandler2.substitute(updaterHandler2.settings, attributes.getValue("extends"));
                if (object != null) {
                    object = new StringTokenizer((String)object, ", ");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string2 = ((StringTokenizer)object).nextToken();
                        if (!this.confs.contains(string2)) continue;
                        throw new IllegalArgumentException("Cannot exclude a configuration which is extended.");
                    }
                }
                this.write("<" + string);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    UpdaterHandler updaterHandler3 = this;
                    this.write(" " + attributes.getQName(i) + "=\"" + updaterHandler3.substitute(updaterHandler3.settings, attributes.getValue(i)) + "\"");
                }
            }
        }

        private void startDependencies(Attributes attributes) {
            this.write("<dependencies");
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getQName(i);
                if ("defaultconfmapping".equals(string)) {
                    UpdaterHandler updaterHandler = this;
                    string = updaterHandler.removeConfigurationsFromMapping(updaterHandler.substitute(this.settings, attributes.getValue("defaultconfmapping")), this.confs);
                    if (string.length() <= 0) continue;
                    this.write(" " + attributes.getQName(i) + "=\"" + string + "\"");
                    continue;
                }
                UpdaterHandler updaterHandler = this;
                this.write(" " + attributes.getQName(i) + "=\"" + updaterHandler.substitute(updaterHandler.settings, attributes.getValue(i)) + "\"");
            }
            if (this.defaultConfMapping != null && attributes.getValue("defaultconfmapping") == null) {
                UpdaterHandler updaterHandler = this;
                String string = updaterHandler.removeConfigurationsFromMapping(updaterHandler.defaultConfMapping, this.confs);
                if (string.length() > 0) {
                    this.write(" defaultconfmapping=\"" + string + "\"");
                }
            }
            if (this.confMappingOverride != null && attributes.getValue("confmappingoverride") == null) {
                this.write(" confmappingoverride=\"" + this.confMappingOverride.toString() + "\"");
            }
        }

        private void startPublications(Attributes attributes) {
            this.write("<publications");
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getQName(i);
                if ("defaultconf".equals(string)) {
                    UpdaterHandler updaterHandler = this;
                    this.newDefaultConf = this.removeConfigurationsFromList(updaterHandler.substitute(updaterHandler.settings, attributes.getValue("defaultconf")), this.confs);
                    if (this.newDefaultConf.length() <= 0) continue;
                    this.write(" " + attributes.getQName(i) + "=\"" + this.newDefaultConf + "\"");
                    continue;
                }
                UpdaterHandler updaterHandler = this;
                this.write(" " + attributes.getQName(i) + "=\"" + updaterHandler.substitute(updaterHandler.settings, attributes.getValue(i)) + "\"");
            }
        }

        private void startElementInDependency(Attributes attributes) {
            Object object4;
            Object object2;
            Object object3 = new ExtendedBuffer(this.getContext());
            this.buffers.push(object3);
            this.confAttributeBuffers.push(object3);
            ((ExtendedBuffer)object3).setDefaultPrint(attributes.getValue("conf") == null || attributes.getValue("conf").trim().length() == 0);
            this.write("<dependency");
            UpdaterHandler updaterHandler = this;
            object3 = updaterHandler.substitute(updaterHandler.settings, attributes.getValue("org"));
            object3 = object3 == null ? this.organisation : object3;
            UpdaterHandler updaterHandler2 = this;
            String string = updaterHandler2.substitute(updaterHandler2.settings, attributes.getValue("name"));
            UpdaterHandler updaterHandler3 = this;
            String string2 = updaterHandler3.substitute(updaterHandler3.settings, attributes.getValue("branch"));
            UpdaterHandler updaterHandler4 = this;
            String string3 = updaterHandler4.substitute(updaterHandler4.settings, attributes.getValue("branchConstraint"));
            String string4 = string3 = string3 == null ? string2 : string3;
            if (string2 == null) {
                object2 = ModuleId.newInstance((String)object3, string);
                if (this.ns != null) {
                    object2 = NameSpaceHelper.transform((ModuleId)object2, this.ns.getToSystemTransformer());
                }
                for (Object object4 : this.resolvedRevisions.keySet()) {
                    if (!((ModuleRevisionId)object4).getModuleId().equals(object2)) continue;
                    string2 = ((ModuleRevisionId)object4).getBranch();
                    break;
                }
            }
            UpdaterHandler updaterHandler5 = this;
            object2 = updaterHandler5.substitute(updaterHandler5.settings, attributes.getValue("rev"));
            UpdaterHandler updaterHandler6 = this;
            String string5 = updaterHandler6.substitute(updaterHandler6.settings, attributes.getValue("revConstraint"));
            object4 = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, XmlModuleDescriptorParser.DEPENDENCY_REGULAR_ATTRIBUTES);
            object3 = ModuleRevisionId.newInstance((String)object3, string, string2, (String)object2, (Map)object4);
            object3 = this.ns == null ? object3 : this.ns.getToSystemTransformer().transform((ModuleRevisionId)object3);
            string = (String)this.resolvedBranches.get(object3);
            for (int i = 0; i < attributes.getLength(); ++i) {
                object2 = attributes.getQName(i);
                if ("rev".equals(object2)) {
                    object2 = (String)this.resolvedRevisions.get(object3);
                    if (object2 != null) {
                        this.write(" rev=\"" + (String)object2 + "\"");
                        if (attributes.getIndex("branchConstraint") == -1 && string3 != null) {
                            this.write(" branchConstraint=\"" + string3 + "\"");
                        }
                        if (!this.generateRevConstraint || attributes.getIndex("revConstraint") != -1 || ((String)object2).equals(((ModuleRevisionId)object3).getRevision())) continue;
                        this.write(" revConstraint=\"" + ((ModuleRevisionId)object3).getRevision() + "\"");
                        continue;
                    }
                    this.write(" rev=\"" + ((ModuleRevisionId)object3).getRevision() + "\"");
                    continue;
                }
                if ("revConstraint".equals(object2)) {
                    this.write(" revConstraint=\"" + (String)string5 + "\"");
                    continue;
                }
                if ("org".equals(object2)) {
                    this.write(" org=\"" + ((ModuleRevisionId)object3).getOrganisation() + "\"");
                    continue;
                }
                if ("name".equals(object2)) {
                    this.write(" name=\"" + ((ModuleRevisionId)object3).getName() + "\"");
                    continue;
                }
                if ("branch".equals(object2)) {
                    if (string != null) {
                        this.write(" branch=\"" + string + "\"");
                        continue;
                    }
                    if (this.resolvedBranches.containsKey(object3)) continue;
                    this.write(" branch=\"" + ((ModuleRevisionId)object3).getBranch() + "\"");
                    continue;
                }
                if ("branchConstraint".equals(object2)) {
                    this.write(" branchConstraint=\"" + string3 + "\"");
                    continue;
                }
                if ("conf".equals(object2)) {
                    UpdaterHandler updaterHandler7 = this;
                    object2 = updaterHandler7.substitute(updaterHandler7.settings, attributes.getValue("conf"));
                    if (((String)object2).length() <= 0 || ((String)(object2 = this.removeConfigurationsFromMapping((String)object2, this.confs))).length() <= 0) continue;
                    this.write(" conf=\"" + (String)object2 + "\"");
                    ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                    continue;
                }
                UpdaterHandler updaterHandler8 = this;
                this.write(" " + (String)object2 + "=\"" + updaterHandler8.substitute(updaterHandler8.settings, attributes.getValue((String)object2)) + "\"");
            }
            if (attributes.getIndex("branch") == -1) {
                if (string != null) {
                    if (!string.trim().equals("")) {
                        this.write(" branch=\"" + string + "\"");
                        return;
                    }
                } else if (this.options.isUpdateBranch() && ((ModuleRevisionId)object3).getBranch() != null) {
                    this.write(" branch=\"" + ((ModuleRevisionId)object3).getBranch() + "\"");
                }
            }
        }

        private void includeStarted(Attributes object) throws SAXException {
            final ExtendedBuffer extendedBuffer = new ExtendedBuffer(this.getContext());
            this.buffers.push(extendedBuffer);
            try {
                if (this.settings != null) {
                    object = this.settings.getRelativeUrlResolver().getURL(this.relativePathCtx, this.settings.substitute(object.getValue("file")), this.settings.substitute(object.getValue("url")));
                } else {
                    String string = object.getValue("file");
                    if (string == null) {
                        object = object.getValue("url");
                        object = new URL((String)object);
                    } else {
                        object = Checks.checkAbsolute(string, "settings.include").toURI().toURL();
                    }
                }
                XMLHelper.parse((URL)object, null, new DefaultHandler(){
                    private boolean insideConfigurations = false;
                    private boolean doIndent = false;

                    @Override
                    public void startElement(String object, String string, String string2, Attributes attributes) throws SAXException {
                        if ("configurations".equals(string2)) {
                            this.insideConfigurations = true;
                            object = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("defaultconfmapping"));
                            if (object != null) {
                                UpdaterHandler.this.defaultConfMapping = (String)object;
                            }
                            if ((object = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("confmappingoverride"))) != null) {
                                UpdaterHandler.this.confMappingOverride = Boolean.valueOf((String)object);
                            }
                            return;
                        }
                        if ("conf".equals(string2) && this.insideConfigurations) {
                            object = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("name"));
                            if (!UpdaterHandler.this.confs.contains(object)) {
                                extendedBuffer.setPrint(true);
                                if (this.doIndent) {
                                    UpdaterHandler.this.write("/>\n\t\t");
                                }
                                if ((object = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("extends"))) != null) {
                                    object = new StringTokenizer((String)object, ", ");
                                    while (((StringTokenizer)object).hasMoreTokens()) {
                                        string = ((StringTokenizer)object).nextToken();
                                        if (!UpdaterHandler.this.confs.contains(string)) continue;
                                        throw new IllegalArgumentException("Cannot exclude a configuration which is extended.");
                                    }
                                }
                                UpdaterHandler.this.write("<" + string2);
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    UpdaterHandler.this.write(" " + attributes.getQName(i) + "=\"" + UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue(i)) + "\"");
                                }
                                this.doIndent = true;
                            }
                        }
                    }

                    @Override
                    public void endElement(String string, String string2, String string3) throws SAXException {
                        if ("configurations".equals(string3)) {
                            this.insideConfigurations = false;
                        }
                    }
                });
                return;
            }
            catch (Exception exception) {
                Message.warn("exception occurred while importing configurations: " + exception.getMessage());
                throw new SAXException(exception);
            }
        }

        private void infoStarted(Attributes object4) {
            Object object;
            String string;
            String string2;
            String string3;
            Object object2;
            ExtendableItem extendableItem;
            UpdaterHandler updaterHandler = this;
            String string4 = updaterHandler.substitute(updaterHandler.settings, object4.getValue("module"));
            String string5 = null;
            if (this.options.isMerge()) {
                extendableItem = this.options.getMergedDescriptor();
                object2 = extendableItem.getModuleRevisionId();
                this.organisation = ((ModuleRevisionId)object2).getOrganisation();
                string3 = ((ModuleRevisionId)object2).getBranch();
                string2 = ((ModuleRevisionId)object2).getRevision();
                string = extendableItem.getStatus();
                if (extendableItem instanceof DefaultModuleDescriptor && (object = ((DefaultModuleDescriptor)extendableItem).getNamespace()) != null) {
                    string5 = ((Namespace)object).getName();
                }
                if (string5 == null) {
                    string5 = object4.getValue("namespace");
                }
                object = extendableItem.getQualifiedExtraAttributes();
            } else {
                this.organisation = this.substitute(this.settings, object4.getValue("organisation"));
                UpdaterHandler updaterHandler2 = this;
                string2 = updaterHandler2.substitute(updaterHandler2.settings, object4.getValue("revision"));
                UpdaterHandler updaterHandler3 = this;
                string3 = updaterHandler3.substitute(updaterHandler3.settings, object4.getValue("branch"));
                UpdaterHandler updaterHandler4 = this;
                string = updaterHandler4.substitute(updaterHandler4.settings, object4.getValue("status"));
                UpdaterHandler updaterHandler5 = this;
                string5 = updaterHandler5.substitute(updaterHandler5.settings, object4.getValue("namespace"));
                object = new LinkedHashMap<Object, String>(object4.getLength());
                for (int i = 0; i < object4.getLength(); ++i) {
                    object2 = object4.getQName(i);
                    if (STD_ATTS.contains(object2)) continue;
                    UpdaterHandler updaterHandler6 = this;
                    object.put(object2, updaterHandler6.substitute(updaterHandler6.settings, object4.getValue(i)));
                }
            }
            if (this.revision != null) {
                string2 = this.revision;
            }
            if (this.options.getBranch() != null) {
                string3 = this.options.getBranch();
            }
            if (this.status != null) {
                string = this.status;
            }
            extendableItem = ModuleRevisionId.newInstance(this.organisation, string4, string3, string2, ExtendableItemHelper.getExtraAttributes(this.settings, (Attributes)object4, new String[]{"organisation", "module", "revision", "status", "publication", "namespace"}));
            object2 = this.ns == null ? extendableItem : this.ns.getToSystemTransformer().transform((ModuleRevisionId)extendableItem);
            this.write("<info");
            if (this.organisation != null) {
                this.write(" organisation=\"" + XMLHelper.escape(((ModuleRevisionId)object2).getOrganisation()) + "\"");
            }
            this.write(" module=\"" + XMLHelper.escape(((ModuleRevisionId)object2).getName()) + "\"");
            if (string3 != null) {
                this.write(" branch=\"" + XMLHelper.escape(((ModuleRevisionId)object2).getBranch()) + "\"");
            }
            if (((ModuleRevisionId)object2).getRevision() != null) {
                this.write(" revision=\"" + XMLHelper.escape(((ModuleRevisionId)object2).getRevision()) + "\"");
            }
            this.write(" status=\"" + XMLHelper.escape(string) + "\"");
            if (this.pubdate != null) {
                this.write(" publication=\"" + DateUtil.format(this.pubdate) + "\"");
            } else if (object4.getValue("publication") != null) {
                UpdaterHandler updaterHandler7 = this;
                this.write(" publication=\"" + updaterHandler7.substitute(updaterHandler7.settings, object4.getValue("publication")) + "\"");
            }
            if (string5 != null) {
                this.write(" namespace=\"" + string5 + "\"");
            }
            for (Map.Entry entry : object.entrySet()) {
                this.write(" " + entry.getKey() + "=\"" + entry.getValue() + "\"");
            }
        }

        private void write(String string) {
            this.getWriter().print(string);
        }

        private PrintWriter getWriter() {
            if (this.buffers.isEmpty()) {
                return this.out;
            }
            return ((ExtendedBuffer)this.buffers.peek()).getWriter();
        }

        private String getContext() {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.context) {
                stringBuffer.append(string).append("/");
            }
            if (stringBuffer.length() > 0) {
                StringBuffer stringBuffer2 = stringBuffer;
                stringBuffer2.setLength(stringBuffer2.length() - 1);
            }
            return stringBuffer.toString();
        }

        private String substitute(ParserSettings object, String string) {
            object = object == null ? string : object.substitute(string);
            return XMLHelper.escape((String)object);
        }

        private String removeConfigurationsFromMapping(String object, List object2) {
            object2 = new StringBuffer();
            Object object3 = "";
            object = new StringTokenizer((String)object, ";");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String[] stringArray = ((StringTokenizer)object).nextToken();
                stringArray = stringArray.split("->");
                String[] stringArray2 = stringArray[0].split(",");
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (this.confs.contains(stringArray2[i].trim())) continue;
                    arrayList.add(stringArray2[i]);
                }
                if (arrayList.isEmpty()) continue;
                ((StringBuffer)object2).append((String)object3);
                String string = "";
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    ((StringBuffer)object2).append(string);
                    ((StringBuffer)object2).append(object3.next());
                    string = ",";
                }
                if (stringArray.length == 2) {
                    ((StringBuffer)object2).append("->");
                    ((StringBuffer)object2).append(stringArray[1]);
                }
                object3 = ";";
            }
            return ((StringBuffer)object2).toString();
        }

        private String removeConfigurationsFromList(String object, List list) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            object = new StringTokenizer((String)object, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (list.contains(string2.trim())) continue;
                stringBuffer.append(string);
                stringBuffer.append(string2);
                string = ",";
            }
            return stringBuffer.toString();
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.characters(cArray, n, n2);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.justOpen != null) {
                this.write(">");
                this.justOpen = null;
            }
            this.write(XMLHelper.escape(String.valueOf(cArray, n, n2)));
            int n3 = n;
            n += n2;
            while (n3 < n) {
                n2 = cArray[n3];
                if (n2 == 13 || n2 == 10) {
                    this.currentIndent.setLength(0);
                    this.indenting = true;
                } else if (this.indenting) {
                    if (Character.isWhitespace((char)n2)) {
                        this.currentIndent.append((char)n2);
                    } else {
                        this.endIndent();
                    }
                }
                ++n3;
            }
        }

        private void endIndent() {
            if (this.indenting) {
                UpdaterHandler updaterHandler = this;
                updaterHandler.setIndent(updaterHandler.context.size() - 1, this.currentIndent.toString());
                this.indenting = false;
            }
        }

        private void setIndent(int n, String string) {
            this.fillIndents(n);
            this.indentLevels.set(n, string);
        }

        private void fillIndents(int n) {
            if (this.indentLevels.isEmpty()) {
                this.indentLevels.add("    ");
            }
            String string = (String)this.indentLevels.get(0);
            for (int i = this.indentLevels.size(); i <= n; ++i) {
                this.indentLevels.add(this.indentLevels.get(i - 1) + string);
            }
        }

        private String getIndent() {
            int n = this.context.size() - 1;
            this.fillIndents(n);
            return (String)this.indentLevels.get(n);
        }

        private void writeInheritedItems(ModuleDescriptor moduleDescriptor, InheritableItem[] object, ItemPrinter itemPrinter, String string, boolean bl) {
            PrintWriter printWriter = this.getWriter();
            boolean bl2 = !(object = this.collateInheritedItems(moduleDescriptor, (InheritableItem[])object)).isEmpty();
            if (bl2 && bl) {
                if (this.currentIndent.length() == 0) {
                    printWriter.print(this.getIndent());
                }
                printWriter.print("<" + string + ">");
                this.context.push(string);
                this.justOpen = null;
            }
            for (Map.Entry entry : object.entrySet()) {
                ModuleRevisionId moduleRevisionId = (ModuleRevisionId)entry.getKey();
                List object2 = (List)entry.getValue();
                if (this.justOpen != null) {
                    printWriter.println(">");
                    this.justOpen = null;
                }
                this.writeInheritanceComment(string, moduleRevisionId);
                for (int moduleRevisionId2 = 0; moduleRevisionId2 < object2.size(); ++moduleRevisionId2) {
                    InheritableItem inheritableItem = (InheritableItem)object2.get(moduleRevisionId2);
                    printWriter.print(this.getIndent());
                    itemPrinter.print(moduleDescriptor, inheritableItem, printWriter);
                }
            }
            if (bl2) {
                if (bl) {
                    this.context.pop();
                    printWriter.println(this.getIndent() + "</" + string + ">");
                    printWriter.println();
                }
                printWriter.print(this.currentIndent);
            }
        }

        private void writeInheritanceComment(String string, Object object) {
            PrintWriter printWriter = this.getWriter();
            printWriter.println();
            printWriter.println(this.getIndent() + "<!-- " + string + " inherited from " + object + " -->");
        }

        private Map collateInheritedItems(ModuleDescriptor moduleDescriptor, InheritableItem[] inheritableItemArray) {
            LinkedHashMap<ModuleRevisionId, ArrayList<InheritableItem>> linkedHashMap = new LinkedHashMap<ModuleRevisionId, ArrayList<InheritableItem>>();
            for (int i = 0; i < inheritableItemArray.length; ++i) {
                ModuleRevisionId moduleRevisionId = inheritableItemArray[i].getSourceModule();
                if (moduleRevisionId == null || moduleRevisionId.getModuleId().equals(moduleDescriptor.getModuleRevisionId().getModuleId())) continue;
                ArrayList<InheritableItem> arrayList = (ArrayList<InheritableItem>)linkedHashMap.get(moduleRevisionId);
                if (arrayList == null) {
                    arrayList = new ArrayList<InheritableItem>();
                    linkedHashMap.put(moduleRevisionId, arrayList);
                }
                arrayList.add(inheritableItemArray[i]);
            }
            return linkedHashMap;
        }

        private void writeInheritedDescription(ModuleDescriptor object) {
            if (!this.hasDescription) {
                this.hasDescription = true;
                if ((object = object.getDescription()) != null) {
                    PrintWriter printWriter = this.getWriter();
                    if (this.justOpen != null) {
                        printWriter.println(">");
                    }
                    this.writeInheritanceComment("description", "parent");
                    printWriter.println(this.getIndent() + "<description>" + XMLHelper.escape((String)object) + "</description>");
                    printWriter.print(this.currentIndent);
                    this.justOpen = null;
                }
            }
        }

        private void writeInheritedConfigurations(ModuleDescriptor moduleDescriptor) {
            if (!this.mergedConfigurations) {
                this.mergedConfigurations = true;
                ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
                this.writeInheritedItems(moduleDescriptor2, moduleDescriptor2.getConfigurations(), ConfigurationPrinter.INSTANCE, "configurations", false);
            }
        }

        private void writeInheritedDependencies(ModuleDescriptor moduleDescriptor) {
            if (!this.mergedDependencies) {
                this.mergedDependencies = true;
                ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
                this.writeInheritedItems(moduleDescriptor2, moduleDescriptor2.getDependencies(), DependencyPrinter.INSTANCE, "dependencies", false);
            }
        }

        private void flushMergedElementsBefore(String string) {
            if (this.options.isMerge() && this.context.size() == 1 && "ivy-module".equals(this.context.peek()) && (!this.mergedConfigurations || !this.mergedDependencies)) {
                int n = string == null ? MODULE_ELEMENTS.size() : MODULE_ELEMENTS.indexOf(string);
                ModuleDescriptor moduleDescriptor = this.options.getMergedDescriptor();
                if (!this.mergedConfigurations && n > CONFIGURATIONS_POSITION && moduleDescriptor.getConfigurations().length > 0) {
                    this.mergedConfigurations = true;
                    ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
                    this.writeInheritedItems(moduleDescriptor2, moduleDescriptor2.getConfigurations(), ConfigurationPrinter.INSTANCE, "configurations", true);
                }
                if (!this.mergedDependencies && n > DEPENDENCIES_POSITION && moduleDescriptor.getDependencies().length > 0) {
                    this.mergedDependencies = true;
                    ModuleDescriptor moduleDescriptor3 = moduleDescriptor;
                    this.writeInheritedItems(moduleDescriptor3, moduleDescriptor3.getDependencies(), DependencyPrinter.INSTANCE, "dependencies", true);
                }
            }
        }

        private void flushAllMergedElements() {
            this.flushMergedElementsBefore(null);
        }

        @Override
        public void endElement(String string, String object, String string2) throws SAXException {
            string = this.getContext();
            if (this.options.isMerge()) {
                object = this.options.getMergedDescriptor();
                if ("ivy-module/info".equals(string)) {
                    this.writeInheritedDescription((ModuleDescriptor)object);
                } else if ("ivy-module/configurations".equals(string)) {
                    this.writeInheritedConfigurations((ModuleDescriptor)object);
                } else if ("ivy-module/dependencies".equals(string)) {
                    this.writeInheritedDependencies((ModuleDescriptor)object);
                } else if ("ivy-module".equals(string)) {
                    this.flushAllMergedElements();
                }
            }
            if (string2.equals(this.justOpen)) {
                this.write("/>");
            } else {
                this.write("</" + string2 + ">");
            }
            if (!this.buffers.isEmpty() && ((ExtendedBuffer)(object = (ExtendedBuffer)this.buffers.peek())).getContext().equals(string)) {
                this.buffers.pop();
                if (((ExtendedBuffer)object).isPrint()) {
                    this.write(((ExtendedBuffer)object).toString());
                }
            }
            if (!this.confAttributeBuffers.isEmpty() && ((ExtendedBuffer)(object = (ExtendedBuffer)this.confAttributeBuffers.peek())).getContext().equals(string)) {
                this.confAttributeBuffers.pop();
            }
            if (this.options.isMerge() && "ivy-module/info/extends".equals(string)) {
                this.write(" -->");
            }
            this.justOpen = null;
            this.context.pop();
        }

        @Override
        public void endDocument() throws SAXException {
            this.out.print(LINE_SEPARATOR);
            this.out.flush();
            this.out.close();
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            this.write("<?");
            this.write(string);
            this.write(" ");
            this.write(string2);
            this.write("?>");
            this.write(LINE_SEPARATOR);
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] cArray, int n, int n2) throws SAXException {
            if (this.justOpen != null) {
                this.write(">");
                this.justOpen = null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray, n, n2);
            this.write("<!--");
            this.write(stringBuffer.toString());
            this.write("-->");
            if (this.inHeader) {
                this.write(LINE_SEPARATOR);
            }
        }

        @Override
        public void endEntity(String string) throws SAXException {
        }

        @Override
        public void startEntity(String string) throws SAXException {
        }

        @Override
        public void startDTD(String string, String string2, String string3) throws SAXException {
        }
    }
}

