/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(36u, 32u, 88u) % 6u) => uvec3(0u, 2u, 4u)
 * (uvec3(36u, 32u, 88u) % 12u) => uvec3(0u, 8u, 4u)
 * (uvec3(36u, 32u, 88u) % 32u) => uvec3(4u, 0u, 24u)
 * (uvec3(36u, 32u, 88u) % 74u) => uvec3(36u, 32u, 14u)
 * (uvec3(59u, 77u, 68u) % 6u) => uvec3(5u, 5u, 2u)
 * (uvec3(59u, 77u, 68u) % 12u) => uvec3(11u, 5u, 8u)
 * (uvec3(59u, 77u, 68u) % 32u) => uvec3(27u, 13u, 4u)
 * (uvec3(59u, 77u, 68u) % 74u) => uvec3(59u, 3u, 68u)
 */
#version 150

void main()
{
  float[all(equal((uvec3(36u, 32u, 88u) % 6u), uvec3(0u, 2u, 4u))) ? 1 : -1] array0;
  float[all(equal((uvec3(36u, 32u, 88u) % 12u), uvec3(0u, 8u, 4u))) ? 1 : -1] array1;
  float[all(equal((uvec3(36u, 32u, 88u) % 32u), uvec3(4u, 0u, 24u))) ? 1 : -1] array2;
  float[all(equal((uvec3(36u, 32u, 88u) % 74u), uvec3(36u, 32u, 14u))) ? 1 : -1] array3;
  float[all(equal((uvec3(59u, 77u, 68u) % 6u), uvec3(5u, 5u, 2u))) ? 1 : -1] array4;
  float[all(equal((uvec3(59u, 77u, 68u) % 12u), uvec3(11u, 5u, 8u))) ? 1 : -1] array5;
  float[all(equal((uvec3(59u, 77u, 68u) % 32u), uvec3(27u, 13u, 4u))) ? 1 : -1] array6;
  float[all(equal((uvec3(59u, 77u, 68u) % 74u), uvec3(59u, 3u, 68u))) ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
