/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf - dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => dvec4(1.65lf, -1.33lf, -1.93lf, -0.76lf)
 * (0.0lf - dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)) => dvec4(-0.8lf, 0.15lf, 0.51lf, 0.0lf)
 * (-1.3333333333333333lf - dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => dvec4(0.31666666666666665lf, -2.663333333333333lf, -3.263333333333333lf, -2.0933333333333333lf)
 * (-1.3333333333333333lf - dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)) => dvec4(-2.1333333333333333lf, -1.1833333333333333lf, -0.8233333333333333lf, -1.3333333333333333lf)
 * (0.85lf - dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => dvec4(2.5lf, -0.4800000000000001lf, -1.08lf, 0.08999999999999997lf)
 * (0.85lf - dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)) => dvec4(0.04999999999999993lf, 1.0lf, 1.3599999999999999lf, 0.85lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((0.0lf - dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), dvec4(1.65lf, -1.33lf, -1.93lf, -0.76lf)) <= 2.9654510618116767e-05lf ? 1 : -1] array0;
  double[distance((0.0lf - dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)), dvec4(-0.8lf, 0.15lf, 0.51lf, 0.0lf)) <= 9.605206921248497e-06lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf - dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), dvec4(0.31666666666666665lf, -2.663333333333333lf, -3.263333333333333lf, -2.0933333333333333lf)) <= 4.7143410049667716e-05lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf - dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)), dvec4(-2.1333333333333333lf, -1.1833333333333333lf, -0.8233333333333333lf, -1.3333333333333333lf)) <= 2.89949037667733e-05lf ? 1 : -1] array3;
  double[distance((0.85lf - dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), dvec4(2.5lf, -0.4800000000000001lf, -1.08lf, 0.08999999999999997lf)) <= 2.7667489947590116e-05lf ? 1 : -1] array4;
  double[distance((0.85lf - dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)), dvec4(0.04999999999999993lf, 1.0lf, 1.3599999999999999lf, 0.85lf)) <= 1.8906612599828664e-05lf ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
