/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.util;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static String prettyPrint(String unformattedJsonString) {
        StringBuilder sb = new StringBuilder();
        int indentLevel = 0;
        boolean inQuote = false;
        block7: for (char charFromUnformattedJson : unformattedJsonString.toCharArray()) {
            switch (charFromUnformattedJson) {
                case '\"': {
                    inQuote = !inQuote;
                    sb.append(charFromUnformattedJson);
                    continue block7;
                }
                case ' ': {
                    if (!inQuote) continue block7;
                    sb.append(charFromUnformattedJson);
                    continue block7;
                }
                case '[': 
                case '{': {
                    sb.append(charFromUnformattedJson);
                    JsonUtils.appendIndentedNewLine(++indentLevel, sb);
                    continue block7;
                }
                case ']': 
                case '}': {
                    JsonUtils.appendIndentedNewLine(--indentLevel, sb);
                    sb.append(charFromUnformattedJson);
                    continue block7;
                }
                case ',': {
                    sb.append(charFromUnformattedJson);
                    if (inQuote) continue block7;
                    JsonUtils.appendIndentedNewLine(indentLevel, sb);
                    continue block7;
                }
                default: {
                    sb.append(charFromUnformattedJson);
                }
            }
        }
        return sb.toString();
    }

    private static void appendIndentedNewLine(int indentLevel, StringBuilder stringBuilder) {
        stringBuilder.append("\n");
        for (int i = 0; i < indentLevel; ++i) {
            stringBuilder.append("  ");
        }
    }
}

