/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.service.guard.tools;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeMap;

public class ACLConfigurationParser {
    static String compulsoryRoles = System.getProperty("karaf.secured.command.compulsory.roles");

    public static Specificity getRolesForInvocation(String methodName, Object[] params, String[] signature, Dictionary<String, Object> config, List<String> addToRoles) {
        Dictionary<String, Object> properties = ACLConfigurationParser.trimKeys(config);
        String pid = (String)properties.get("service.pid");
        Specificity s = ACLConfigurationParser.getRolesBasedOnSignature(methodName, params, signature, properties, addToRoles);
        if (s != Specificity.NO_MATCH) {
            return s;
        }
        s = ACLConfigurationParser.getRolesBasedOnSignature(methodName, params, null, properties, addToRoles);
        if (s != Specificity.NO_MATCH) {
            return s;
        }
        List<String> roles = ACLConfigurationParser.getMethodNameWildcardRoles(properties, methodName);
        if (roles != null) {
            addToRoles.addAll(roles);
            return Specificity.WILDCARD_MATCH;
        }
        if (compulsoryRoles != null && !pid.contains("jmx.acl")) {
            addToRoles.addAll(ACLConfigurationParser.parseRoles(compulsoryRoles));
            return Specificity.NAME_MATCH;
        }
        return Specificity.NO_MATCH;
    }

    public static Specificity getRolesForInvocationForAlias(String methodName, Object[] params, String[] signature, Dictionary<String, Object> config, List<String> addToRoles) {
        Dictionary<String, Object> properties = ACLConfigurationParser.trimKeys(config);
        String pid = (String)properties.get("service.pid");
        Specificity s = ACLConfigurationParser.getRolesBasedOnSignature(methodName, params, signature, properties, addToRoles);
        if (s != Specificity.NO_MATCH) {
            return s;
        }
        s = ACLConfigurationParser.getRolesBasedOnSignature(methodName, params, null, properties, addToRoles);
        if (s != Specificity.NO_MATCH) {
            return s;
        }
        List<String> roles = ACLConfigurationParser.getMethodNameWildcardRoles(properties, methodName);
        if (roles != null) {
            addToRoles.addAll(roles);
            return Specificity.WILDCARD_MATCH;
        }
        return Specificity.NO_MATCH;
    }

    public static void getCompulsoryRoles(List<String> roles) {
        if (compulsoryRoles != null) {
            roles.addAll(ACLConfigurationParser.parseRoles(compulsoryRoles));
        }
    }

    private static Specificity getRolesBasedOnSignature(String methodName, Object[] params, String[] signature, Dictionary<String, Object> properties, List<String> roles) {
        Object signatureRoles;
        if (params != null) {
            List<String> r;
            boolean foundExactOrRegex = false;
            Object exactArgMatchRoles = properties.get(ACLConfigurationParser.getExactArgSignature(methodName, signature, params));
            if (exactArgMatchRoles instanceof String) {
                roles.addAll(ACLConfigurationParser.parseRoles((String)exactArgMatchRoles));
                foundExactOrRegex = true;
            }
            if ((r = ACLConfigurationParser.getRegexRoles(properties, methodName, signature, params)) != null) {
                foundExactOrRegex = true;
                roles.addAll(r);
            }
            if (foundExactOrRegex) {
                return Specificity.ARGUMENT_MATCH;
            }
        } else {
            List<String> r = ACLConfigurationParser.getExactArgOrRegexRoles(properties, methodName, signature);
            if (r != null) {
                roles.addAll(r);
            }
        }
        if ((signatureRoles = properties.get(ACLConfigurationParser.getSignature(methodName, signature))) instanceof String) {
            roles.addAll(ACLConfigurationParser.parseRoles((String)signatureRoles));
            return signature == null ? Specificity.NAME_MATCH : Specificity.SIGNATURE_MATCH;
        }
        return Specificity.NO_MATCH;
    }

    private static Dictionary<String, Object> trimKeys(Dictionary<String, Object> properties) {
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        Enumeration<String> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object value = properties.get(key);
            ((Dictionary)d).put(ACLConfigurationParser.removeSpaces(key), value);
        }
        return d;
    }

    private static String removeSpaces(String key) {
        StringBuilder sb = new StringBuilder();
        char quoteChar = '\u0000';
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (quoteChar == '\u0000' && c == ' ') continue;
            if (!(quoteChar != '\u0000' || c != '\"' && c != '/' || sb.length() <= 0 || sb.charAt(sb.length() - 1) != '[' && sb.charAt(sb.length() - 1) != ',')) {
                quoteChar = c;
            } else if (quoteChar != '\u0000' && c == quoteChar) {
                for (int j = i + 1; j < key.length(); ++j) {
                    if (key.charAt(j) == ' ') continue;
                    if (key.charAt(j) != ']' && key.charAt(j) != ',') break;
                    quoteChar = '\u0000';
                    break;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static List<String> parseRoles(String roleStr) {
        int hashIdx = roleStr.indexOf(35);
        if (hashIdx >= 0) {
            roleStr = roleStr.substring(0, hashIdx);
        }
        ArrayList<String> roles = new ArrayList<String>();
        for (String role : roleStr.split("[,]")) {
            String trimmed = role.trim();
            if (trimmed.length() <= 0) continue;
            roles.add(trimmed);
        }
        return roles;
    }

    private static Object getExactArgSignature(String methodName, String[] signature, Object[] params) {
        StringBuilder sb = new StringBuilder(ACLConfigurationParser.getSignature(methodName, signature));
        sb.append('[');
        boolean first = true;
        for (Object param : params) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append('\"');
            if (param != null) {
                sb.append(param.toString().trim());
            }
            sb.append('\"');
        }
        sb.append(']');
        return sb.toString();
    }

    private static String getSignature(String methodName, String[] signature) {
        StringBuilder sb = new StringBuilder(methodName);
        if (signature == null) {
            return sb.toString();
        }
        sb.append('(');
        boolean first = true;
        for (String s : signature) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(s);
        }
        sb.append(')');
        return sb.toString();
    }

    private static List<String> getRegexRoles(Dictionary<String, Object> properties, String methodName, String[] signature, Object[] params) {
        ArrayList<String> roles = new ArrayList<String>();
        boolean matchFound = false;
        String methodSig = ACLConfigurationParser.getSignature(methodName, signature);
        String prefix = methodSig + "[/";
        Enumeration<String> e = properties.keys();
        while (e.hasMoreElements()) {
            List<String> regexArgs;
            String key = e.nextElement().trim();
            if (!key.startsWith(prefix) || !key.endsWith("/]") || !ACLConfigurationParser.allParamsMatch(regexArgs = ACLConfigurationParser.getRegexDecl(key.substring(methodSig.length())), params)) continue;
            matchFound = true;
            Object roleStr = properties.get(key);
            if (!(roleStr instanceof String)) continue;
            roles.addAll(ACLConfigurationParser.parseRoles((String)roleStr));
        }
        return matchFound ? roles : null;
    }

    private static List<String> getExactArgOrRegexRoles(Dictionary<String, Object> properties, String methodName, String[] signature) {
        ArrayList<String> roles = new ArrayList<String>();
        boolean matchFound = false;
        String methodSig = ACLConfigurationParser.getSignature(methodName, signature);
        String prefix = methodSig + "[";
        Enumeration<String> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().trim();
            if (!key.startsWith(prefix) || !key.endsWith("]")) continue;
            matchFound = true;
            Object roleStr = properties.get(key);
            if (!(roleStr instanceof String)) continue;
            roles.addAll(ACLConfigurationParser.parseRoles((String)roleStr));
        }
        return matchFound ? roles : null;
    }

    private static List<String> getMethodNameWildcardRoles(Dictionary<String, Object> properties, String methodName) {
        TreeMap<String, String> wildcardRules = new TreeMap<String, String>((s1, s2) -> s2.length() - s1.length());
        Enumeration<String> e = properties.keys();
        while (e.hasMoreElements()) {
            String middle;
            String suffix;
            String prefix;
            String key = e.nextElement();
            if (key.endsWith("*") && methodName.startsWith(prefix = key.substring(0, key.length() - 1))) {
                wildcardRules.put(prefix, properties.get(key).toString());
            }
            if (key.startsWith("*") && methodName.endsWith(suffix = key.substring(1))) {
                wildcardRules.put(suffix, properties.get(key).toString());
            }
            if (!key.startsWith("*") || !key.endsWith("*") || key.length() <= 1 || !methodName.contains(middle = key.substring(1, key.length() - 1))) continue;
            wildcardRules.put(middle, properties.get(key).toString());
        }
        if (wildcardRules.size() != 0) {
            return ACLConfigurationParser.parseRoles((String)wildcardRules.values().iterator().next());
        }
        return null;
    }

    private static boolean allParamsMatch(List<String> regexArgs, Object[] params) {
        if (regexArgs.size() != params.length) {
            return false;
        }
        for (int i = 0; i < regexArgs.size(); ++i) {
            if (params[i] == null) {
                return false;
            }
            if (params[i].toString().trim().matches(regexArgs.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<String> getRegexDecl(String key) {
        ArrayList<String> l = new ArrayList<String>();
        boolean inRegex = false;
        StringBuilder curRegex = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            String s;
            if (!inRegex) {
                if (key.length() <= i + 1 || !"[/".equals(s = key.substring(i, i + 2)) && !",/".equals(s)) continue;
                inRegex = true;
                ++i;
                continue;
            }
            s = key.substring(i, i + 2);
            if ("/]".equals(s) || "/,".equals(s)) {
                l.add(curRegex.toString());
                curRegex = new StringBuilder();
                inRegex = false;
                continue;
            }
            curRegex.append(key.charAt(i));
        }
        return l;
    }

    public static enum Specificity {
        ARGUMENT_MATCH,
        SIGNATURE_MATCH,
        NAME_MATCH,
        WILDCARD_MATCH,
        NO_MATCH;

    }
}

