/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.internal.cache;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioException;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.FixedLengthAudioStream;
import org.openhab.core.cache.lru.InputStreamCacheWrapper;
import org.openhab.core.voice.internal.cache.AudioFormatInfo;

@NonNullByDefault
public class AudioStreamFromCache
extends FixedLengthAudioStream {
    private InputStreamCacheWrapper inputStream;
    private AudioFormat audioFormat;
    private String key;

    public AudioStreamFromCache(InputStreamCacheWrapper inputStream, AudioFormatInfo audioFormat, String key) {
        this.inputStream = inputStream;
        this.audioFormat = audioFormat.toAudioFormat();
        this.key = key;
    }

    public int read() throws IOException {
        return this.inputStream.read();
    }

    public int read(byte @Nullable [] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    public AudioFormat getFormat() {
        return this.audioFormat;
    }

    public long length() {
        return this.inputStream.length();
    }

    public InputStream getClonedStream() throws AudioException {
        try {
            return this.inputStream.getClonedStream();
        }
        catch (IOException e) {
            throw new AudioException("Cannot get cloned AudioStream", (Throwable)e);
        }
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    public void skipNBytes(long n) throws IOException {
        this.inputStream.skipNBytes(n);
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public @Nullable String getId() {
        return this.key;
    }
}

