/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Rule;

@NonNullByDefault
public class RulePredicates {
    public static final String PREFIX_SEPARATOR = ":";

    public static @Nullable String getPrefix(@Nullable Rule rule) {
        String uid;
        int index;
        if (rule != null && (index = (uid = rule.getUID()).indexOf(PREFIX_SEPARATOR)) > 0) {
            return uid.substring(0, index);
        }
        return null;
    }

    public static Predicate<Rule> hasPrefix(@Nullable String prefix) {
        if (prefix == null) {
            return r -> RulePredicates.getPrefix(r) == null;
        }
        return r -> prefix.equals(RulePredicates.getPrefix(r));
    }

    public static Predicate<Rule> hasAnyOfPrefixes(String ... prefixes) {
        HashSet<String> namespaceSet = new HashSet<String>(prefixes.length);
        namespaceSet.addAll(Arrays.asList(prefixes));
        return r -> namespaceSet.contains(RulePredicates.getPrefix(r));
    }

    public static Predicate<Rule> hasTags() {
        return r -> !r.getTags().isEmpty();
    }

    public static Predicate<Rule> hasNoTags() {
        return r -> r.getTags().isEmpty();
    }

    public static Predicate<Rule> hasAllTags(@Nullable Collection<String> tags) {
        if (tags == null || tags.isEmpty()) {
            return r -> true;
        }
        HashSet<String> tagSet = new HashSet<String>(tags);
        return r -> r.getTags().containsAll(tagSet);
    }

    public static Predicate<Rule> hasAllTags(String ... tags) {
        return RulePredicates.hasAllTags(tags == null ? null : Arrays.asList(tags));
    }

    public static Predicate<Rule> hasAnyOfTags(@Nullable Collection<String> tags) {
        if (tags == null || tags.isEmpty()) {
            return RulePredicates.hasNoTags();
        }
        HashSet<String> tagSet = new HashSet<String>(tags);
        return r -> !Collections.disjoint(r.getTags(), tagSet);
    }

    public static Predicate<Rule> hasAnyOfTags(String ... tags) {
        if (tags == null || tags.length == 0) {
            return RulePredicates.hasNoTags();
        }
        return RulePredicates.hasAnyOfTags(Arrays.asList(tags));
    }
}

