/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.RemoteEndpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.ReliabilityLayerParameters;

public class RemoteEndpointManager {
    private final int MAX_REMOTE_ENDPOINTS = 10;
    private LimitedRemoteEndpointHashmap<InetAddress, RemoteEndpoint> remoteEndpointsList = new LimitedRemoteEndpointHashmap(10);
    private final ReliabilityLayerParameters defaultReliabilityLayerParameters;

    public RemoteEndpointManager(NetworkConfig config) {
        this.defaultReliabilityLayerParameters = ReliabilityLayerParameters.builder().applyConfig(config).build();
    }

    public RemoteEndpoint getRemoteEndpoint(Exchange exchange) {
        InetSocketAddress remoteSocketAddress = exchange.getRequest().getDestinationContext().getPeerAddress();
        InetAddress remoteAddress = remoteSocketAddress.getAddress();
        int remotePort = remoteSocketAddress.getPort();
        if (!this.remoteEndpointsList.containsKey(remoteAddress)) {
            ReliabilityLayerParameters parameters = exchange.getRequest().getReliabilityLayerParameters();
            if (parameters == null) {
                parameters = this.defaultReliabilityLayerParameters;
            }
            RemoteEndpoint unusedRemoteEndpoint = new RemoteEndpoint(remotePort, remoteAddress, parameters);
            this.remoteEndpointsList.put(remoteAddress, unusedRemoteEndpoint);
        }
        return (RemoteEndpoint)this.remoteEndpointsList.get(remoteAddress);
    }

    public class LimitedRemoteEndpointHashmap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -7855412701242966797L;
        private final int maxSize;

        public LimitedRemoteEndpointHashmap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

