/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.core.network.MessageIdTracker;

public class NullMessageIdTracker
implements MessageIdTracker {
    private final AtomicInteger currentMID = new AtomicInteger();
    private final int min;
    private final int range;

    public NullMessageIdTracker(int initialMid, int minMid, int maxMid) {
        if (minMid >= maxMid) {
            throw new IllegalArgumentException("max. MID " + maxMid + " must be larger than min. MID " + minMid + "!");
        }
        if (initialMid < minMid || maxMid <= initialMid) {
            throw new IllegalArgumentException("initial MID " + initialMid + " must be in range [" + minMid + "-" + maxMid + ")!");
        }
        this.currentMID.set(initialMid - minMid);
        this.min = minMid;
        this.range = maxMid - minMid;
    }

    @Override
    public int getNextMessageId() {
        int mid = this.currentMID.getAndIncrement();
        int result = mid % this.range;
        if (result == this.range - 1) {
            this.currentMID.addAndGet(-this.range);
        }
        return this.min + mid;
    }
}

