/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.net.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ExecUtil {
    private static Logger logger = LoggerFactory.getLogger(ExecUtil.class);
    private static ExecutorService executor = ThreadPoolManager.getPool((String)"ExecUtil");

    public static void executeCommandLine(String ... commandLine) {
        try {
            new ProcessBuilder(commandLine).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).start();
        }
        catch (IOException e) {
            logger.warn("Error occurred when executing commandLine '{}'", (Object)commandLine, (Object)e);
        }
    }

    public static @Nullable String executeCommandLineAndWaitResponse(@Nullable Duration timeout, String ... commandLine) {
        Process processTemp = null;
        Future<String> outputFuture = null;
        try {
            block15: {
                block14: {
                    Process process;
                    block13: {
                        process = processTemp = new ProcessBuilder(commandLine).redirectErrorStream(true).start();
                        outputFuture = executor.submit(() -> {
                            Throwable throwable = null;
                            Object var2_3 = null;
                            try {
                                String string;
                                BufferedReader reader;
                                InputStream inputStream;
                                block16: {
                                    block15: {
                                        inputStream = process.getInputStream();
                                        reader = new BufferedReader(new InputStreamReader(inputStream));
                                        StringWriter output = new StringWriter();
                                        reader.transferTo(output);
                                        string = output.toString();
                                        if (reader == null) break block15;
                                        reader.close();
                                    }
                                    if (inputStream == null) break block16;
                                    inputStream.close();
                                }
                                return string;
                                {
                                    catch (Throwable throwable2) {
                                        try {
                                            if (reader != null) {
                                                reader.close();
                                            }
                                            throw throwable2;
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable == null) {
                                                throwable = throwable3;
                                            } else if (throwable != throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            if (inputStream != null) {
                                                inputStream.close();
                                            }
                                            throw throwable;
                                        }
                                    }
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        });
                        if (timeout != null) break block13;
                        process.waitFor();
                        break block14;
                    }
                    if (!process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS)) break block15;
                }
                return outputFuture.get();
            }
            logger.warn("Timeout occurred when executing commandLine '{}'", (Object)Arrays.toString(commandLine));
        }
        catch (ExecutionException e) {
            if (logger.isDebugEnabled()) {
                logger.warn("Error occurred when executing commandLine '{}'", (Object)Arrays.toString(commandLine), (Object)e.getCause());
            } else {
                logger.warn("Error occurred when executing commandLine '{}'", (Object)Arrays.toString(commandLine));
            }
        }
        catch (InterruptedException e) {
            logger.debug("commandLine '{}' was interrupted", (Object)Arrays.toString(commandLine), (Object)e);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.warn("Failed to execute commandLine '{}'", (Object)Arrays.toString(commandLine), (Object)e);
            }
            logger.warn("Failed to execute commandLine '{}'", (Object)Arrays.toString(commandLine));
        }
        if (processTemp != null && processTemp.isAlive()) {
            processTemp.destroyForcibly();
        }
        if (outputFuture != null) {
            outputFuture.cancel(true);
        }
        return null;
    }
}

