/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.packages.core.internal.filter;

import java.util.HashMap;
import java.util.Map;

public class ExprTokenizer {
    private String expr;
    private int currentPos;
    String[] operators = new String[]{"(", ")", "!", "&", "=", ">="};
    Map<Character, String> operatorMap;

    public ExprTokenizer(String expr) {
        this.expr = expr;
        this.currentPos = 0;
        this.operatorMap = new HashMap<Character, String>();
        for (String operator : this.operators) {
            this.operatorMap.put(Character.valueOf(operator.charAt(0)), operator);
        }
    }

    public String peekNextToken() {
        int oldPos = this.currentPos;
        String token = this.nextToken();
        this.currentPos = oldPos;
        return token;
    }

    public String nextToken() {
        if (this.currentPos >= this.expr.length()) {
            return null;
        }
        while (this.isWhiteSpace()) {
            ++this.currentPos;
        }
        Character first = Character.valueOf(this.expr.charAt(this.currentPos));
        String operator = this.operatorMap.get(first);
        if (operator != null) {
            this.currentPos += operator.length();
            return operator;
        }
        int firstPos = this.currentPos;
        while (this.currentPos < this.expr.length() && !this.operatorMap.containsKey(Character.valueOf(this.expr.charAt(this.currentPos))) && !this.isWhiteSpace()) {
            ++this.currentPos;
        }
        return this.expr.substring(firstPos, this.currentPos);
    }

    private boolean isWhiteSpace() {
        return this.expr.charAt(this.currentPos) == ' ';
    }

    public String toString() {
        return this.expr.substring(this.currentPos);
    }
}

