/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.sitemap.valueconverter;

import java.util.regex.Pattern;
import org.eclipse.xtext.common.services.DefaultTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.nodemodel.INode;

public class SitemapConverters
extends DefaultTerminalConverters {
    private static final Pattern ID_PATTERN = Pattern.compile("\\p{Alpha}\\w*");

    @ValueConverter(rule="Icon")
    public IValueConverter<String> Icon() {
        return new IValueConverter<String>(){

            public String toValue(String string, INode node) throws ValueConverterException {
                if (string != null && string.startsWith("\"")) {
                    return string.substring(1, string.length() - 1);
                }
                return string;
            }

            public String toString(String value) throws ValueConverterException {
                if (SitemapConverters.containsWhiteSpace(value)) {
                    return "\"" + value + "\"";
                }
                return value;
            }
        };
    }

    @ValueConverter(rule="Command")
    public IValueConverter<String> Command() {
        return new AbstractNullSafeConverter<String>(){

            protected String internalToValue(String string, INode node) {
                if (string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\"")) {
                    return (String)SitemapConverters.this.STRING().toValue(string, node);
                }
                return (String)SitemapConverters.this.ID().toValue(string, node);
            }

            protected String internalToString(String value) {
                if (ID_PATTERN.matcher(value).matches()) {
                    return SitemapConverters.this.ID().toString((Object)value);
                }
                return SitemapConverters.this.STRING().toString((Object)value);
            }
        };
    }

    public static boolean containsWhiteSpace(String string) {
        if (string != null) {
            int i = 0;
            while (i < string.length()) {
                if (Character.isWhitespace(string.charAt(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

