/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.auth.internal;

import java.security.Principal;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.auth.Authentication;
import org.openhab.core.auth.GenericUser;
import org.openhab.core.io.rest.auth.internal.AuthenticationSecurityContext;

@NonNullByDefault
public class JwtSecurityContext
implements AuthenticationSecurityContext {
    Authentication authentication;

    public JwtSecurityContext(Authentication authentication) {
        this.authentication = authentication;
    }

    public Principal getUserPrincipal() {
        return new GenericUser(this.authentication.getUsername());
    }

    public boolean isUserInRole(@Nullable String role) {
        return this.authentication.getRoles().contains(role);
    }

    public boolean isSecure() {
        return true;
    }

    public String getAuthenticationScheme() {
        return "JWT";
    }

    @Override
    public Authentication getAuthentication() {
        return this.authentication;
    }
}

