/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.auth.internal;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.rest.auth.internal.UserSecurityContext;

@NonNullByDefault
public class ExpiringUserSecurityContextCache {
    static final int MAX_SIZE = 10;
    static final int CLEANUP_FREQUENCY = 10;
    private final long keepPeriod;
    private final Map<String, MyEntry> entryMap;
    private int calls = 0;

    public ExpiringUserSecurityContextCache(long expirationTime) {
        this.keepPeriod = expirationTime;
        this.entryMap = new LinkedHashMap<String, MyEntry>(){
            private static final long serialVersionUID = -1220310861591070462L;

            @Override
            protected boolean removeEldestEntry(@Nullable Map.Entry<String, MyEntry> eldest) {
                return this.size() > 10;
            }
        };
    }

    public synchronized @Nullable UserSecurityContext get(String key) {
        MyEntry entry;
        ++this.calls;
        if (this.calls >= 10) {
            new HashSet<String>(this.entryMap.keySet()).forEach(k -> {
                MyEntry myEntry = this.getEntry((String)k);
            });
            this.calls = 0;
        }
        if ((entry = this.getEntry(key)) != null) {
            return entry.value;
        }
        return null;
    }

    public synchronized void put(String key, UserSecurityContext value) {
        this.entryMap.put(key, new MyEntry(System.currentTimeMillis(), value));
    }

    public synchronized void clear() {
        this.entryMap.clear();
    }

    private @Nullable MyEntry getEntry(String key) {
        MyEntry entry = this.entryMap.get(key);
        if (entry != null) {
            long curTimeMillis = System.currentTimeMillis();
            long entryAge = curTimeMillis - entry.timestamp;
            if (entryAge < 0L || entryAge >= this.keepPeriod) {
                this.entryMap.remove(key);
                entry = null;
            } else {
                entry.timestamp = curTimeMillis;
            }
        }
        return entry;
    }

    static class MyEntry {
        public long timestamp;
        public final UserSecurityContext value;

        MyEntry(long timestamp, UserSecurityContext value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

