/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.jetty;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Request;
import org.jupnp.http.Headers;

public class HeaderUtil {
    private HeaderUtil() {
    }

    public static void add(org.eclipse.jetty.client.api.Request request, Headers headers) {
        HttpFields httpFields = request.getHeaders();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            for (String value : entry.getValue()) {
                httpFields.add(entry.getKey(), value);
            }
        }
    }

    public static void add(HttpServletResponse response, Headers headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            for (String value : entry.getValue()) {
                response.addHeader(entry.getKey(), value);
            }
        }
    }

    public static Headers get(Response response) {
        Headers headers = new Headers();
        for (HttpField httpField : response.getHeaders()) {
            headers.add(httpField.getName(), httpField.getValue());
        }
        return headers;
    }

    public static Headers get(Request request) {
        Headers headers = new Headers();
        for (HttpField httpField : request.getHttpFields()) {
            headers.add(httpField.getName(), httpField.getValue());
        }
        return headers;
    }

    public static String getContent(org.eclipse.jetty.client.api.Request request) {
        ContentProvider provider = request.getContent();
        StringBuilder sb = new StringBuilder();
        for (ByteBuffer next : provider) {
            byte[] bytes = new byte[next.capacity()];
            next.get(bytes);
            String content = new String(bytes, StandardCharsets.UTF_8);
            sb.append(content);
        }
        return sb.toString();
    }

    public static byte[] getBytes(org.eclipse.jetty.client.api.Request request) {
        ContentProvider provider = request.getContent();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (ByteBuffer next : provider) {
            byte[] bytes = new byte[next.capacity()];
            next.get(bytes);
            bos.write(bytes, 0, bytes.length);
        }
        return bos.toByteArray();
    }

    public static byte[] getBytes(Request request) throws IOException {
        int len;
        ServletInputStream is = request.getInputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while (0 < (len = is.read(bytes))) {
            bos.write(bytes, 0, len);
        }
        return bos.toByteArray();
    }
}

