/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jupnp.UpnpService;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.DeviceDescriptorBinder;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.model.ValidationError;
import org.jupnp.model.ValidationException;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.registry.RegistrationException;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveRemoteDescriptors
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(RetrieveRemoteDescriptors.class);
    private final UpnpService upnpService;
    private RemoteDevice rd;
    private static final ConcurrentHashMap<URL, Boolean> activeRetrievals = new ConcurrentHashMap();
    protected List<UDN> errorsAlreadyLogged = new ArrayList<UDN>();

    public RetrieveRemoteDescriptors(UpnpService upnpService, RemoteDevice rd) {
        this.upnpService = upnpService;
        this.rd = rd;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    @Override
    public void run() {
        URL deviceURL = ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL();
        if (this.getUpnpService().getRegistry().getRemoteDevice(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn(), true) != null) {
            this.logger.trace("Exiting early, already discovered: {}", (Object)deviceURL);
            return;
        }
        if (activeRetrievals.putIfAbsent(deviceURL, Boolean.TRUE) != null) {
            this.logger.trace("Exiting early, active retrieval for URL already in progress: {}", (Object)deviceURL);
            return;
        }
        try {
            this.describe();
        }
        catch (RouterException e) {
            this.logger.warn("Descriptor retrieval failed: {}", (Object)deviceURL, (Object)e);
        }
        finally {
            activeRetrievals.remove(deviceURL);
        }
    }

    protected void describe() throws RouterException {
        String descriptorContent;
        StreamResponseMessage deviceDescMsg;
        if (this.getUpnpService().getRouter() == null) {
            this.logger.warn("Router not yet initialized");
            return;
        }
        try {
            StreamRequestMessage deviceDescRetrievalMsg = new StreamRequestMessage(UpnpRequest.Method.GET, ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            UpnpHeaders headers = this.getUpnpService().getConfiguration().getDescriptorRetrievalHeaders((RemoteDeviceIdentity)this.rd.getIdentity());
            if (headers != null) {
                deviceDescRetrievalMsg.getHeaders().putAll(headers);
            }
            this.logger.debug("Sending device descriptor retrieval message: {}", (Object)deviceDescRetrievalMsg);
            deviceDescMsg = this.getUpnpService().getRouter().send(deviceDescRetrievalMsg);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Device descriptor retrieval failed: {}, possibly invalid URL", (Object)((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL(), (Object)e);
            return;
        }
        if (deviceDescMsg == null) {
            this.logger.warn("Device descriptor retrieval failed, no response: {}", (Object)((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            return;
        }
        if (((UpnpResponse)deviceDescMsg.getOperation()).isFailed()) {
            this.logger.warn("Device descriptor retrieval failed: {}, {}", (Object)((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL(), (Object)((UpnpResponse)deviceDescMsg.getOperation()).getResponseDetails());
            return;
        }
        if (!deviceDescMsg.isContentTypeTextUDA()) {
            this.logger.debug("Received device descriptor without or with invalid Content-Type: {}", (Object)((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
        }
        if ((descriptorContent = deviceDescMsg.getBodyString()) == null || descriptorContent.isEmpty()) {
            this.logger.warn("Received empty device descriptor: {}", (Object)((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            return;
        }
        this.logger.debug("Received root device descriptor: {}", (Object)deviceDescMsg);
        this.describe(descriptorContent);
    }

    protected void describe(String descriptorXML) throws RouterException {
        block12: {
            boolean notifiedStart = false;
            RemoteDevice describedDevice = null;
            try {
                DeviceDescriptorBinder deviceDescriptorBinder = this.getUpnpService().getConfiguration().getDeviceDescriptorBinderUDA10();
                describedDevice = deviceDescriptorBinder.describe(this.rd, descriptorXML);
                this.logger.debug("Remote device described (without services) notifying listeners: {}", (Object)describedDevice);
                notifiedStart = this.getUpnpService().getRegistry().notifyDiscoveryStart(describedDevice);
                this.logger.debug("Hydrating described device's services: {}", (Object)describedDevice);
                RemoteDevice hydratedDevice = this.describeServices(describedDevice);
                if (hydratedDevice == null) {
                    if (!this.errorsAlreadyLogged.contains(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn())) {
                        this.errorsAlreadyLogged.add(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn());
                        this.logger.warn("Device service description failed: {}", (Object)this.rd);
                    }
                    if (notifiedStart) {
                        this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, new DescriptorBindingException("Device service description failed: " + String.valueOf(this.rd)));
                        this.logger.debug("Adding described remote device to registry: {}", (Object)describedDevice);
                        this.getUpnpService().getRegistry().addDevice(describedDevice);
                        return;
                    }
                } else {
                    this.logger.debug("Adding fully hydrated remote device to registry: {}", (Object)hydratedDevice);
                    this.getUpnpService().getRegistry().addDevice(hydratedDevice);
                }
            }
            catch (ValidationException e) {
                if (!this.errorsAlreadyLogged.contains(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn())) {
                    this.errorsAlreadyLogged.add(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn());
                    this.logger.warn("Could not validate device model: {}", (Object)this.rd);
                    for (ValidationError validationError : e.getErrors()) {
                        this.logger.warn(validationError.toString());
                    }
                    if (describedDevice != null && notifiedStart) {
                        this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, e);
                    }
                }
            }
            catch (DescriptorBindingException e) {
                this.logger.warn("Could not hydrate device or its services from descriptor: {}", (Object)this.rd, (Object)e);
                if (describedDevice != null && notifiedStart) {
                    this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, e);
                }
            }
            catch (RegistrationException e) {
                this.logger.warn("Adding hydrated device to registry failed: {}", (Object)this.rd, (Object)e);
                if (describedDevice == null || !notifiedStart) break block12;
                this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, e);
            }
        }
    }

    protected RemoteDevice describeServices(RemoteDevice currentDevice) throws RouterException, DescriptorBindingException, ValidationException {
        ArrayList<RemoteService> describedServices = new ArrayList<RemoteService>();
        if (currentDevice.hasServices()) {
            List<RemoteService> filteredServices = this.filterExclusiveServices(currentDevice.getServices());
            for (RemoteService service : filteredServices) {
                RemoteService svc = this.describeService(service);
                if (svc == null) continue;
                describedServices.add(svc);
            }
        }
        ArrayList<RemoteDevice> describedEmbeddedDevices = new ArrayList<RemoteDevice>();
        if (currentDevice.hasEmbeddedDevices()) {
            for (RemoteDevice embeddedDevice : currentDevice.getEmbeddedDevices()) {
                RemoteDevice describedEmbeddedDevice;
                if (embeddedDevice == null || (describedEmbeddedDevice = this.describeServices(embeddedDevice)) == null) continue;
                describedEmbeddedDevices.add(describedEmbeddedDevice);
            }
        }
        if (currentDevice.hasServices() && describedServices.isEmpty() || currentDevice.hasEmbeddedDevices() && describedEmbeddedDevices.isEmpty()) {
            return null;
        }
        Icon[] iconDupes = new Icon[currentDevice.getIcons().length];
        for (int i = 0; i < currentDevice.getIcons().length; ++i) {
            Icon icon = currentDevice.getIcons()[i];
            iconDupes[i] = icon.deepCopy();
        }
        return currentDevice.newInstance(((RemoteDeviceIdentity)currentDevice.getIdentity()).getUdn(), currentDevice.getVersion(), currentDevice.getType(), currentDevice.getDetails(), iconDupes, currentDevice.toServiceArray((Collection<RemoteService>)describedServices), (List<RemoteDevice>)describedEmbeddedDevices);
    }

    protected RemoteService describeService(RemoteService service) throws RouterException, DescriptorBindingException, ValidationException {
        String descriptorContent;
        URL descriptorURL;
        try {
            descriptorURL = ((RemoteDevice)service.getDevice()).normalizeURI(service.getDescriptorURI());
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Could not normalize service descriptor URL: {}", (Object)service.getDescriptorURI());
            return null;
        }
        StreamRequestMessage serviceDescRetrievalMsg = new StreamRequestMessage(UpnpRequest.Method.GET, descriptorURL);
        UpnpHeaders headers = this.getUpnpService().getConfiguration().getDescriptorRetrievalHeaders((RemoteDeviceIdentity)((RemoteDevice)service.getDevice()).getIdentity());
        if (headers != null) {
            serviceDescRetrievalMsg.getHeaders().putAll(headers);
        }
        this.logger.debug("Sending service descriptor retrieval message: {}", (Object)serviceDescRetrievalMsg);
        StreamResponseMessage serviceDescMsg = this.getUpnpService().getRouter().send(serviceDescRetrievalMsg);
        if (serviceDescMsg == null) {
            this.logger.warn("Could not retrieve service descriptor, no response: {}", (Object)service);
            return null;
        }
        if (((UpnpResponse)serviceDescMsg.getOperation()).isFailed()) {
            this.logger.warn("Service descriptor retrieval failed: {}, {}", (Object)descriptorURL, (Object)((UpnpResponse)serviceDescMsg.getOperation()).getResponseDetails());
            return null;
        }
        if (!serviceDescMsg.isContentTypeTextUDA()) {
            this.logger.debug("Received service descriptor without or with invalid Content-Type: {}", (Object)descriptorURL);
        }
        if ((descriptorContent = serviceDescMsg.getBodyString()) == null || descriptorContent.isEmpty()) {
            this.logger.warn("Received empty service descriptor: {}", (Object)descriptorURL);
            return null;
        }
        this.logger.debug("Received service descriptor, hydrating service model: {}", (Object)serviceDescMsg);
        ServiceDescriptorBinder serviceDescriptorBinder = this.getUpnpService().getConfiguration().getServiceDescriptorBinderUDA10();
        return serviceDescriptorBinder.describe(service, descriptorContent);
    }

    protected List<RemoteService> filterExclusiveServices(RemoteService[] services) {
        ServiceType[] exclusiveTypes = this.getUpnpService().getConfiguration().getExclusiveServiceTypes();
        if (exclusiveTypes == null || exclusiveTypes.length == 0) {
            return Arrays.asList(services);
        }
        ArrayList<RemoteService> exclusiveServices = new ArrayList<RemoteService>();
        for (RemoteService discoveredService : services) {
            for (ServiceType exclusiveType : exclusiveTypes) {
                if (discoveredService.getServiceType().implementsVersion(exclusiveType)) {
                    this.logger.debug("Including exclusive service: {}", (Object)discoveredService);
                    exclusiveServices.add(discoveredService);
                    continue;
                }
                this.logger.debug("Excluding unwanted service: {}", (Object)exclusiveType);
            }
        }
        return exclusiveServices;
    }

    public static boolean isRetrievalInProgress(RemoteDevice rd) {
        if (rd == null) {
            throw new IllegalArgumentException("RemoteDevice must not be null!");
        }
        return activeRetrievals.containsKey(((RemoteDeviceIdentity)rd.getIdentity()).getDescriptorURL());
    }
}

