/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.internal.OSGiImpl;
import org.apache.aries.component.dsl.internal.OSGiResultImpl;
import org.apache.aries.component.dsl.internal.Pad;

public class HighestRankingOSGi<T>
extends OSGiImpl<T> {
    public HighestRankingOSGi(OSGi<T> previous, Comparator<? super T> comparator, Function<OSGi<T>, OSGi<T>> notHighest) {
        super((bundleContext, highestPipe) -> {
            Comparator<Tuple> comparing = Comparator.comparing(Tuple::getT, comparator);
            PriorityQueue<Tuple> set = new PriorityQueue<Tuple>(comparing.reversed());
            AtomicReference sent = new AtomicReference();
            Pad notHighestPad = new Pad(bundleContext, notHighest, highestPipe);
            OSGiResult result = previous.run(bundleContext, t -> {
                Tuple<Object> tuple = new Tuple<Object>(t);
                PriorityQueue priorityQueue = set;
                synchronized (priorityQueue) {
                    set.add(tuple);
                    if (set.peek() == tuple) {
                        Tuple old = (Tuple)sent.get();
                        if (old != null) {
                            old._runnable.run();
                        }
                        tuple._runnable = highestPipe.apply(t);
                        if (old != null) {
                            old._runnable = notHighestPad.publish(old._t);
                        }
                        sent.set(tuple);
                    } else {
                        tuple._runnable = notHighestPad.publish(t);
                    }
                }
                return () -> {
                    PriorityQueue priorityQueue = set;
                    synchronized (priorityQueue) {
                        Tuple old = (Tuple)set.peek();
                        set.remove(tuple);
                        Tuple current = (Tuple)set.peek();
                        tuple._runnable.run();
                        if (current != old && current != null) {
                            current._runnable.run();
                            current._runnable = highestPipe.apply(current._t);
                            sent.set(current);
                        }
                        if (current == null) {
                            sent.set(null);
                        }
                    }
                };
            });
            return new OSGiResultImpl(() -> {
                result.close();
                notHighestPad.close();
            });
        });
    }

    private static class Tuple<T> {
        T _t;
        Runnable _runnable;

        Tuple(T t) {
            this._t = t;
        }

        public T getT() {
            return this._t;
        }
    }
}

