/* (c) Copyright 2015-2016 Kevin Kelley <kelleyk@kelleyk.net>. */


// JPEG zigzag tables
var ZIGZAG_ORDER = [
    0, 1, 8, 16, 9, 2, 3, 10,
    17, 24, 32, 25, 18, 11, 4, 5,
    12, 19, 26, 33, 40, 48, 41, 34,
    27, 20, 13, 6, 7, 14, 21, 28,
    35, 42, 49, 56, 57, 50, 43, 36,
    29, 22, 15, 23, 30, 37, 44, 51,
    58, 59, 52, 45, 38, 31, 39, 46,
    53, 60, 61, 54, 47, 55, 62, 63,
];
var DEZIGZAG_ORDER = [
    0,  1,  5,  6, 14, 15, 27, 28,
    2,  4,  7, 13, 16, 26, 29, 42,
    3,  8, 12, 17, 25, 30, 41, 43,
    9, 11, 18, 24, 31, 40, 44, 53,
    10, 19, 23, 32, 39, 45, 52, 54,
    20, 22, 33, 38, 46, 51, 55, 60,
    21, 34, 37, 47, 50, 56, 59, 61,
    35, 36, 48, 49, 57, 58, 62, 63,
];


// Huffman tables
var BITS_DC_LUMA = [0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0];
var HUFFVAL_DC_LUMA = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11];
var BITS_DC_CHROMA = [0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0];
var HUFFVAL_DC_CHROMA = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11];
var BITS_AC_LUMA = [0, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 0x7d];
var HUFFVAL_AC_LUMA = [
    0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12,
    0x21, 0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07,
    0x22, 0x71, 0x14, 0x32, 0x81, 0x91, 0xa1, 0x08,
    0x23, 0x42, 0xb1, 0xc1, 0x15, 0x52, 0xd1, 0xf0,
    0x24, 0x33, 0x62, 0x72, 0x82, 0x09, 0x0a, 0x16,
    0x17, 0x18, 0x19, 0x1a, 0x25, 0x26, 0x27, 0x28,
    0x29, 0x2a, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
    0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
    0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
    0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
    0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
    0x7a, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89,
    0x8a, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98,
    0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
    0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6,
    0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5,
    0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4,
    0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xe1, 0xe2,
    0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
    0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
    0xf9, 0xfa
];
var BITS_AC_CHROMA = [0, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 0x77];
var HUFFVAL_AC_CHROMA  = [
    0x00, 0x01, 0x02, 0x03, 0x11, 0x04, 0x05, 0x21,
    0x31, 0x06, 0x12, 0x41, 0x51, 0x07, 0x61, 0x71,
    0x13, 0x22, 0x32, 0x81, 0x08, 0x14, 0x42, 0x91,
    0xa1, 0xb1, 0xc1, 0x09, 0x23, 0x33, 0x52, 0xf0,
    0x15, 0x62, 0x72, 0xd1, 0x0a, 0x16, 0x24, 0x34,
    0xe1, 0x25, 0xf1, 0x17, 0x18, 0x19, 0x1a, 0x26,
    0x27, 0x28, 0x29, 0x2a, 0x35, 0x36, 0x37, 0x38,
    0x39, 0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
    0x59, 0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
    0x69, 0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    0x88, 0x89, 0x8a, 0x92, 0x93, 0x94, 0x95, 0x96,
    0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5,
    0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4,
    0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3,
    0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2,
    0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda,
    0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9,
    0xea, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
    0xf9, 0xfa
];


// Quant tables
var ATEN_QT_LUMA = [
    [
        0x14, 0x0D, 0x0C, 0x14, 0x1E, 0x32, 0x3F, 0x4C,
        0x0F, 0x0F, 0x11, 0x17, 0x20, 0x48, 0x4B, 0x44,
        0x11, 0x10, 0x14, 0x1E, 0x32, 0x47, 0x56, 0x46,
        0x11, 0x15, 0x1B, 0x24, 0x3F, 0x6C, 0x64, 0x4D,
        0x16, 0x1B, 0x2E, 0x46, 0x55, 0x88, 0x80, 0x60,
        0x1E, 0x2B, 0x44, 0x50, 0x65, 0x82, 0x8D, 0x73,
        0x3D, 0x50, 0x61, 0x6C, 0x80, 0x97, 0x96, 0x7E,
        0x5A, 0x73, 0x76, 0x7A, 0x8C, 0x7D, 0x80, 0x7B,
    ], [
        0x11, 0x0C, 0x0A, 0x11, 0x1A, 0x2B, 0x37, 0x42,
        0x0D, 0x0D, 0x0F, 0x14, 0x1C, 0x3F, 0x41, 0x3C,
        0x0F, 0x0E, 0x11, 0x1A, 0x2B, 0x3E, 0x4B, 0x3D,
        0x0F, 0x12, 0x18, 0x1F, 0x37, 0x5F, 0x57, 0x43,
        0x13, 0x18, 0x28, 0x3D, 0x4A, 0x77, 0x70, 0x54,
        0x1A, 0x26, 0x3C, 0x46, 0x58, 0x71, 0x7B, 0x64,
        0x35, 0x46, 0x55, 0x5F, 0x70, 0x84, 0x83, 0x6E,
        0x4E, 0x64, 0x67, 0x6B, 0x7A, 0x6D, 0x70, 0x6C,
    ], [
        0x0E, 9, 9, 0x0E, 0x15, 0x24, 0x2E, 0x37,
        0x0A, 0x0A, 0x0C, 0x11, 0x17, 0x34, 0x36, 0x31,
        0x0C, 0x0B, 0x0E, 0x15, 0x24, 0x33, 0x3E, 0x32,
        0x0C, 0x0F, 0x13, 0x1A, 0x2E, 0x4E, 0x48, 0x38,
        0x10, 0x13, 0x21, 0x32, 0x3D, 0x62, 0x5D, 0x45,
        0x15, 0x1F, 0x31, 0x3A, 0x49, 0x5E, 0x66, 0x53,
        0x2C, 0x3A, 0x46, 0x4E, 0x5D, 0x6D, 0x6C, 0x5B,
        0x41, 0x53, 0x56, 0x58, 0x65, 0x5A, 0x5D, 0x59,
    ], [
        0x0B, 7, 7, 0x0B, 0x11, 0x1C, 0x24, 0x2B,
        8, 8, 0x0A, 0x0D, 0x12, 0x29, 0x2B, 0x27,
        0x0A, 9, 0x0B, 0x11, 0x1C, 0x28, 0x31, 0x28,
        0x0A, 0x0C, 0x0F, 0x14, 0x24, 0x3E, 0x39, 0x2C,
        0x0C, 0x0F, 0x1A, 0x28, 0x30, 0x4E, 0x4A, 0x37,
        0x11, 0x19, 0x27, 0x2E, 0x3A, 0x4A, 0x51, 0x42,
        0x23, 0x2E, 0x38, 0x3E, 0x4A, 0x56, 0x56, 0x48,
        0x33, 0x42, 0x44, 0x46, 0x50, 0x47, 0x4A, 0x47,
    ], [
        9, 6, 5, 9, 0x0D, 0x16, 0x1C, 0x22,
        6, 6, 7, 0x0A, 0x0E, 0x20, 0x21, 0x1E,
        7, 7, 9, 0x0D, 0x16, 0x20, 0x26, 0x1F,
        7, 9, 0x0C, 0x10, 0x1C, 0x30, 0x2D, 0x22,
        0x0A, 0x0C, 0x14, 0x1F, 0x26, 0x3D, 0x39, 0x2B,
        0x0D, 0x13, 0x1E, 0x24, 0x2D, 0x3A, 0x3F, 0x33,
        0x1B, 0x24, 0x2B, 0x30, 0x39, 0x44, 0x43, 0x38,
        0x28, 0x33, 0x35, 0x37, 0x3F, 0x38, 0x39, 0x37,
    ], [
        6, 4, 3, 6, 9, 0x0F, 0x13, 0x16,
        4, 4, 5, 7, 9, 0x15, 0x16, 0x14,
        5, 4, 6, 9, 0x0F, 0x15, 0x19, 0x15,
        5, 6, 8, 0x0A, 0x13, 0x20, 0x1E, 0x17,
        6, 8, 0x0D, 0x15, 0x19, 0x28, 0x26, 0x1C,
        9, 0x0D, 0x14, 0x18, 0x1E, 0x27, 0x2A, 0x22,
        0x12, 0x18, 0x1D, 0x20, 0x26, 0x2D, 0x2D, 0x25,
        0x1B, 0x22, 0x23, 0x24, 0x2A, 0x25, 0x26, 0x25,
    ], [
        3, 2, 1, 3, 4, 7, 9, 0x0B,
        2, 2, 2, 3, 4, 0x0A, 0x0B, 0x0A,
        2, 2, 3, 4, 7, 0x0A, 0x0C, 0x0A,
        2, 3, 4, 5, 9, 0x10, 0x0F, 0x0B,
        3, 4, 6, 0x0A, 0x0C, 0x14, 0x13, 0x0E,
        4, 6, 0x0A, 0x0C, 0x0F, 0x13, 0x15, 0x11,
        9, 0x0C, 0x0E, 0x10, 0x13, 0x16, 0x16, 0x12,
        0x0D, 0x11, 0x11, 0x12, 0x15, 0x12, 0x13, 0x12,
    ], [
        2, 1, 1, 2, 3, 5, 6, 7,
        1, 1, 1, 2, 3, 7, 7, 6,
        1, 1, 2, 3, 5, 7, 8, 7,
        1, 2, 2, 3, 6, 0x0A, 0x0A, 7,
        2, 2, 4, 7, 8, 0x0D, 0x0C, 9,
        3, 4, 6, 8, 0x0A, 0x0D, 0x0E, 0x0B,
        6, 8, 9, 0x0A, 0x0C, 0x0F, 0x0F, 0x0C,
        9, 0x0B, 0x0B, 0x0C, 0x0E, 0x0C, 0x0C, 0x0C,
    ], [
        2, 1, 1, 2, 3, 5, 6, 7,
        1, 1, 1, 2, 3, 7, 7, 6,
        1, 1, 2, 3, 5, 7, 8, 7,
        1, 2, 2, 3, 6, 0x0A, 0x0A, 7,
        2, 2, 4, 7, 8, 0x0D, 0x0C, 9,
        3, 4, 6, 8, 0x0A, 0x0D, 0x0E, 0x0B,
        6, 8, 9, 0x0A, 0x0C, 0x0F, 0x0F, 0x0C,
        9, 0x0B, 0x0B, 0x0C, 0x0E, 0x0C, 0x0C, 0x0C,
    ], [
        1, 1, 1, 1, 2, 3, 4, 5,
        1, 1, 1, 1, 2, 5, 5, 5,
        1, 1, 1, 2, 3, 5, 6, 5,
        1, 1, 2, 2, 4, 8, 7, 5,
        1, 2, 3, 5, 6, 0x0A, 9, 7,
        2, 3, 5, 6, 7, 9, 0x0A, 8,
        4, 6, 7, 8, 9, 0x0B, 0x0B, 9,
        6, 8, 8, 9, 0x0A, 9, 9, 9,
    ], [
        1, 1, 1, 1, 1, 2, 3, 3,
        1, 1, 1, 1, 1, 3, 3, 3,
        1, 1, 1, 1, 2, 3, 4, 3,
        1, 1, 1, 1, 3, 5, 5, 3,
        1, 1, 2, 3, 4, 6, 6, 4,
        1, 2, 3, 4, 5, 6, 7, 5,
        3, 4, 4, 5, 6, 7, 7, 6,
        4, 5, 5, 6, 7, 6, 6, 6,
    ], [
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 2, 1,
        1, 1, 1, 1, 1, 2, 2, 1,
        1, 1, 1, 1, 2, 3, 3, 2,
        1, 1, 1, 2, 2, 3, 3, 2,
        1, 2, 2, 2, 3, 3, 3, 3,
        2, 2, 2, 3, 3, 3, 3, 3,
    ]
];

var ATEN_QT_CHROMA = [
    [
        0x1F, 0x21, 0x2D, 0x58, 0x0B9, 0x0B9, 0x0B9, 0x0B9,
        0x21, 0x27, 0x30, 0x7B, 0x0B9, 0x0B9, 0x0B9, 0x0B9,
        0x2D, 0x30, 0x69, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9,
        0x58, 0x7B, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9,
        0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9,
        0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9,
        0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9,
        0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9, 0x0B9,
    ], [
        0x1B, 0x1D, 0x27, 0x4C, 0x0A0, 0x0A0, 0x0A0, 0x0A0,
        0x1D, 0x22, 0x2A, 0x6B, 0x0A0, 0x0A0, 0x0A0, 0x0A0,
        0x27, 0x2A, 0x5B, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0,
        0x4C, 0x6B, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0,
        0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0,
        0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0,
        0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0,
        0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0, 0x0A0,
    ], [
        0x16, 0x18, 0x20, 0x3F, 0x85, 0x85, 0x85, 0x85,
        0x18, 0x1C, 0x22, 0x58, 0x85, 0x85, 0x85, 0x85,
        0x20, 0x22, 0x4B, 0x85, 0x85, 0x85, 0x85, 0x85,
        0x3F, 0x58, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85,
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85,
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85,
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85,
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85,
    ], [
        0x12, 0x13, 0x1A, 0x33, 0x6C, 0x6C, 0x6C, 0x6C,
        0x13, 0x16, 0x1C, 0x48, 0x6C, 0x6C, 0x6C, 0x6C,
        0x1A, 0x1C, 0x3D, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C,
        0x33, 0x48, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C,
        0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C,
        0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C,
        0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C,
        0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C,
    ], [
        0x0D, 0x0E, 0x13, 0x26, 0x50, 0x50, 0x50, 0x50,
        0x0E, 0x11, 0x15, 0x35, 0x50, 0x50, 0x50, 0x50,
        0x13, 0x15, 0x2D, 0x50, 0x50, 0x50, 0x50, 0x50,
        0x26, 0x35, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
        0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
        0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
        0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
        0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    ], [
        9, 0x0A, 0x0D, 0x1A, 0x37, 0x37, 0x37, 0x37,
        0x0A, 0x0B, 0x0E, 0x25, 0x37, 0x37, 0x37, 0x37,
        0x0D, 0x0E, 0x1F, 0x37, 0x37, 0x37, 0x37, 0x37,
        0x1A, 0x25, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37,
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37,
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37,
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37,
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37,
    ], [
        4, 5, 6, 0x0D, 0x1B, 0x1B, 0x1B, 0x1B,
        5, 5, 7, 0x12, 0x1B, 0x1B, 0x1B, 0x1B,
        6, 7, 0x0F, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
        0x0D, 0x12, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
    ], [
        3, 3, 4, 8, 0x12, 0x12, 0x12, 0x12,
        3, 3, 4, 0x0C, 0x12, 0x12, 0x12, 0x12,
        4, 4, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
        8, 0x0C, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
    ], [
        2, 2, 3, 7, 0x0F, 0x0F, 0x0F, 0x0F,
        2, 3, 4, 0x0A, 0x0F, 0x0F, 0x0F, 0x0F,
        3, 4, 8, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
        7, 0x0A, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    ], [
        2, 2, 3, 5, 0x0C, 0x0C, 0x0C, 0x0C,
        2, 2, 3, 8, 0x0C, 0x0C, 0x0C, 0x0C,
        3, 3, 7, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        5, 8, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
    ], [
        1, 1, 2, 4, 9, 9, 9, 9,
        1, 1, 2, 6, 9, 9, 9, 9,
        2, 2, 5, 9, 9, 9, 9, 9,
        4, 6, 9, 9, 9, 9, 9, 9,
        9, 9, 9, 9, 9, 9, 9, 9,
        9, 9, 9, 9, 9, 9, 9, 9,
        9, 9, 9, 9, 9, 9, 9, 9,
        9, 9, 9, 9, 9, 9, 9, 9,
    ], [
        1, 1, 1, 2, 6, 6, 6, 6,
        1, 1, 1, 4, 6, 6, 6, 6,
        1, 1, 3, 6, 6, 6, 6, 6,
        2, 4, 6, 6, 6, 6, 6, 6,
        6, 6, 6, 6, 6, 6, 6, 6,
        6, 6, 6, 6, 6, 6, 6, 6,
        6, 6, 6, 6, 6, 6, 6, 6,
        6, 6, 6, 6, 6, 6, 6, 6,
    ]
];

/*
 Ref.: libjpeg's jddctmgr.c:
    "For float AA&N IDCT method, multipliers are equal to quantization
     coefficients scaled by scalefactor[row]*scalefactor[col], where
       scalefactor[0] = 1
       scalefactor[k] = cos(k*PI/16) * sqrt(2)    for k=1..7
*/
var AAN_IDCT_SCALING_FACTORS = [
    1.0, 1.387039845, 1.306562965, 1.175875602,
    1.0, 0.785694958, 0.541196100, 0.275899379,
];


var YUVTORGB_CR_G_TABLE = new Int32Array(256);
var YUVTORGB_CR_R_TABLE = new Int32Array(256);
var YUVTORGB_CB_G_TABLE = new Int32Array(256);
var YUVTORGB_CB_B_TABLE = new Int32Array(256);
var YUVTORGB_Y_TABLE = new Int32Array(256);
for (var i = 0; i < 256; ++i) {
    YUVTORGB_CR_G_TABLE[i] = (0x688000 - i * 0xD000) >> 16;
    YUVTORGB_CR_R_TABLE[i] = (0xFF340000 + i * 0x19900) >> 16;
    YUVTORGB_CB_G_TABLE[i] = (0x328000 - i * 0x6400) >> 16;
    YUVTORGB_CB_B_TABLE[i] = (0xFEFE8000 + i * 0x20400) >> 16;
    YUVTORGB_Y_TABLE[i] = (0xFFEDE040 + i * 0x129FC) >> 16;
}


var TABLE_CLASS_DC = 0;
var TABLE_CLASS_AC = 1;
var DCTSIZE = 8;
var DCTSIZE2 = DCTSIZE * DCTSIZE;
