<?php

declare(strict_types=1);

/**
 * SPDX-FileCopyrightText: 2021 Nextcloud GmbH and Nextcloud contributors
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */
namespace OCA\TwoFactorBackupCodes\Listener;

use OCA\TwoFactorBackupCodes\Db\BackupCodeMapper;
use OCP\EventDispatcher\Event;
use OCP\EventDispatcher\IEventListener;
use OCP\User\Events\UserDeletedEvent;

/** @template-implements IEventListener<UserDeletedEvent> */
class UserDeleted implements IEventListener {

	/** @var BackupCodeMapper */
	private $backupCodeMapper;

	public function __construct(BackupCodeMapper $backupCodeMapper) {
		$this->backupCodeMapper = $backupCodeMapper;
	}

	public function handle(Event $event): void {
		if (!($event instanceof UserDeletedEvent)) {
			return;
		}

		$this->backupCodeMapper->deleteCodes($event->getUser());
	}
}
