/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public final class ECPrivateKeyWithName
implements ECPrivateKey {
    private final ECPrivateKey realKey;
    private final ASN1ObjectIdentifier curveNameOID;

    public static ECPrivateKeyWithName wrap(ECPrivateKey realKey, ASN1ObjectIdentifier nameOID) {
        return new ECPrivateKeyWithName(realKey, nameOID);
    }

    private ECPrivateKeyWithName(ECPrivateKey realKey, ASN1ObjectIdentifier nameOID) {
        this.realKey = realKey;
        this.curveNameOID = nameOID;
    }

    public ASN1ObjectIdentifier getCurveNameOID() {
        return this.curveNameOID;
    }

    public ECPrivateKey unwrap() {
        return this.realKey;
    }

    @Override
    public BigInteger getS() {
        return this.realKey.getS();
    }

    @Override
    public String getAlgorithm() {
        return this.realKey.getAlgorithm();
    }

    @Override
    public String getFormat() {
        return this.realKey.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return this.realKey.getEncoded();
    }

    @Override
    public ECParameterSpec getParams() {
        return this.realKey.getParams();
    }

    public String toString() {
        return this.realKey.toString();
    }
}

