/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.infinispan.util.function.TriConsumer;
import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.delegate.ClientModelLazyDelegate;
import org.keycloak.models.session.PersistentAuthenticatedClientSessionAdapter;
import org.keycloak.models.session.PersistentUserSessionAdapter;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.changes.MergedUpdate;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.sessions.infinispan.changes.SessionChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionStore;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.utils.RealmModelDelegate;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.models.utils.UserSessionModelDelegate;

public class JpaChangesPerformer<K, V extends SessionEntity>
implements SessionChangesPerformer<K, V> {
    private static final Logger LOG = Logger.getLogger(JpaChangesPerformer.class);
    private final String cacheName;
    private final List<PersistentUpdate> changes = new LinkedList<PersistentUpdate>();
    private final TriConsumer<KeycloakSession, Map.Entry<K, SessionUpdatesList<V>>, MergedUpdate<V>> processor;
    private final ArrayBlockingQueue<PersistentUpdate> batchingQueue;
    private boolean warningShown = false;

    public JpaChangesPerformer(String cacheName, ArrayBlockingQueue<PersistentUpdate> batchingQueue) {
        this.cacheName = cacheName;
        this.batchingQueue = batchingQueue;
        this.processor = this.processor();
    }

    @Override
    public void registerChange(Map.Entry<K, SessionUpdatesList<V>> entry, MergedUpdate<V> merged) {
        this.changes.add(new PersistentUpdate(innerSession -> this.processor.accept(innerSession, (Object)entry, (Object)merged)));
    }

    private TriConsumer<KeycloakSession, Map.Entry<K, SessionUpdatesList<V>>, MergedUpdate<V>> processor() {
        return switch (this.cacheName) {
            case "sessions", "offlineSessions" -> this::processUserSessionUpdate;
            case "clientSessions", "offlineClientSessions" -> this::processClientSessionUpdate;
            default -> throw new IllegalStateException("Unexpected value: " + this.cacheName);
        };
    }

    private void offer(PersistentUpdate update) {
        if (!this.batchingQueue.offer(update)) {
            if (!this.warningShown) {
                this.warningShown = true;
                LOG.warn((Object)"Queue is full, will block");
            }
            try {
                this.batchingQueue.put(update);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void applyChanges() {
        if (!this.changes.isEmpty()) {
            this.changes.forEach(this::offer);
            ArrayList exceptions = new ArrayList();
            CompletableFuture.allOf((CompletableFuture[])this.changes.stream().map(f -> f.future().exceptionally(throwable -> {
                exceptions.add(throwable);
                return null;
            })).toArray(CompletableFuture[]::new)).join();
            if (!exceptions.isEmpty()) {
                RuntimeException ex = new RuntimeException("unable to complete the session updates");
                exceptions.forEach(ex::addSuppressed);
                throw ex;
            }
            this.changes.clear();
        }
    }

    public void applyChangesSynchronously(KeycloakSession session) {
        if (!this.changes.isEmpty()) {
            this.changes.forEach(persistentUpdate -> persistentUpdate.perform(session));
            this.changes.clear();
        }
    }

    private void processClientSessionUpdate(final KeycloakSession innerSession, Map.Entry<K, SessionUpdatesList<V>> entry, MergedUpdate<V> merged) {
        SessionUpdatesList<V> sessionUpdates = entry.getValue();
        SessionEntityWrapper<V> sessionWrapper = sessionUpdates.getEntityWrapper();
        RealmModel realm = sessionUpdates.getRealm();
        UserSessionPersisterProvider userSessionPersister = (UserSessionPersisterProvider)innerSession.getProvider(UserSessionPersisterProvider.class);
        if (merged.getOperation() == SessionUpdateTask.CacheOperation.REMOVE) {
            AuthenticatedClientSessionEntity entity = (AuthenticatedClientSessionEntity)sessionWrapper.getEntity();
            userSessionPersister.removeClientSession(entity.getUserSessionId(), entity.getClientId(), entity.isOffline());
        } else if (merged.getOperation() == SessionUpdateTask.CacheOperation.ADD || merged.getOperation() == SessionUpdateTask.CacheOperation.ADD_IF_ABSENT) {
            final AuthenticatedClientSessionEntity entity = (AuthenticatedClientSessionEntity)sessionWrapper.getEntity();
            userSessionPersister.createClientSession(new AuthenticatedClientSessionModel(){

                public int getStarted() {
                    return entity.getStarted();
                }

                public int getUserSessionStarted() {
                    return entity.getUserSessionStarted();
                }

                public boolean isUserSessionRememberMe() {
                    return entity.isUserSessionRememberMe();
                }

                public String getId() {
                    return entity.getId().toString();
                }

                public int getTimestamp() {
                    return entity.getTimestamp();
                }

                public void setTimestamp(int timestamp) {
                    throw new IllegalStateException("not implemented");
                }

                public void detachFromUserSession() {
                    throw new IllegalStateException("not implemented");
                }

                public UserSessionModel getUserSession() {
                    return new UserSessionModelDelegate(null){

                        public String getId() {
                            return entity.getUserSessionId();
                        }
                    };
                }

                public String getNote(String name) {
                    return entity.getNotes().get(name);
                }

                public void setNote(String name, String value) {
                    throw new IllegalStateException("not implemented");
                }

                public void removeNote(String name) {
                    throw new IllegalStateException("not implemented");
                }

                public Map<String, String> getNotes() {
                    return entity.getNotes();
                }

                public String getRedirectUri() {
                    return entity.getRedirectUri();
                }

                public void setRedirectUri(String uri) {
                    throw new IllegalStateException("not implemented");
                }

                public RealmModel getRealm() {
                    return innerSession.realms().getRealm(entity.getRealmId());
                }

                public ClientModel getClient() {
                    return new ClientModelLazyDelegate(() -> null){

                        public String getId() {
                            return entity.getClientId();
                        }
                    };
                }

                public String getAction() {
                    return entity.getAction();
                }

                public void setAction(String action) {
                    throw new IllegalStateException("not implemented");
                }

                public String getProtocol() {
                    return entity.getAuthMethod();
                }

                public void setProtocol(String method) {
                    throw new IllegalStateException("not implemented");
                }
            }, entity.isOffline());
        } else {
            UserSessionModelDelegate userSession;
            final AuthenticatedClientSessionEntity entity = (AuthenticatedClientSessionEntity)sessionWrapper.getEntity();
            ClientModelLazyDelegate client = new ClientModelLazyDelegate(null){

                public String getId() {
                    return entity.getClientId();
                }
            };
            final PersistentAuthenticatedClientSessionAdapter clientSessionModel = (PersistentAuthenticatedClientSessionAdapter)userSessionPersister.loadClientSession(realm, (ClientModel)client, (UserSessionModel)(userSession = new UserSessionModelDelegate(null){

                public String getId() {
                    return entity.getUserSessionId();
                }
            }), entity.isOffline());
            if (clientSessionModel != null) {
                AuthenticatedClientSessionEntity authenticatedClientSessionEntity = new AuthenticatedClientSessionEntity(entity.getId()){

                    @Override
                    public Map<String, String> getNotes() {
                        return new HashMap<String, String>(){

                            @Override
                            public String get(Object key) {
                                return (String)clientSessionModel.getNotes().get(key);
                            }

                            @Override
                            public String put(String key, String value) {
                                String oldValue = (String)clientSessionModel.getNotes().get(key);
                                clientSessionModel.setNote(key, value);
                                return oldValue;
                            }
                        };
                    }

                    @Override
                    public void setRedirectUri(String redirectUri) {
                        clientSessionModel.setRedirectUri(redirectUri);
                    }

                    @Override
                    public void setTimestamp(int timestamp) {
                        clientSessionModel.setTimestamp(timestamp);
                    }

                    @Override
                    public void setAction(String action) {
                        clientSessionModel.setAction(action);
                    }

                    @Override
                    public void setAuthMethod(String authMethod) {
                        clientSessionModel.setProtocol(authMethod);
                    }

                    @Override
                    public String getAuthMethod() {
                        throw new IllegalStateException("not implemented");
                    }

                    @Override
                    public String getRedirectUri() {
                        return clientSessionModel.getRedirectUri();
                    }

                    @Override
                    public int getTimestamp() {
                        return clientSessionModel.getTimestamp();
                    }

                    @Override
                    public int getUserSessionStarted() {
                        return clientSessionModel.getUserSessionStarted();
                    }

                    @Override
                    public int getStarted() {
                        return clientSessionModel.getStarted();
                    }

                    @Override
                    public boolean isUserSessionRememberMe() {
                        return clientSessionModel.isUserSessionRememberMe();
                    }

                    @Override
                    public String getClientId() {
                        return clientSessionModel.getClient().getClientId();
                    }

                    @Override
                    public void setClientId(String clientId) {
                        throw new IllegalStateException("not implemented");
                    }

                    @Override
                    public String getAction() {
                        return clientSessionModel.getAction();
                    }

                    @Override
                    public void setNotes(Map<String, String> notes) {
                        clientSessionModel.getNotes().keySet().forEach(arg_0 -> ((PersistentAuthenticatedClientSessionAdapter)clientSessionModel).removeNote(arg_0));
                        notes.forEach((k, v) -> clientSessionModel.setNote(k, v));
                    }

                    @Override
                    public UUID getId() {
                        return UUID.fromString(clientSessionModel.getId());
                    }

                    @Override
                    public SessionEntityWrapper mergeRemoteEntityWithLocalEntity(SessionEntityWrapper localEntityWrapper) {
                        throw new IllegalStateException("not implemented");
                    }

                    @Override
                    public String getUserSessionId() {
                        return clientSessionModel.getUserSession().getId();
                    }

                    @Override
                    public void setUserSessionId(String userSessionId) {
                        throw new IllegalStateException("not implemented");
                    }
                };
                sessionUpdates.getUpdateTasks().forEach(vSessionUpdateTask -> {
                    vSessionUpdateTask.runUpdate(authenticatedClientSessionEntity);
                    if (vSessionUpdateTask.getOperation() == SessionUpdateTask.CacheOperation.REMOVE) {
                        userSessionPersister.removeClientSession(entity.getUserSessionId(), entity.getClientId(), entity.isOffline());
                    }
                });
                clientSessionModel.getUpdatedModel();
            }
        }
    }

    private void processUserSessionUpdate(final KeycloakSession innerSession, Map.Entry<K, SessionUpdatesList<V>> entry, MergedUpdate<V> merged) {
        SessionUpdatesList<V> sessionUpdates = entry.getValue();
        SessionEntityWrapper<V> sessionWrapper = sessionUpdates.getEntityWrapper();
        final RealmModel realm = sessionUpdates.getRealm();
        UserSessionPersisterProvider userSessionPersister = (UserSessionPersisterProvider)innerSession.getProvider(UserSessionPersisterProvider.class);
        final UserSessionEntity entity = (UserSessionEntity)sessionWrapper.getEntity();
        if (merged.getOperation() == SessionUpdateTask.CacheOperation.REMOVE) {
            userSessionPersister.removeUserSession(entry.getKey().toString(), entity.isOffline());
        } else if (merged.getOperation() == SessionUpdateTask.CacheOperation.ADD || merged.getOperation() == SessionUpdateTask.CacheOperation.ADD_IF_ABSENT) {
            userSessionPersister.createUserSession(new UserSessionModel(){

                public String getId() {
                    return entity.getId();
                }

                public RealmModel getRealm() {
                    return new RealmModelDelegate(null){

                        public String getId() {
                            return entity.getRealmId();
                        }
                    };
                }

                public String getBrokerSessionId() {
                    return entity.getBrokerSessionId();
                }

                public String getBrokerUserId() {
                    return entity.getBrokerUserId();
                }

                public UserModel getUser() {
                    return new UserModelDelegate(null){

                        public String getId() {
                            return entity.getUser();
                        }
                    };
                }

                public String getLoginUsername() {
                    return entity.getLoginUsername();
                }

                public String getIpAddress() {
                    return entity.getIpAddress();
                }

                public String getAuthMethod() {
                    return entity.getAuthMethod();
                }

                public boolean isRememberMe() {
                    return entity.isRememberMe();
                }

                public int getStarted() {
                    return entity.getStarted();
                }

                public int getLastSessionRefresh() {
                    return entity.getLastSessionRefresh();
                }

                public void setLastSessionRefresh(int seconds) {
                    throw new IllegalStateException("not implemented");
                }

                public boolean isOffline() {
                    return entity.isOffline();
                }

                public Map<String, AuthenticatedClientSessionModel> getAuthenticatedClientSessions() {
                    return Collections.emptyMap();
                }

                public void removeAuthenticatedClientSessions(Collection<String> removedClientUUIDS) {
                    throw new IllegalStateException("not implemented");
                }

                public String getNote(String name) {
                    return entity.getNotes().get(name);
                }

                public void setNote(String name, String value) {
                    throw new IllegalStateException("not implemented");
                }

                public void removeNote(String name) {
                    throw new IllegalStateException("not implemented");
                }

                public Map<String, String> getNotes() {
                    return entity.getNotes();
                }

                public UserSessionModel.State getState() {
                    return entity.getState();
                }

                public void setState(UserSessionModel.State state) {
                    throw new IllegalStateException("not implemented");
                }

                public void restartSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
                    throw new IllegalStateException("not implemented");
                }
            }, entity.isOffline());
        } else {
            final PersistentUserSessionAdapter userSessionModel = (PersistentUserSessionAdapter)userSessionPersister.loadUserSession(realm, entry.getKey().toString(), entity.isOffline());
            if (userSessionModel != null) {
                UserSessionEntity userSessionEntity = new UserSessionEntity(userSessionModel.getId()){

                    @Override
                    public Map<String, String> getNotes() {
                        return new HashMap<String, String>(){

                            @Override
                            public String get(Object key) {
                                return (String)userSessionModel.getNotes().get(key);
                            }

                            @Override
                            public String put(String key, String value) {
                                String oldValue = (String)userSessionModel.getNotes().get(key);
                                userSessionModel.setNote(key, value);
                                return oldValue;
                            }

                            @Override
                            public String remove(Object key) {
                                String oldValue = (String)userSessionModel.getNotes().get(key);
                                userSessionModel.removeNote(key.toString());
                                return oldValue;
                            }

                            @Override
                            public void clear() {
                                userSessionModel.getNotes().clear();
                            }
                        };
                    }

                    @Override
                    public void setLastSessionRefresh(int lastSessionRefresh) {
                        userSessionModel.setLastSessionRefresh(lastSessionRefresh);
                    }

                    @Override
                    public void setState(UserSessionModel.State state) {
                        userSessionModel.setState(state);
                    }

                    @Override
                    public AuthenticatedClientSessionStore getAuthenticatedClientSessions() {
                        return new AuthenticatedClientSessionStore(){

                            @Override
                            public void clear() {
                                userSessionModel.getAuthenticatedClientSessions().clear();
                            }
                        };
                    }

                    @Override
                    public String getRealmId() {
                        return userSessionModel.getRealm().getId();
                    }

                    @Override
                    public void setRealmId(String realmId) {
                        userSessionModel.setRealm(innerSession.realms().getRealm(realmId));
                    }

                    @Override
                    public String getUser() {
                        return userSessionModel.getUser().getId();
                    }

                    @Override
                    public void setUser(String userId) {
                        userSessionModel.setUser(innerSession.users().getUserById(realm, userId));
                    }

                    @Override
                    public String getLoginUsername() {
                        return userSessionModel.getLoginUsername();
                    }

                    @Override
                    public void setLoginUsername(String loginUsername) {
                        userSessionModel.setLoginUsername(loginUsername);
                    }

                    @Override
                    public String getIpAddress() {
                        return userSessionModel.getIpAddress();
                    }

                    @Override
                    public void setIpAddress(String ipAddress) {
                        userSessionModel.setIpAddress(ipAddress);
                    }

                    @Override
                    public String getAuthMethod() {
                        return userSessionModel.getAuthMethod();
                    }

                    @Override
                    public void setAuthMethod(String authMethod) {
                        userSessionModel.setAuthMethod(authMethod);
                    }

                    @Override
                    public boolean isRememberMe() {
                        return userSessionModel.isRememberMe();
                    }

                    @Override
                    public void setRememberMe(boolean rememberMe) {
                        userSessionModel.setRememberMe(rememberMe);
                    }

                    @Override
                    public int getStarted() {
                        return userSessionModel.getStarted();
                    }

                    @Override
                    public void setStarted(int started) {
                        userSessionModel.setStarted(started);
                    }

                    @Override
                    public int getLastSessionRefresh() {
                        return userSessionModel.getLastSessionRefresh();
                    }

                    @Override
                    public void setNotes(Map<String, String> notes) {
                        userSessionModel.getNotes().keySet().forEach(arg_0 -> ((PersistentUserSessionAdapter)userSessionModel).removeNote(arg_0));
                        notes.forEach((k, v) -> userSessionModel.setNote(k, v));
                    }

                    @Override
                    public void setAuthenticatedClientSessions(AuthenticatedClientSessionStore authenticatedClientSessions) {
                        throw new IllegalStateException("not supported");
                    }

                    @Override
                    public UserSessionModel.State getState() {
                        return userSessionModel.getState();
                    }

                    @Override
                    public String getBrokerSessionId() {
                        return userSessionModel.getBrokerSessionId();
                    }

                    @Override
                    public void setBrokerSessionId(String brokerSessionId) {
                        userSessionModel.setBrokerSessionId(brokerSessionId);
                    }

                    @Override
                    public String getBrokerUserId() {
                        return userSessionModel.getBrokerUserId();
                    }

                    @Override
                    public void setBrokerUserId(String brokerUserId) {
                        userSessionModel.setBrokerUserId(brokerUserId);
                    }

                    @Override
                    public SessionEntityWrapper mergeRemoteEntityWithLocalEntity(SessionEntityWrapper localEntityWrapper) {
                        throw new IllegalStateException("not supported");
                    }
                };
                sessionUpdates.getUpdateTasks().forEach(vSessionUpdateTask -> {
                    vSessionUpdateTask.runUpdate(userSessionEntity);
                    if (vSessionUpdateTask.getOperation() == SessionUpdateTask.CacheOperation.REMOVE) {
                        userSessionPersister.removeUserSession(entry.getKey().toString(), entity.isOffline());
                    }
                });
                userSessionModel.getUpdatedModel();
            }
        }
    }
}

