/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.jboss.logging.Logger;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.ViewExecutor;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.Nullable;
import org.wildfly.common.cpu.ProcessorInfo;
import org.wildfly.common.lock.Locks;

final class EnhancedViewExecutor
extends ViewExecutor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.threads.view-executor");
    private static final long stateOffset;
    private static final int QUEUE_FAILURE_LOG_INTERVAL;
    private static final int MAX_QUEUE_SPINS;
    private static final long SHUTDOWN_MASK = Long.MIN_VALUE;
    private static final long ACTIVE_COUNT_MASK = Integer.MAX_VALUE;
    private static final int QUEUED_SIZE_OFFSET = 31;
    private static final long QUEUED_SIZE_MASK = 4611686016279904256L;
    private final Executor delegate;
    private final int maxCount;
    private final int queueLimit;
    @Nullable
    private final Lock executeLock;
    private final Object shutdownLock = new Object();
    private final Set<EnhancedViewExecutorRunnable> activeRunnables = ConcurrentHashMap.newKeySet();
    private final Queue<EnhancedViewExecutorRunnable> queue = new ConcurrentLinkedQueue<EnhancedViewExecutorRunnable>();
    private volatile long state;
    private volatile boolean interrupted = false;

    EnhancedViewExecutor(Executor delegate, int maxCount, int queueLimit, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.delegate = (Executor)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        this.maxCount = maxCount;
        this.queueLimit = queueLimit;
        this.executeLock = queueLimit == 0 ? null : Locks.reentrantLock();
        this.setExceptionHandler(uncaughtExceptionHandler);
    }

    @Override
    public void shutdown(boolean interrupt) {
        long stateSnapshot;
        while (!EnhancedViewExecutor.isShutdown(stateSnapshot = this.state)) {
            long newState = stateSnapshot | Long.MIN_VALUE;
            if (!this.compareAndSwapState(stateSnapshot, newState)) continue;
            this.notifyWaitersIfTerminated(newState);
            break;
        }
        if (interrupt) {
            this.interrupted = true;
            this.activeRunnables.forEach(EnhancedViewExecutorRunnable::interrupt);
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        int queuedElementsToRemove;
        block3: {
            long newState;
            long stateSnapshot;
            do {
                stateSnapshot = this.state;
                queuedElementsToRemove = EnhancedViewExecutor.getQueueSize(stateSnapshot);
                if (EnhancedViewExecutor.isShutdown(stateSnapshot) && queuedElementsToRemove == 0) break block3;
            } while (!this.compareAndSwapState(stateSnapshot, newState = (stateSnapshot | Long.MIN_VALUE) & 0xC00000007FFFFFFFL));
            this.notifyWaitersIfTerminated(newState);
        }
        this.interrupted = true;
        this.activeRunnables.forEach(EnhancedViewExecutorRunnable::interrupt);
        if (queuedElementsToRemove > 0) {
            ArrayList<Runnable> neverCommencedExecution = new ArrayList<Runnable>(queuedElementsToRemove);
            for (int i = 0; i < queuedElementsToRemove; ++i) {
                neverCommencedExecution.add(this.blockingTake().delegate);
            }
            return neverCommencedExecution;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return EnhancedViewExecutor.isShutdown(this.state);
    }

    private static boolean isShutdown(long state) {
        return (state & Long.MIN_VALUE) != 0L;
    }

    @Override
    public boolean isTerminated() {
        return EnhancedViewExecutor.isTerminated(this.state);
    }

    private static boolean isTerminated(long state) {
        return state == Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitersIfTerminated(long stateSnapshot) {
        if (EnhancedViewExecutor.isTerminated(stateSnapshot)) {
            Object object = this.shutdownLock;
            synchronized (object) {
                this.shutdownLock.notifyAll();
            }
            assert (this.queue.isEmpty());
            this.runTermination();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long remainingNanos = unit.toNanos(timeout);
        long now = System.nanoTime();
        Object object = this.shutdownLock;
        synchronized (object) {
            while (!this.isTerminated()) {
                long remainingMillis = TimeUnit.MILLISECONDS.convert(remainingNanos -= Math.max(-now + (now = System.nanoTime()), 0L), TimeUnit.NANOSECONDS);
                if (remainingMillis <= 0L) {
                    return false;
                }
                this.shutdownLock.wait(remainingMillis);
            }
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Runnable task) {
        int currentQueueSize;
        long updatedQueueSize;
        long stateSnapshot;
        Assert.checkNotNullParam((String)"task", (Object)task);
        EnhancedViewExecutorRunnable decoratedTask = new EnhancedViewExecutorRunnable(task, JBossExecutors.getContextClassLoader(Thread.currentThread()));
        int maxCount = this.maxCount;
        int queueLimit = this.queueLimit;
        Lock executeLock = null;
        do {
            int activeCount;
            block13: {
                while (true) {
                    if (EnhancedViewExecutor.isShutdown(stateSnapshot = this.state)) {
                        throw new RejectedExecutionException("Executor has been shut down");
                    }
                    activeCount = EnhancedViewExecutor.getActiveCount(stateSnapshot);
                    currentQueueSize = EnhancedViewExecutor.getQueueSize(stateSnapshot);
                    if (queueLimit != 0 && executeLock == null && currentQueueSize == 0 && activeCount >= maxCount - 1) {
                        executeLock = this.executeLock;
                        executeLock.lock();
                        continue;
                    }
                    if (activeCount >= maxCount) break block13;
                    assert (EnhancedViewExecutor.getQueueSize(stateSnapshot) == 0);
                    long updatedActiveCount = activeCount + 1;
                    if (this.compareAndSwapState(stateSnapshot, updatedActiveCount | stateSnapshot & Integer.MIN_VALUE)) break;
                }
                try {
                    this.delegate.execute(decoratedTask);
                    return;
                }
                catch (Throwable t) {
                    this.taskComplete(false);
                    throw t;
                }
            }
            if (currentQueueSize >= queueLimit) throw new RejectedExecutionException("No executor queue space remaining");
            if ($assertionsDisabled || activeCount == maxCount) continue;
            throw new AssertionError();
        } while (!this.compareAndSwapState(stateSnapshot, (updatedQueueSize = (long)(currentQueueSize + 1)) << 31 | stateSnapshot & 0xC00000007FFFFFFFL));
        this.enqueue(decoratedTask);
        return;
        finally {
            if (executeLock != null) {
                executeLock.unlock();
            }
        }
    }

    private void enqueue(EnhancedViewExecutorRunnable task) {
        int failures = 0;
        while (true) {
            try {
                if (this.queue.offer(task)) {
                    return;
                }
                throw new RejectedExecutionException("Task was rejected by the queue. This should never happen.");
            }
            catch (Throwable t) {
                if (this.decrementQueueSize()) {
                    throw t;
                }
                if (failures == 0) {
                    log.error((Object)"Failed to submit a task to the queue. This should never happen.", t);
                }
                if (++failures >= QUEUE_FAILURE_LOG_INTERVAL) {
                    failures = 0;
                }
                Thread.yield();
                continue;
            }
            break;
        }
    }

    private boolean decrementQueueSize() {
        int queueSize;
        long newQueueSize;
        long newState;
        long snapshot;
        do {
            if ((queueSize = EnhancedViewExecutor.getQueueSize(snapshot = this.state)) != 0) continue;
            return false;
        } while (!this.compareAndSwapState(snapshot, newState = snapshot & 0xC00000007FFFFFFFL | (newQueueSize = (long)(queueSize - 1)) << 31));
        this.notifyWaitersIfTerminated(newState);
        return true;
    }

    private EnhancedViewExecutorRunnable blockingTake() {
        int spins = 0;
        int attempts = 0;
        while (true) {
            try {
                while (true) {
                    EnhancedViewExecutorRunnable result;
                    if ((result = this.queue.poll()) != null) {
                        return result;
                    }
                    if (spins < MAX_QUEUE_SPINS) {
                        ++spins;
                        Thread.onSpinWait();
                        continue;
                    }
                    Thread.yield();
                }
            }
            catch (Throwable t) {
                if (attempts == 0) {
                    log.error((Object)"Failed to read from the queue. This should never happen.", t);
                }
                if (++attempts >= QUEUE_FAILURE_LOG_INTERVAL) {
                    attempts = 0;
                }
                Thread.yield();
                continue;
            }
            break;
        }
    }

    private EnhancedViewExecutorRunnable taskComplete(boolean allowQueuePolling) {
        long newState;
        while (true) {
            long stateSnapshot;
            int queueSize;
            if ((queueSize = EnhancedViewExecutor.getQueueSize(stateSnapshot = this.state)) > 0 && allowQueuePolling) {
                long updatedQueueSize = queueSize - 1;
                if (!this.compareAndSwapState(stateSnapshot, updatedQueueSize << 31 | stateSnapshot & 0xC00000007FFFFFFFL)) continue;
                EnhancedViewExecutorRunnable task = this.blockingTake();
                try {
                    this.delegate.execute(task);
                    return null;
                }
                catch (Throwable t) {
                    return task;
                }
            }
            newState = (long)(EnhancedViewExecutor.getActiveCount(stateSnapshot) - 1) | stateSnapshot & Integer.MIN_VALUE;
            if (this.compareAndSwapState(stateSnapshot, newState)) break;
        }
        this.notifyWaitersIfTerminated(newState);
        return null;
    }

    private static int getActiveCount(long state) {
        return (int)(state & Integer.MAX_VALUE);
    }

    private static int getQueueSize(long state) {
        return (int)((state & 0x3FFFFFFF80000000L) >> 31);
    }

    private boolean compareAndSwapState(long expected, long update) {
        return JBossExecutors.unsafe.compareAndSwapLong(this, stateOffset, expected, update);
    }

    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler handler = this.getExceptionHandler();
        if (handler != null) {
            return handler;
        }
        Thread.UncaughtExceptionHandler threadHandler = Thread.currentThread().getUncaughtExceptionHandler();
        return threadHandler != null ? threadHandler : JBossExecutors.loggingExceptionHandler();
    }

    public String toString() {
        long snapshot = this.state;
        int activeTasks = EnhancedViewExecutor.getActiveCount(snapshot);
        int queueSize = EnhancedViewExecutor.getQueueSize(snapshot);
        boolean shutdown = EnhancedViewExecutor.isShutdown(snapshot);
        boolean terminated = EnhancedViewExecutor.isTerminated(snapshot);
        return "EnhancedViewExecutor{delegate=" + String.valueOf(this.delegate) + ", active=" + activeTasks + ", queued=" + queueSize + ", shutdown=" + shutdown + ", terminated=" + terminated + "}";
    }

    static {
        try {
            stateOffset = JBossExecutors.unsafe.objectFieldOffset(EnhancedViewExecutor.class.getDeclaredField("state"));
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
        QUEUE_FAILURE_LOG_INTERVAL = EnhancedViewExecutor.readIntPropertyPrefixed("queue.failure.log.interval", 1000000);
        MAX_QUEUE_SPINS = EnhancedViewExecutor.readIntPropertyPrefixed("queue.poll.spins", ProcessorInfo.availableProcessors() == 1 ? 0 : 128);
    }

    private final class EnhancedViewExecutorRunnable
    implements Runnable {
        private Runnable delegate;
        private ClassLoader contextClassLoader;
        @Nullable
        private volatile Thread thread;

        EnhancedViewExecutorRunnable(Runnable delegate, ClassLoader contextClassLoader) {
            this.delegate = delegate;
            this.contextClassLoader = contextClassLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EnhancedViewExecutorRunnable task = this;
            while (task != null) {
                Runnable runnable;
                Thread currentThread = Thread.currentThread();
                Set<EnhancedViewExecutorRunnable> runnables = EnhancedViewExecutor.this.activeRunnables;
                task.thread = currentThread;
                try {
                    runnables.add(task);
                    if (EnhancedViewExecutor.this.interrupted) {
                        currentThread.interrupt();
                    }
                    runnable = task.delegate;
                    ClassLoader loader = task.contextClassLoader;
                    task.delegate = null;
                    task.contextClassLoader = null;
                    ClassLoader old = JBossExecutors.getAndSetContextClassLoader(currentThread, loader);
                    try {
                        runnable.run();
                    }
                    finally {
                        JBossExecutors.setContextClassLoader(currentThread, old);
                    }
                }
                catch (Throwable t) {
                    EnhancedViewExecutor.this.uncaughtExceptionHandler().uncaughtException(task.thread, t);
                }
                finally {
                    runnables.remove(task);
                    runnable = task;
                    synchronized (runnable) {
                        task.thread = null;
                    }
                    task = EnhancedViewExecutor.this.taskComplete(true);
                }
            }
        }

        synchronized void interrupt() {
            Thread taskThread = this.thread;
            if (taskThread != null) {
                taskThread.interrupt();
            }
        }

        public String toString() {
            return "EnhancedViewExecutorRunnable{" + String.valueOf(this.delegate) + "}";
        }
    }
}

