/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.Segment;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkotlinx/io/InputStreamSource;", "Lkotlinx/io/RawSource;", "input", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "readAtMostTo", "", "sink", "Lkotlinx/io/Buffer;", "byteCount", "close", "", "toString", "", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nJvmCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCore.kt\nkotlinx/io/InputStreamSource\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n52#2:117\n53#2:119\n109#2:120\n1#3:118\n*S KotlinDebug\n*F\n+ 1 JvmCore.kt\nkotlinx/io/InputStreamSource\n*L\n82#1:117\n82#1:119\n85#1:120\n82#1:118\n*E\n"})
class InputStreamSource
implements RawSource {
    @NotNull
    private final InputStream input;

    public InputStreamSource(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
    }

    @Override
    public long readAtMostTo(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (byteCount == 0L) {
            return 0L;
        }
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean $i$a$-require-_UtilKt$checkByteCount$1$iv22 = false;
            String $i$a$-require-_UtilKt$checkByteCount$1$iv22 = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException($i$a$-require-_UtilKt$checkByteCount$1$iv22.toString());
        }
        try {
            Segment tail = sink.writableSegment(1);
            int b$iv = 8192 - tail.getLimit();
            boolean $i$f$minOf = false;
            int maxToCopy = (int)Math.min(byteCount, (long)b$iv);
            int bytesRead = this.input.read(tail.data, tail.getLimit(), maxToCopy);
            if (bytesRead == -1) {
                if (tail.getPos() == tail.getLimit()) {
                    sink.recycleTail();
                }
                return -1L;
            }
            tail.setLimit(tail.getLimit() + bytesRead);
            sink.setSizeMut(sink.getSizeMut() + (long)bytesRead);
            return bytesRead;
        }
        catch (AssertionError e) {
            if (JvmCoreKt.isAndroidGetsocknameError(e)) {
                throw new IOException((Throwable)((Object)e));
            }
            throw e;
        }
    }

    @Override
    public void close() {
        this.input.close();
    }

    @NotNull
    public String toString() {
        return "RawSource(" + this.input + ')';
    }
}

