/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.compiled;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClsStubBuilder;
import org.jetbrains.annotations.NotNull;

@Service
public final class ClassFileDecompilers {
    public final ExtensionPointName<Decompiler> EP_NAME = new ExtensionPointName("com.intellij.psi.classFileDecompiler");

    public static ClassFileDecompilers getInstance() {
        return (ClassFileDecompilers)ApplicationManager.getApplication().getService(ClassFileDecompilers.class);
    }

    private ClassFileDecompilers() {
        Runnable runnable = () -> BinaryFileTypeDecompilers.getInstance().notifyDecompilerSetChange();
        this.EP_NAME.addChangeListener(runnable, null);
    }

    public <D extends Decompiler> D find(@NotNull VirtualFile file, @NotNull Class<D> decompilerClass) {
        if (file == null) {
            ClassFileDecompilers.$$$reportNull$$$0(0);
        }
        if (decompilerClass == null) {
            ClassFileDecompilers.$$$reportNull$$$0(1);
        }
        return (D)((Decompiler)this.EP_NAME.findFirstSafe(d -> decompilerClass.isInstance(d) && d.accepts(file)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "decompilerClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/compiled/ClassFileDecompilers";
        objectArray[2] = "find";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Decompiler {
        public boolean accepts(@NotNull VirtualFile var1);
    }

    public static abstract class Full
    implements Decompiler {
        @NotNull
        public abstract ClsStubBuilder getStubBuilder();

        @NotNull
        public abstract FileViewProvider createFileViewProvider(@NotNull VirtualFile var1, @NotNull PsiManager var2, boolean var3);
    }

    public static abstract class Light
    implements Decompiler {
        @NotNull
        public abstract CharSequence getText(@NotNull VirtualFile var1) throws CannotDecompileException;

        public static class CannotDecompileException
        extends RuntimeException {
            public CannotDecompileException(String message, Throwable cause) {
                super(message, cause);
            }
        }
    }
}

