/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.AbstractBundle;
import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.BasicDeclarationParser;
import com.intellij.lang.java.parser.BasicJavaParser;
import com.intellij.lang.java.parser.BasicJavaParserUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicFileParser {
    protected final TokenSet IMPORT_LIST_STOPPER_SET;
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final TokenSet IMPLICIT_CLASS_INDICATORS;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public BasicFileParser(@NotNull BasicJavaParser javaParser) {
        if (javaParser == null) {
            BasicFileParser.$$$reportNull$$$0(0);
        }
        this.myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
        this.IMPORT_LIST_STOPPER_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{BasicElementTypes.BASIC_MODIFIER_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.CLASS_KEYWORD, JavaTokenType.INTERFACE_KEYWORD, JavaTokenType.ENUM_KEYWORD, JavaTokenType.AT})});
        this.IMPLICIT_CLASS_INDICATORS = TokenSet.create((IElementType[])new IElementType[]{this.myJavaElementTypeContainer.METHOD, this.myJavaElementTypeContainer.FIELD, this.myJavaElementTypeContainer.CLASS_INITIALIZER});
    }

    public void parse(@NotNull PsiBuilder builder) {
        if (builder == null) {
            BasicFileParser.$$$reportNull$$$0(1);
        }
        this.parseFile(builder, this::stopImportListParsing, (AbstractBundle)JavaPsiBundle.INSTANCE, "expected.class.or.interface");
    }

    public void parseFile(@NotNull PsiBuilder builder, @NotNull Predicate<? super PsiBuilder> importListStopper, @NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (builder == null) {
            BasicFileParser.$$$reportNull$$$0(2);
        }
        if (importListStopper == null) {
            BasicFileParser.$$$reportNull$$$0(3);
        }
        if (bundle == null) {
            BasicFileParser.$$$reportNull$$$0(4);
        }
        if (errorMessageKey == null) {
            BasicFileParser.$$$reportNull$$$0(5);
        }
        this.parsePackageStatement(builder);
        Pair<PsiBuilder.Marker, Boolean> impListInfo = this.parseImportList(builder, importListStopper);
        Boolean firstDeclarationOk = null;
        PsiBuilder.Marker firstDeclaration = null;
        PsiBuilder.Marker invalidElements = null;
        boolean isImplicitClass = false;
        while (!builder.eof()) {
            if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration = this.myParser.getModuleParser().parse(builder);
            if (declaration == null) {
                declaration = this.parseInitial(builder);
            }
            if (declaration != null) {
                if (invalidElements != null) {
                    invalidElements.errorBefore(BasicFileParser.error(bundle, errorMessageKey), declaration);
                    invalidElements = null;
                }
                if (firstDeclarationOk == null) {
                    firstDeclarationOk = BasicJavaParserUtil.exprType(declaration) != this.myJavaElementTypeContainer.MODIFIER_LIST;
                }
                if (firstDeclaration == null) {
                    firstDeclaration = declaration;
                }
                if (isImplicitClass || !this.IMPLICIT_CLASS_INDICATORS.contains(BasicJavaParserUtil.exprType(declaration))) continue;
                isImplicitClass = true;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            builder.advanceLexer();
            if (firstDeclarationOk != null) continue;
            firstDeclarationOk = false;
        }
        if (invalidElements != null) {
            invalidElements.error(BasicFileParser.error(bundle, errorMessageKey));
        }
        if (((Boolean)impListInfo.second).booleanValue() && firstDeclarationOk == Boolean.TRUE) {
            ((PsiBuilder.Marker)impListInfo.first).setCustomEdgeTokenBinders(this.myWhiteSpaceAndCommentSetHolder.getPrecedingCommentBinder(), null);
            firstDeclaration.setCustomEdgeTokenBinders(this.myWhiteSpaceAndCommentSetHolder.getSpecialPrecedingCommentBinder(), null);
        }
        if (isImplicitClass) {
            PsiBuilder.Marker beforeFirst = firstDeclaration.precede();
            BasicJavaParserUtil.done(beforeFirst, this.myJavaElementTypeContainer.IMPLICIT_CLASS, this.myWhiteSpaceAndCommentSetHolder);
        }
    }

    private boolean stopImportListParsing(PsiBuilder b) {
        String text;
        IElementType type = b.getTokenType();
        if (this.IMPORT_LIST_STOPPER_SET.contains(type) || BasicDeclarationParser.isRecordToken(b, type)) {
            return true;
        }
        return type == JavaTokenType.IDENTIFIER && ("open".equals(text = b.getTokenText()) || "module".equals(text));
    }

    @Nullable
    protected PsiBuilder.Marker parseInitial(PsiBuilder builder) {
        return this.myParser.getDeclarationParser().parse(builder, BasicDeclarationParser.BaseContext.FILE);
    }

    private void parsePackageStatement(PsiBuilder builder) {
        PsiBuilder.Marker ref;
        PsiBuilder.Marker statement = builder.mark();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.PACKAGE_KEYWORD)) {
            PsiBuilder.Marker modList = builder.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            BasicJavaParserUtil.done(modList, this.myJavaElementTypeContainer.MODIFIER_LIST, this.myWhiteSpaceAndCommentSetHolder);
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.PACKAGE_KEYWORD)) {
                statement.rollbackTo();
                return;
            }
        }
        if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false)) == null) {
            statement.error(JavaPsiBundle.message("expected.class.or.interface", new Object[0]));
            return;
        }
        BasicJavaParserUtil.semicolon(builder);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.PACKAGE_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
    }

    @NotNull
    protected Pair<PsiBuilder.Marker, Boolean> parseImportList(PsiBuilder builder, Predicate<? super PsiBuilder> stopper) {
        PsiBuilder.Marker list = builder.mark();
        boolean isEmpty = true;
        PsiBuilder.Marker invalidElements = null;
        while (!builder.eof() && !stopper.test((PsiBuilder)builder)) {
            if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker statement = this.parseImportStatement(builder);
            if (statement != null) {
                isEmpty = false;
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), statement);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.rollbackTo();
        }
        if (isEmpty) {
            PsiBuilder.Marker precede = list.precede();
            list.rollbackTo();
            list = precede;
        }
        BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.IMPORT_LIST, this.myWhiteSpaceAndCommentSetHolder);
        Pair pair = Pair.create((Object)list, (Object)isEmpty);
        if (pair == null) {
            BasicFileParser.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @Nullable
    protected PsiBuilder.Marker parseImportStatement(PsiBuilder builder) {
        boolean isModule;
        if (builder.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
            return null;
        }
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        String identifierText = builder.getTokenText();
        IElementType type = this.getImportType(builder);
        boolean isStatic = type == this.myJavaElementTypeContainer.IMPORT_STATIC_STATEMENT;
        boolean bl = isModule = type == this.myJavaElementTypeContainer.IMPORT_MODULE_STATEMENT;
        boolean isOk = isModule ? this.myParser.getModuleParser().parseName(builder) != null : this.myParser.getReferenceParser().parseImportCodeReference(builder, isStatic);
        if (isOk && !isModule && !isStatic && builder.getTokenType() != JavaTokenType.SEMICOLON && "module".equals(identifierText)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier.or.semicolon", new Object[0]));
        } else if (isOk) {
            BasicJavaParserUtil.semicolon(builder);
        }
        BasicJavaParserUtil.done(statement, type, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private IElementType getImportType(@NotNull PsiBuilder builder) {
        IElementType type;
        if (builder == null) {
            BasicFileParser.$$$reportNull$$$0(7);
        }
        if ((type = builder.getTokenType()) == JavaTokenType.STATIC_KEYWORD) {
            builder.advanceLexer();
            IElementType iElementType = this.myJavaElementTypeContainer.IMPORT_STATIC_STATEMENT;
            if (iElementType == null) {
                BasicFileParser.$$$reportNull$$$0(8);
            }
            return iElementType;
        }
        if (type == JavaTokenType.IDENTIFIER && "module".equals(builder.getTokenText()) && builder.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            builder.remapCurrentToken(JavaTokenType.MODULE_KEYWORD);
            builder.advanceLexer();
            IElementType iElementType = this.myJavaElementTypeContainer.IMPORT_MODULE_STATEMENT;
            if (iElementType == null) {
                BasicFileParser.$$$reportNull$$$0(9);
            }
            return iElementType;
        }
        IElementType iElementType = this.myJavaElementTypeContainer.IMPORT_STATEMENT;
        if (iElementType == null) {
            BasicFileParser.$$$reportNull$$$0(10);
        }
        return iElementType;
    }

    @NotNull
    @NlsContexts.ParsingError
    private static String error(@NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (bundle == null) {
            BasicFileParser.$$$reportNull$$$0(11);
        }
        if (errorMessageKey == null) {
            BasicFileParser.$$$reportNull$$$0(12);
        }
        String string = bundle.getMessage(errorMessageKey, new Object[0]);
        if (string == null) {
            BasicFileParser.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importListStopper";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessageKey";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/BasicFileParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/BasicFileParser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseImportList";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImportType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

