/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.AttachChunkResult;
import com.intellij.indexing.shared.platform.impl.ChunkManagerKt;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndexExtension;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunk;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.indexing.IndexedFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eR*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/indexing/shared/platform/impl/ChunkManager;", "", "<init>", "()V", "myChunkEnumerators", "Ljava/util/HashMap;", "", "Lcom/intellij/indexing/shared/platform/impl/SharedIndexChunk;", "Lkotlin/collections/HashMap;", "tryEnumerateContentHash", "", "fileContent", "Lcom/intellij/util/indexing/IndexedFile;", "getOpenChunkIds", "", "attachChunk", "", "chunkId", "chunkRootPath", "Ljava/nio/file/Path;", "indexAttachChunkResult", "Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;", "attachProjectToChunk", "project", "Lcom/intellij/openapi/project/Project;", "getIndexAttachResult", "isProjectAttachedToChunk", "", "disposeChunks", "", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nChunkManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkManager.kt\ncom/intellij/indexing/shared/platform/impl/ChunkManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1863#2,2:150\n*S KotlinDebug\n*F\n+ 1 ChunkManager.kt\ncom/intellij/indexing/shared/platform/impl/ChunkManager\n*L\n76#1:150,2\n*E\n"})
public final class ChunkManager {
    @NotNull
    private final HashMap<Integer, SharedIndexChunk> myChunkEnumerators = new HashMap();

    public final long tryEnumerateContentHash(@NotNull IndexedFile fileContent) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        for (Map.Entry entry : ((Map)this.myChunkEnumerators).entrySet()) {
            int internalHashId;
            int chunkId = ((Number)entry.getKey()).intValue();
            SharedIndexChunk chunk = (SharedIndexChunk)entry.getValue();
            if (!chunk.getAttachedProjects().contains(fileContent.getProject()) || (internalHashId = chunk.tryEnumerate(fileContent)) == 0) continue;
            return FileContentHashIndexExtension.getHashId(internalHashId, chunkId);
        }
        return FileContentHashIndexExtension.NULL_HASH_ID;
    }

    @NotNull
    public final Set<Integer> getOpenChunkIds() {
        Set<Integer> set = this.myChunkEnumerators.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    public final void attachChunk(int chunkId, @NotNull Path chunkRootPath, @NotNull AttachChunkResult indexAttachChunkResult) {
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        Intrinsics.checkNotNullParameter((Object)indexAttachChunkResult, (String)"indexAttachChunkResult");
        Integer n = chunkId;
        ((Map)this.myChunkEnumerators).put(n, new SharedIndexChunk(chunkRootPath, indexAttachChunkResult));
    }

    public final void attachProjectToChunk(int chunkId, @NotNull Project project) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            SharedIndexChunk sharedIndexChunk = this.myChunkEnumerators.get(chunkId);
            if (sharedIndexChunk == null) break block0;
            sharedIndexChunk.attachProject(project);
        }
    }

    @Nullable
    public final AttachChunkResult getIndexAttachResult(int chunkId) {
        SharedIndexChunk sharedIndexChunk = this.myChunkEnumerators.get(chunkId);
        return sharedIndexChunk != null ? sharedIndexChunk.getIndexAttachChunkResult() : null;
    }

    public final boolean isProjectAttachedToChunk(int chunkId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = this.myChunkEnumerators.get(chunkId);
        return object != null && (object = ((SharedIndexChunk)object).getAttachedProjects()) != null ? ((HashSet)object).contains(project) : false;
    }

    @NotNull
    public final List<Integer> disposeChunks(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList closedChunkIds = new ArrayList();
        for (Map.Entry entry : ((Map)this.myChunkEnumerators).entrySet()) {
            int chunkId = ((Number)entry.getKey()).intValue();
            SharedIndexChunk enumerator = (SharedIndexChunk)entry.getValue();
            enumerator.detachProject(project);
            if (!enumerator.getAttachedProjects().isEmpty()) continue;
            try {
                Disposer.dispose((Disposable)enumerator);
            }
            catch (Exception e) {
                ChunkManagerKt.access$getLOG$p().info((Throwable)e);
            }
            Integer n = chunkId;
            ((Collection)closedChunkIds).add(n);
        }
        Iterable $this$forEach$iv = closedChunkIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.myChunkEnumerators.remove(it);
        }
        return closedChunkIds;
    }

    @NotNull
    public final Set<Integer> disposeChunks() {
        Iterator<SharedIndexChunk> iterator = this.myChunkEnumerators.values().iterator();
        while (iterator.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            try {
                SharedIndexChunk enumerator;
                Disposer.dispose((Disposable)enumerator);
            }
            catch (Exception e) {
                ChunkManagerKt.access$getLOG$p().info((Throwable)e);
            }
        }
        Set<Integer> set = this.myChunkEnumerators.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        HashSet chunkIds = CollectionsKt.toHashSet((Iterable)set);
        this.myChunkEnumerators.clear();
        return chunkIds;
    }
}

