/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.bucketing;

import com.intellij.TestCaseLoader;
import com.intellij.testFramework.bucketing.BucketingScheme;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CyclicCounterBucketingScheme
implements BucketingScheme {
    private final AtomicInteger myCyclicCounter = new AtomicInteger(0);
    private final HashMap<String, Integer> myBuckets = new HashMap();
    private final int myBucketsCount;
    private final int myCurrentBucketIndex;

    public CyclicCounterBucketingScheme() {
        this(TestCaseLoader.TEST_RUNNERS_COUNT, TestCaseLoader.TEST_RUNNER_INDEX);
    }

    CyclicCounterBucketingScheme(int totalBucketsCount) {
        this.myBucketsCount = totalBucketsCount;
        this.myCurrentBucketIndex = TestCaseLoader.TEST_RUNNER_INDEX;
    }

    CyclicCounterBucketingScheme(int totalBucketsCount, int currentBucketIndex) {
        this.myBucketsCount = totalBucketsCount;
        this.myCurrentBucketIndex = currentBucketIndex;
    }

    @Override
    public boolean matchesCurrentBucket(@NotNull String testIdentifier) {
        if (testIdentifier == null) {
            CyclicCounterBucketingScheme.$$$reportNull$$$0(0);
        }
        return this.getBucketNumber(testIdentifier, this.myCurrentBucketIndex) == this.myCurrentBucketIndex;
    }

    public int getBucketNumber(@NotNull String testIdentifier, int currentBucketIndex) {
        Integer value2;
        if (testIdentifier == null) {
            CyclicCounterBucketingScheme.$$$reportNull$$$0(1);
        }
        if ((value2 = this.myBuckets.get(testIdentifier)) != null) {
            if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
                System.out.printf("Fair bucket match: test identifier `%s` (already sieved to buckets), test index: %d, runner index/count: %d of %d, is matching bucket: %s%n", testIdentifier, value2, currentBucketIndex, this.myBucketsCount, value2 == currentBucketIndex);
            }
            return value2;
        }
        this.myBuckets.put(testIdentifier, this.myCyclicCounter.getAndIncrement() % this.myBucketsCount);
        value2 = this.myBuckets.get(testIdentifier);
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.printf("Fair bucket match: test identifier `%s`, test index: %d, runner index/count: %d of %d, is matching bucket: %s%n", testIdentifier, value2, currentBucketIndex, this.myBucketsCount, value2 == currentBucketIndex);
        }
        return value2;
    }

    @Override
    public void initialize() {
        if (!this.myBuckets.isEmpty()) {
            return;
        }
        System.out.println("Fair bucketing initialization started ...");
        long start = System.nanoTime();
        List<Class<?>> testCaseClasses = TestCaseLoader.loadClassesForWarmup();
        Collections.shuffle(testCaseClasses, new Random(TestCaseLoader.TEST_RUNNERS_COUNT));
        testCaseClasses.forEach(testCaseClass -> this.getBucketNumber(testCaseClass.getName(), TestCaseLoader.TEST_RUNNER_INDEX));
        long durationNs = System.nanoTime() - start;
        System.out.printf("Fair bucketing initialization finished in %d ms.%n", durationNs / 1000000L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "testIdentifier";
        objectArray2[1] = "com/intellij/testFramework/bucketing/CyclicCounterBucketingScheme";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesCurrentBucket";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBucketNumber";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

