/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationType;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.LineAndColumn;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\t\u001a\u00020\n*\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0011*\u00020\u0012\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u00020\u0001*\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"hasSyntheticOrUndefinedLocation", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "getHasSyntheticOrUndefinedLocation", "(Lorg/jetbrains/kotlin/ir/IrElement;)Z", "shouldIgnore", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getShouldIgnore", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)Z", "getSourceLocation", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "declaration", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "type", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/LocationType;", "buildUnreachableForVerifier", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "buildUnreachableAfterNothingType", "backend.wasm"})
public final class LocationUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getHasSyntheticOrUndefinedLocation(IrElement $this$hasSyntheticOrUndefinedLocation) {
        boolean bl;
        int n = $this$hasSyntheticOrUndefinedLocation.getStartOffset();
        if (-2 <= n) {
            if (n < 0) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        n = $this$hasSyntheticOrUndefinedLocation.getEndOffset();
        if (-2 > n) return false;
        if (n >= 0) return false;
        return true;
    }

    private static final boolean getShouldIgnore(IrSymbol $this$shouldIgnore) {
        IrSymbol irSymbol = $this$shouldIgnore;
        return irSymbol != null && (irSymbol = irSymbol.getOwner()) != null && (irSymbol = IrUtilsKt.getPackageFragment((IrElement)((IrElement)irSymbol))) != null && (irSymbol = irSymbol.getPackageFqName()) != null ? irSymbol.startsWith(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) : false;
    }

    @NotNull
    public static final SourceLocation getSourceLocation(@NotNull IrElement $this$getSourceLocation, @Nullable IrSymbol declaration, @Nullable IrFile file, @NotNull LocationType type) {
        IrFileEntry fileEntry;
        Intrinsics.checkNotNullParameter((Object)$this$getSourceLocation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        IrFile irFile = file;
        Object object = fileEntry = irFile != null ? irFile.getFileEntry() : null;
        if (fileEntry == null) {
            return SourceLocation.Companion.NoLocation("fileEntry is null");
        }
        if (LocationUtilsKt.getHasSyntheticOrUndefinedLocation($this$getSourceLocation)) {
            return SourceLocation.Companion.NoLocation("Synthetic declaration");
        }
        String path = fileEntry.getName();
        LineAndColumn lineAndColumn = type.getLineAndColumnNumberFor($this$getSourceLocation, fileEntry);
        int line = lineAndColumn.component1();
        int column = lineAndColumn.component2();
        if (line < 0 || column < 0) {
            return SourceLocation.Companion.NoLocation("startLine or startColumn < 0");
        }
        String string = file.getModule().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String module2 = string;
        return LocationUtilsKt.getShouldIgnore(declaration) ? (SourceLocation)new SourceLocation.IgnoredLocation(module2, path, line, column) : (SourceLocation)new SourceLocation.Location(module2, path, line, column);
    }

    public static /* synthetic */ SourceLocation getSourceLocation$default(IrElement irElement, IrSymbol irSymbol, IrFile irFile, LocationType locationType, int n, Object object) {
        if ((n & 4) != 0) {
            locationType = LocationType.START;
        }
        return LocationUtilsKt.getSourceLocation(irElement, irSymbol, irFile, locationType);
    }

    public static final void buildUnreachableForVerifier(@NotNull WasmExpressionBuilder $this$buildUnreachableForVerifier) {
        Intrinsics.checkNotNullParameter((Object)$this$buildUnreachableForVerifier, (String)"<this>");
        $this$buildUnreachableForVerifier.buildUnreachable(SourceLocation.Companion.NoLocation("This instruction should never be reached, but required for wasm verifier"));
    }

    public static final void buildUnreachableAfterNothingType(@NotNull WasmExpressionBuilder $this$buildUnreachableAfterNothingType) {
        Intrinsics.checkNotNullParameter((Object)$this$buildUnreachableAfterNothingType, (String)"<this>");
        $this$buildUnreachableAfterNothingType.buildUnreachable(SourceLocation.Companion.NoLocation("The unreachable instruction after an expression with Nothing type to make sure that execution doesn't come here (or it fails fast if so). It also might be required for wasm verifier."));
    }
}

