/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.output.xsd.SchemaInfo;
import com.thaiopensource.relaxng.output.xsd.SourceUriGenerator;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.xml.util.Naming;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PrefixManager
implements SourceUriGenerator {
    private final Map prefixMap = new HashMap();
    private final Set usedPrefixes = new HashSet();
    private final Set reservedPrefixes = new HashSet();
    private int nextGenIndex = 1;
    private static final String[] xsdPrefixes = new String[]{"xs", "xsd"};
    private static final int MAX_PREFIX_LENGTH = 10;

    PrefixManager(SchemaInfo schemaInfo) {
        this.usePrefix("xml", "http://www.w3.org/XML/1998/namespace");
        new PrefixSelector(schemaInfo).assignPrefixes();
    }

    String getPrefix(String string2) {
        String string3 = (String)this.prefixMap.get(string2);
        if (string3 == null && string2.equals("http://www.w3.org/2001/XMLSchema")) {
            int n = 0;
            while (n < xsdPrefixes.length) {
                if (this.tryUsePrefix(xsdPrefixes[n], string2)) {
                    return xsdPrefixes[n];
                }
                ++n;
            }
        }
        if (string3 == null) {
            string3 = this.tryUseUri(string2);
        }
        if (string3 == null) {
            while (!this.tryUsePrefix(string3 = "ns" + Integer.toString(this.nextGenIndex++), string2)) {
            }
        }
        return string3;
    }

    private String tryUseUri(String string2) {
        String string3 = PrefixManager.chooseSegment(string2);
        if (string3 == null) {
            return null;
        }
        if (string3.length() <= 10 && this.tryUsePrefix(string3, string2)) {
            return string3;
        }
        int n = 1;
        while (n <= string3.length()) {
            String string4 = string3.substring(0, n);
            if (this.tryUsePrefix(string4, string2)) {
                return string4;
            }
            ++n;
        }
        return null;
    }

    private boolean tryUsePrefix(String string2, String string3) {
        if (!this.prefixOk(string2, string3)) {
            return false;
        }
        this.usePrefix(string2, string3);
        return true;
    }

    private boolean prefixOk(String string2, String string3) {
        return !this.usedPrefixes.contains(string2) && (!this.reservedPrefixes.contains(string2) || !string3.equals("http://www.w3.org/2001/XMLSchema"));
    }

    private void usePrefix(String string2, String string3) {
        this.usedPrefixes.add(string2);
        this.prefixMap.put(string3, string2);
    }

    private static String chooseSegment(String string2) {
        String string3;
        int n;
        int n2 = string2.indexOf(35);
        if (n2 >= 0) {
            String string4 = string2.substring(n2 + 1).toLowerCase();
            if (Naming.isNcname(string4)) {
                return string4;
            }
        } else {
            n2 = string2.length();
        }
        while ((n = string2.lastIndexOf(47, n2 - 1)) >= 0 && (n <= 0 || string2.charAt(n - 1) != '/')) {
            String string5 = string2.substring(n + 1, n2).toLowerCase();
            if (PrefixManager.segmentOk(string5)) {
                return string5;
            }
            n2 = n;
        }
        n2 = string2.indexOf(58);
        if (n2 >= 0 && PrefixManager.segmentOk(string3 = string2.substring(n2 + 1).toLowerCase())) {
            return string3;
        }
        return null;
    }

    private static boolean segmentOk(String string2) {
        return Naming.isNcname(string2) && !string2.equals("ns") && !string2.equals("namespace");
    }

    public String generateSourceUri(String string2) {
        if (string2.equals("")) {
            return "local";
        }
        return "/" + this.getPrefix(string2);
    }

    class PrefixSelector
    extends AbstractVisitor {
        private final SchemaInfo si;
        private String inheritedNamespace;
        private final Map namespacePrefixUsageMap = new HashMap();

        PrefixSelector(SchemaInfo schemaInfo) {
            this.si = schemaInfo;
            this.inheritedNamespace = "";
            schemaInfo.getGrammar().componentsAccept(this);
            Context context = schemaInfo.getGrammar().getContext();
            if (context != null) {
                Enumeration enumeration = context.prefixes();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (string2.equals("")) continue;
                    this.notePrefix(string2, this.resolveNamespace(context.resolveNamespacePrefix(string2)));
                }
            }
        }

        public Object visitElement(ElementPattern elementPattern) {
            elementPattern.getNameClass().accept(this);
            elementPattern.getChild().accept(this);
            return null;
        }

        public Object visitAttribute(AttributePattern attributePattern) {
            return attributePattern.getNameClass().accept(this);
        }

        public Object visitChoice(ChoiceNameClass choiceNameClass) {
            choiceNameClass.childrenAccept(this);
            return null;
        }

        public Object visitName(NameNameClass nameNameClass) {
            this.notePrefix(nameNameClass.getPrefix(), this.resolveNamespace(nameNameClass.getNamespaceUri()));
            return null;
        }

        public Object visitValue(ValuePattern valuePattern) {
            Iterator iterator = valuePattern.getPrefixMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2 = iterator.next();
                String string2 = (String)entry2.getKey();
                if (string2 == null || string2.equals("")) continue;
                String string3 = this.resolveNamespace((String)entry2.getValue());
                this.notePrefix(string2, string3);
                if (string3.equals("http://www.w3.org/2001/XMLSchema")) continue;
                PrefixManager.this.reservedPrefixes.add(string2);
            }
            return null;
        }

        private String resolveNamespace(String string2) {
            return string2 == NameNameClass.INHERIT_NS ? this.inheritedNamespace : string2;
        }

        private void notePrefix(String string2, String string3) {
            PrefixUsage prefixUsage;
            if (string2 == null || string3 == null || string3.equals("")) {
                return;
            }
            HashMap<String, PrefixUsage> hashMap = (HashMap<String, PrefixUsage>)this.namespacePrefixUsageMap.get(string3);
            if (hashMap == null) {
                hashMap = new HashMap<String, PrefixUsage>();
                this.namespacePrefixUsageMap.put(string3, hashMap);
            }
            if ((prefixUsage = (PrefixUsage)hashMap.get(string2)) == null) {
                prefixUsage = new PrefixUsage();
                hashMap.put(string2, prefixUsage);
            }
            ++prefixUsage.count;
        }

        public Object visitComposite(CompositePattern compositePattern) {
            compositePattern.childrenAccept(this);
            return null;
        }

        public Object visitUnary(UnaryPattern unaryPattern) {
            return unaryPattern.getChild().accept(this);
        }

        public Object visitDefine(DefineComponent defineComponent) {
            defineComponent.getBody().accept(this);
            return null;
        }

        public Object visitDiv(DivComponent divComponent) {
            divComponent.componentsAccept(this);
            return null;
        }

        public Object visitInclude(IncludeComponent includeComponent) {
            String string2 = this.inheritedNamespace;
            this.inheritedNamespace = includeComponent.getNs();
            this.si.getSchema(includeComponent.getHref()).componentsAccept(this);
            this.inheritedNamespace = string2;
            return null;
        }

        void assignPrefixes() {
            Iterator iterator = this.namespacePrefixUsageMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map map;
                Map.Entry entry2 = iterator.next();
                String string2 = (String)entry2.getKey();
                if (string2.equals("") || string2.equals("http://www.w3.org/XML/1998/namespace") || (map = (Map)entry2.getValue()) == null) continue;
                Map.Entry entry3 = null;
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry4 = iterator2.next();
                    if (entry3 != null && ((PrefixUsage)entry4.getValue()).count <= ((PrefixUsage)entry3.getValue()).count || !PrefixManager.this.prefixOk((String)entry4.getKey(), string2)) continue;
                    entry3 = entry4;
                }
                if (entry3 == null) continue;
                PrefixManager.this.usePrefix((String)entry3.getKey(), string2);
            }
        }
    }

    static class PrefixUsage {
        int count;

        PrefixUsage() {
        }
    }
}

