/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.xml.ui.Committable;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UndoHelper {
    private boolean myShowing;
    private final Set<Document> myCurrentDocuments;
    private boolean myDirty;
    private final DocumentListener myDocumentAdapter;

    public UndoHelper(final @NotNull Project project2, final @NotNull Committable committable) {
        if (project2 == null) {
            UndoHelper.$$$reportNull$$$0(0);
        }
        if (committable == null) {
            UndoHelper.$$$reportNull$$$0(1);
        }
        this.myCurrentDocuments = new HashSet<Document>();
        this.myDocumentAdapter = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (UndoHelper.this.myShowing) {
                    UndoHelper.this.myDirty = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/xml/ui/UndoHelper$1", "documentChanged"));
            }
        };
        project2.getMessageBus().connect((Disposable)committable).subscribe(CommandListener.TOPIC, (Object)new CommandListener(){
            PsiDocumentManager psiDocumentManager;

            public void commandStarted(@NotNull CommandEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.undoTransparentActionStarted();
            }

            public void undoTransparentActionStarted() {
                UndoHelper.this.myDirty = false;
            }

            public void undoTransparentActionFinished() {
                if (UndoHelper.this.myDirty) {
                    if (this.psiDocumentManager == null) {
                        this.psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
                    }
                    this.psiDocumentManager.commitAllDocuments();
                    committable.reset();
                }
            }

            public void commandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.undoTransparentActionFinished();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/util/xml/ui/UndoHelper$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public final void startListeningDocuments() {
        for (Document document : this.myCurrentDocuments) {
            document.addDocumentListener(this.myDocumentAdapter);
        }
    }

    public final void stopListeningDocuments() {
        for (Document document : this.myCurrentDocuments) {
            document.removeDocumentListener(this.myDocumentAdapter);
        }
    }

    public final void setShowing(boolean showing) {
        this.myShowing = showing;
    }

    public boolean isShowing() {
        return this.myShowing;
    }

    public final void addWatchedDocument(Document document) {
        this.stopListeningDocuments();
        this.myCurrentDocuments.add(document);
        this.startListeningDocuments();
    }

    public final void removeWatchedDocument(@NotNull Document document) {
        if (document == null) {
            UndoHelper.$$$reportNull$$$0(2);
        }
        this.stopListeningDocuments();
        this.myCurrentDocuments.remove(document);
        this.startListeningDocuments();
    }

    @NotNull
    final @NotNull Document @NotNull [] getDocuments() {
        Document[] documentArray = this.myCurrentDocuments.toArray(Document.EMPTY_ARRAY);
        if (documentArray == null) {
            UndoHelper.$$$reportNull$$$0(3);
        }
        return documentArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "committable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/ui/UndoHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/ui/UndoHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchedDocument";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

