/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.ui.SimpleEditorCustomization;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class SpellCheckingEditorCustomization
extends SimpleEditorCustomization {
    private static volatile Map<String, LocalInspectionToolWrapper> SPELL_CHECK_TOOLS;
    private static volatile boolean READY;

    SpellCheckingEditorCustomization(boolean enabled) {
        super(enabled);
    }

    @NotNull
    private static Map<String, LocalInspectionToolWrapper> getSpellCheckTools() {
        Map<String, LocalInspectionToolWrapper> tools = SPELL_CHECK_TOOLS;
        if (tools == null) {
            Class[] inspectionClasses;
            tools = new HashMap<String, LocalInspectionToolWrapper>();
            for (Class inspectionClass : inspectionClasses = new Class[]{SpellCheckingInspection.class}) {
                try {
                    LocalInspectionTool tool = (LocalInspectionTool)inspectionClass.newInstance();
                    tools.put(tool.getShortName(), new LocalInspectionToolWrapper(tool));
                }
                catch (Throwable e) {
                    READY = false;
                    Map<String, LocalInspectionToolWrapper> map = Map.of();
                    if (map == null) {
                        SpellCheckingEditorCustomization.$$$reportNull$$$0(0);
                    }
                    return map;
                }
            }
            SPELL_CHECK_TOOLS = tools;
            READY = true;
        }
        Map<String, LocalInspectionToolWrapper> map = tools;
        if (map == null) {
            SpellCheckingEditorCustomization.$$$reportNull$$$0(1);
        }
        return map;
    }

    private static boolean isReady() {
        if (SPELL_CHECK_TOOLS == null) {
            SpellCheckingEditorCustomization.getSpellCheckTools();
        }
        return READY;
    }

    public void customize(@NotNull EditorEx editor) {
        DaemonCodeAnalyzer analyzer;
        if (editor == null) {
            SpellCheckingEditorCustomization.$$$reportNull$$$0(2);
        }
        boolean apply2 = this.isEnabled();
        if (!SpellCheckingEditorCustomization.isReady()) {
            return;
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return;
        }
        PsiFile file = (PsiFile)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project2).getPsiFile((Document)editor.getDocument()));
        if (file == null) {
            return;
        }
        Function strategy = InspectionProfileWrapper.getCustomInspectionProfileWrapper((PsiFile)file);
        if (strategy == null) {
            strategy = new MyInspectionProfileStrategy();
            InspectionProfileWrapper.setCustomInspectionProfileWrapperTemporarily((PsiFile)file, (Function)strategy);
        }
        if (!(strategy instanceof MyInspectionProfileStrategy)) {
            return;
        }
        ((MyInspectionProfileStrategy)strategy).setUseSpellCheck(apply2);
        if (apply2) {
            editor.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, (Object)false);
        }
        if ((analyzer = DaemonCodeAnalyzer.getInstance((Project)project2)) != null) {
            analyzer.restart(file);
        }
    }

    public static boolean isSpellCheckingDisabled(@NotNull PsiFile file) {
        Function strategy;
        if (file == null) {
            SpellCheckingEditorCustomization.$$$reportNull$$$0(3);
        }
        return (strategy = InspectionProfileWrapper.getCustomInspectionProfileWrapper((PsiFile)file)) instanceof MyInspectionProfileStrategy && !((MyInspectionProfileStrategy)strategy).myUseSpellCheck;
    }

    static Set<String> getSpellCheckingToolNames() {
        return Collections.unmodifiableSet(SpellCheckingEditorCustomization.getSpellCheckTools().keySet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpellCheckTools";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSpellCheckingDisabled";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3 -> new IllegalArgumentException(string2);
        };
    }

    private static class MyInspectionProfileStrategy
    implements Function<InspectionProfile, InspectionProfileWrapper> {
        private final ConcurrentMap<InspectionProfile, MyInspectionProfileWrapper> myWrappers = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        private boolean myUseSpellCheck;

        private MyInspectionProfileStrategy() {
        }

        @Override
        @NotNull
        public InspectionProfileWrapper apply(@NotNull InspectionProfile profile) {
            if (profile == null) {
                MyInspectionProfileStrategy.$$$reportNull$$$0(0);
            }
            if (!SpellCheckingEditorCustomization.isReady()) {
                return new InspectionProfileWrapper((InspectionProfileImpl)profile);
            }
            MyInspectionProfileWrapper wrapper = (MyInspectionProfileWrapper)((Object)this.myWrappers.get(profile));
            MyInspectionProfileWrapper myInspectionProfileWrapper = wrapper == null ? (InspectionProfileWrapper)ConcurrencyUtil.cacheOrGet(this.myWrappers, (Object)profile, (Object)((Object)new MyInspectionProfileWrapper(profile, this.myUseSpellCheck))) : wrapper;
            if (myInspectionProfileWrapper == null) {
                MyInspectionProfileStrategy.$$$reportNull$$$0(1);
            }
            return myInspectionProfileWrapper;
        }

        public void setUseSpellCheck(boolean useSpellCheck) {
            this.myUseSpellCheck = useSpellCheck;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileStrategy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static class MyInspectionProfileWrapper
    extends InspectionProfileWrapper {
        private final boolean myUseSpellCheck;

        MyInspectionProfileWrapper(@NotNull InspectionProfile inspectionProfile, boolean useSpellCheck) {
            if (inspectionProfile == null) {
                MyInspectionProfileWrapper.$$$reportNull$$$0(0);
            }
            super((InspectionProfileImpl)inspectionProfile);
            this.myUseSpellCheck = useSpellCheck;
        }

        public boolean isToolEnabled(HighlightDisplayKey key2, PsiElement element) {
            return key2 != null && SpellCheckingEditorCustomization.getSpellCheckTools().containsKey(key2.getShortName()) ? this.myUseSpellCheck : super.isToolEnabled(key2, element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileWrapper", "<init>"));
        }
    }
}

