/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.BaseBusConnection;
import com.intellij.util.messages.impl.MessageBusImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0010\u001a\u00020\fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;", "Lcom/intellij/util/messages/impl/BaseBusConnection;", "Lcom/intellij/util/messages/MessageBusConnection;", "bus", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "<init>", "(Lcom/intellij/util/messages/impl/MessageBusImpl;)V", "defaultHandler", "Lcom/intellij/util/messages/MessageHandler;", "subscribe", "", "L", "", "topic", "Lcom/intellij/util/messages/Topic;", "setDefaultHandler", "handler", "dispose", "disconnect", "deliverImmediately", "isMyHandler", "", "intellij.platform.core"})
@ApiStatus.Internal
public final class MessageBusConnectionImpl
extends BaseBusConnection
implements MessageBusConnection {
    @Nullable
    private MessageHandler defaultHandler;

    public MessageBusConnectionImpl(@NotNull MessageBusImpl bus) {
        Intrinsics.checkNotNullParameter(bus, "bus");
        super(bus, null);
    }

    public <L> void subscribe(@NotNull Topic<L> topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        MessageHandler messageHandler = this.defaultHandler;
        if (messageHandler == null) {
            throw new IllegalStateException("Connection must have default handler installed prior to any anonymous subscriptions. Target topic: " + topic);
        }
        MessageHandler defaultHandler = messageHandler;
        if (!(!topic.getListenerClass().isInstance(defaultHandler))) {
            boolean bl = false;
            String string = "Can't subscribe to the topic '" + topic + "'. Default handler has incompatible type - expected: '" + topic.getListenerClass() + "', actual: '" + defaultHandler.getClass() + '\'';
            throw new IllegalStateException(string.toString());
        }
        this.subscribe(topic, (Object)defaultHandler);
    }

    public void setDefaultHandler(@Nullable MessageHandler handler) {
        this.defaultHandler = handler;
    }

    public void dispose() {
        MessageBusImpl messageBusImpl = this.bus;
        if (messageBusImpl == null) {
            return;
        }
        MessageBusImpl bus = messageBusImpl;
        this.bus = null;
        this.defaultHandler = null;
        Object[] objectArray = this.subscriptions.getAndSet(ArrayUtilRt.EMPTY_OBJECT_ARRAY);
        Intrinsics.checkNotNullExpressionValue(objectArray, "getAndSet(...)");
        bus.notifyConnectionTerminated$intellij_platform_core(objectArray);
    }

    @Override
    public void disconnect() {
        Disposer.dispose((Disposable)((Object)this));
    }

    public void deliverImmediately() {
        MessageBusImpl bus = this.bus;
        if (bus == null) {
            MessageBusImpl.LOG.error("Bus is already disposed");
        } else {
            bus.deliverImmediately$intellij_platform_core(this);
        }
    }

    public final boolean isMyHandler(@NotNull Topic<?> topic, @NotNull Object handler) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(handler, "handler");
        if (this.defaultHandler == handler) {
            return true;
        }
        Object[] topicAndHandlerPairs = (Object[])this.subscriptions.get();
        int n = topicAndHandlerPairs.length;
        for (int i = 0; i < n; i += 2) {
            if (topic != topicAndHandlerPairs[i] || handler != topicAndHandlerPairs[i + 1]) continue;
            return true;
        }
        return false;
    }
}

