/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.properties;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.properties.GradleLocalProperties;
import org.jetbrains.plugins.gradle.properties.GradleLocalPropertiesImpl;
import org.jetbrains.plugins.gradle.properties.models.PropertyKt;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gradle/properties/GradleLocalPropertiesFile;", "", "<init>", "()V", "getProperties", "Lorg/jetbrains/plugins/gradle/properties/GradleLocalProperties;", "externalProjectPath", "Ljava/nio/file/Path;", "loadGradleLocalProperties", "propertiesPath", "getGradleLocalPropertiesPath", "intellij.gradle"})
public final class GradleLocalPropertiesFile {
    @NotNull
    public static final GradleLocalPropertiesFile INSTANCE = new GradleLocalPropertiesFile();

    private GradleLocalPropertiesFile() {
    }

    @NotNull
    public final GradleLocalProperties getProperties(@NotNull Path externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Path propertiesPath = this.getGradleLocalPropertiesPath(externalProjectPath2);
        return this.loadGradleLocalProperties(propertiesPath);
    }

    private final GradleLocalProperties loadGradleLocalProperties(Path propertiesPath) {
        Properties properties = GradleUtil.readGradleProperties(propertiesPath);
        if (properties == null) {
            return GradleLocalProperties.EMPTY.INSTANCE;
        }
        Properties properties2 = properties;
        return new GradleLocalPropertiesImpl(PropertyKt.getStringProperty(properties2, "java.home", propertiesPath));
    }

    private final Path getGradleLocalPropertiesPath(Path externalProjectPath2) {
        String[] stringArray = new String[]{"config.properties"};
        Path gradleLocalPath = externalProjectPath2.resolve(Paths.get(".gradle", stringArray));
        Path path = gradleLocalPath.toAbsolutePath().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        return path;
    }
}

