/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.ModelProblem;

public final class MavenApiConverterUtil {
    private MavenApiConverterUtil() {
    }

    public static List<ModelProblem> convertFromApiProblems(List<org.apache.maven.api.services.ModelProblem> problems) {
        return problems.stream().map(it -> new DefaultModelProblem(it.getMessage(), MavenApiConverterUtil.convertFromApiSeverity(it.getSeverity()), MavenApiConverterUtil.convertFromApiVersion(it.getVersion()), it.getSource(), it.getLineNumber(), it.getColumnNumber(), it.getModelId(), it.getException())).collect(Collectors.toList());
    }

    private static ModelProblem.Version convertFromApiVersion(ModelProblem.Version version) {
        switch (version) {
            case BASE: {
                return ModelProblem.Version.BASE;
            }
            case V20: {
                return ModelProblem.Version.V20;
            }
            case V30: {
                return ModelProblem.Version.V30;
            }
            case V31: {
                return ModelProblem.Version.V31;
            }
            case V40: {
                return ModelProblem.Version.V40;
            }
        }
        throw new IllegalArgumentException(version.toString());
    }

    private static ModelProblem.Severity convertFromApiSeverity(BuilderProblem.Severity severity) {
        switch (severity) {
            case FATAL: {
                return ModelProblem.Severity.FATAL;
            }
            case ERROR: {
                return ModelProblem.Severity.ERROR;
            }
            case WARNING: {
                return ModelProblem.Severity.WARNING;
            }
        }
        throw new IllegalArgumentException(severity.toString());
    }
}

