/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session.scraper;

import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.TerminalLine;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.session.StyleRange;
import org.jetbrains.plugins.terminal.block.session.scraper.StringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.TerminalLinesCollector;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/scraper/StylesCollectingTerminalLinesCollector;", "Lorg/jetbrains/plugins/terminal/block/session/scraper/TerminalLinesCollector;", "delegate", "Lorg/jetbrains/plugins/terminal/block/session/scraper/StringCollector;", "stylesConsumer", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/terminal/block/session/StyleRange;", "", "<init>", "(Lorg/jetbrains/plugins/terminal/block/session/scraper/StringCollector;Lkotlin/jvm/functions/Function1;)V", "addLine", "line", "Lcom/jediterm/terminal/model/TerminalLine;", "intellij.terminal"})
public final class StylesCollectingTerminalLinesCollector
implements TerminalLinesCollector {
    @NotNull
    private final StringCollector delegate;
    @NotNull
    private final Function1<StyleRange, Unit> stylesConsumer;

    public StylesCollectingTerminalLinesCollector(@NotNull StringCollector delegate, @NotNull Function1<? super StyleRange, Unit> stylesConsumer) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(stylesConsumer, (String)"stylesConsumer");
        this.delegate = delegate;
        this.stylesConsumer = stylesConsumer;
    }

    @Override
    public void addLine(@NotNull TerminalLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        line.forEachEntry(arg_0 -> StylesCollectingTerminalLinesCollector.addLine$lambda$0(this, arg_0));
        if (!line.isWrapped()) {
            this.delegate.newline();
        }
    }

    private static final void addLine$lambda$0(StylesCollectingTerminalLinesCollector this$0, TerminalLine.TextEntry entry) {
        CharBuffer charBuffer = entry.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"getText(...)");
        String text = TerminalUiUtilsKt.normalize(charBuffer);
        if (((CharSequence)text).length() > 0 && !entry.isNul()) {
            this$0.delegate.write(text);
            if (!Intrinsics.areEqual((Object)entry.getStyle(), (Object)TextStyle.EMPTY)) {
                int endOffset = this$0.delegate.length();
                int startOffset = endOffset - text.length();
                TextStyle textStyle = entry.getStyle();
                Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"getStyle(...)");
                StyleRange style = new StyleRange(startOffset, endOffset, textStyle);
                this$0.stylesConsumer.invoke((Object)style);
            }
        }
    }
}

