/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssValue;

public class CssClamp
extends CssCheckableValue {
    public static final int type = 26;
    ApplContext ac;
    int computed_type = -1;
    ArrayList<CssValue> values = null;
    String _toString = null;

    @Override
    public final int getRawType() {
        return 26;
    }

    @Override
    public final int getType() {
        if (this.computed_type == 26) {
            return 26;
        }
        return this.computed_type;
    }

    public CssClamp() {
    }

    public CssClamp(ApplContext ac, CssValue v1, CssValue v2, CssValue v3) {
        this.ac = ac;
        this.values = new ArrayList();
        this.values.add(v1);
        this.values.add(v2);
        this.values.add(v3);
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        throw new InvalidParamException("unrecognize", s, ac);
    }

    @Override
    public void setValue(BigDecimal d) {
    }

    public CssClamp addValue(CssValue value) throws InvalidParamException {
        boolean first = false;
        if (this.values == null) {
            this.values = new ArrayList();
            first = true;
        }
        this.values.add(value);
        this._computeResultingType();
        return this;
    }

    public void validate() throws InvalidParamException {
        this._computeResultingType();
    }

    private int _checkAcceptableType(int type) throws InvalidParamException {
        if (type != 4 && type != 6 && type != 5 && type != 7 && type != 9 && type != 8) {
            throw new InvalidParamException("invalidtype", this.toStringUnprefixed(), this.ac);
        }
        return type;
    }

    private void _computeResultingType() throws InvalidParamException {
        int valtype = 24;
        boolean firstVal = true;
        CssValue prevVal = null;
        for (CssValue v : this.values) {
            if (firstVal) {
                valtype = v.getType();
                this._checkAcceptableType(valtype);
                this.computed_type = valtype;
                firstVal = false;
                prevVal = v;
                continue;
            }
            if (valtype == v.getType()) {
                prevVal = v;
                continue;
            }
            if (valtype == 4) {
                valtype = this._checkAcceptableType(v.getType());
                prevVal = v;
                continue;
            }
            if (v.getType() == 4) continue;
            if (valtype == 5 && prevVal.getNumber().isZero()) {
                valtype = this._checkAcceptableType(v.getType());
                prevVal = v;
                continue;
            }
            if (v.getType() == 5 && v.getNumber().isZero()) continue;
            throw new InvalidParamException("incompatibletypes", this.toStringUnprefixed(), this.ac);
        }
        this.computed_type = valtype;
    }

    @Override
    public Object get() {
        return this.toString();
    }

    protected String toStringUnprefixed() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (CssValue v : this.values) {
            if (!isFirst) {
                sb.append(", ");
            } else {
                isFirst = false;
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public String toString() {
        if (this._toString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("clamp(").append(this.toStringUnprefixed()).append(')');
            this._toString = sb.toString();
        }
        return this._toString;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isPositive() {
        return false;
    }

    @Override
    public boolean isStrictlyPositive() {
        return false;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean equals(Object value) {
        if (!(value instanceof CssClamp)) {
            return false;
        }
        CssClamp other = (CssClamp)value;
        for (CssValue v : this.values) {
            boolean match = false;
            for (CssValue ov : other.values) {
                if (!v.equals(ov)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkPositiveness(ApplContext ac, String callername) throws InvalidParamException {
    }

    @Override
    public void checkStrictPositiveness(ApplContext ac, String callername) throws InvalidParamException {
    }

    @Override
    public void checkInteger(ApplContext ac, String callername) throws InvalidParamException {
    }

    @Override
    public boolean warnPositiveness(ApplContext ac, String callername) {
        return true;
    }

    @Override
    public CssLength getLength() throws InvalidParamException {
        if (this.computed_type == 6) {
            for (CssValue v : this.values) {
                if (v.getType() != 6) continue;
                return v.getLength();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssPercentage getPercentage() throws InvalidParamException {
        if (this.computed_type == 4) {
            for (CssValue v : this.values) {
                if (v.getType() != 4) continue;
                return v.getPercentage();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssNumber getNumber() throws InvalidParamException {
        if (this.computed_type == 5) {
            for (CssValue v : this.values) {
                if (v.getType() != 5) continue;
                return v.getNumber();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssTime getTime() throws InvalidParamException {
        if (this.computed_type == 8) {
            for (CssValue v : this.values) {
                if (v.getType() != 8) continue;
                return v.getTime();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssAngle getAngle() throws InvalidParamException {
        if (this.computed_type == 7) {
            for (CssValue v : this.values) {
                if (v.getType() != 7) continue;
                return v.getAngle();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssFrequency getFrequency() throws InvalidParamException {
        if (this.computed_type == 9) {
            for (CssValue v : this.values) {
                if (v.getType() != 9) continue;
                return v.getFrequency();
            }
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public void checkEqualsZero(ApplContext ac, String callername) throws InvalidParamException {
        this.warnEqualsZero(ac, callername);
    }

    @Override
    public boolean warnEqualsZero(ApplContext ac, String callername) {
        if (!this.isZero()) {
            ac.getFrame().addWarning("dynamic", this.toString());
            return false;
        }
        return true;
    }
}

