/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css3.CssBorderWidth;
import org.w3c.css.properties.css3.CssOutlineColor;
import org.w3c.css.properties.css3.CssOutlineStyle;
import org.w3c.css.properties.css3.CssOutlineWidth;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssOutline
extends org.w3c.css.properties.css.CssOutline {
    public CssOutline() {
        this.value = initial;
        this._color = new CssOutlineColor();
        this._style = new CssOutlineStyle();
        this._width = new CssOutlineWidth();
    }

    public CssOutline(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue colorValue = null;
        CssValue widthValue = null;
        CssIdent styleValue = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 11: {
                    CssExpression ex;
                    if (colorValue == null) {
                        ex = new CssExpression();
                        ex.addValue(val);
                        this._color = new CssOutlineColor(ac, ex, check);
                        colorValue = this._color.value;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                case 5: 
                case 6: {
                    CssExpression ex;
                    if (widthValue == null) {
                        ex = new CssExpression();
                        ex.addValue(val);
                        this._width = new CssOutlineWidth(ac, ex, check);
                        widthValue = this._width.value;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                case 3: 
                case 15: {
                    CssExpression ex;
                    if (colorValue == null) {
                        ex = new CssExpression();
                        ex.addValue(val);
                        this._color = new CssOutlineColor(ac, ex, check);
                        colorValue = this._color.value;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                case 0: {
                    CssIdent match;
                    if (inherit.equals(val)) {
                        if (expression.getCount() != 1) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        this.value = inherit;
                        break;
                    }
                    CssIdent ident = (CssIdent)val;
                    if (styleValue == null && (match = CssOutlineStyle.getMatchingIdent(ident)) != null) {
                        styleValue = match;
                        break;
                    }
                    if (widthValue == null && (match = CssBorderWidth.getMatchingIdent(ident)) != null) {
                        widthValue = match;
                        break;
                    }
                    if (colorValue == null) {
                        match = CssOutlineColor.getMatchingIdent(ident);
                        if (match != null) {
                            colorValue = match;
                            break;
                        }
                        CssExpression ex = new CssExpression();
                        ex.addValue(val);
                        this._color = new CssOutlineColor(ac, ex, check);
                        colorValue = this._color.value;
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (this._width == null) {
            this._width = new CssOutlineWidth();
        }
        if (this._style == null) {
            this._style = new CssOutlineStyle();
        }
        if (this._color == null) {
            this._color = new CssOutlineColor();
        }
        if (expression.getCount() == 1) {
            if (widthValue != null) {
                this.value = widthValue;
                this._width.value = widthValue;
            } else if (styleValue != null) {
                this.value = styleValue;
                this._style.value = styleValue;
            } else if (colorValue != null) {
                this.value = colorValue;
                this._color.value = colorValue;
            }
        } else {
            ArrayList<CssValue> values = new ArrayList<CssValue>(4);
            if (widthValue != null) {
                values.add(widthValue);
                this._width.value = widthValue;
            }
            if (styleValue != null) {
                values.add(styleValue);
                this._style.value = styleValue;
            }
            if (colorValue != null) {
                values.add(colorValue);
                this._color.value = colorValue;
            }
            this.value = new CssValueList(values);
        }
    }

    public CssOutline(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }
}

