/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.sax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XmlSerializer
implements ContentHandler,
LexicalHandler {
    private static final Map<String, String> WELL_KNOWN_ATTRIBUTE_PREFIXES = new HashMap<String, String>();
    private static final Map<String, String> WELL_KNOWN_ELEMENT_PREFIXES;
    private final LinkedList<StackNode> stack = new LinkedList();
    private final Writer writer;

    private static final Writer wrap(OutputStream out) {
        Charset charset = Charset.forName("utf-8");
        CharsetEncoder encoder = charset.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPLACE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        try {
            encoder.replaceWith("\ufffd".getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new OutputStreamWriter(out, encoder);
    }

    public XmlSerializer(OutputStream out) {
        this(XmlSerializer.wrap(out));
    }

    public XmlSerializer(Writer out) {
        this.writer = out;
    }

    protected void checkNCName(String name) throws SAXException {
    }

    private final void push(String uri, String local, String prefix) {
        this.stack.addFirst(new StackNode(uri, local, prefix));
    }

    private final String pop() {
        String rv = this.stack.removeFirst().qName;
        this.stack.getFirst().mappings.clear();
        return rv;
    }

    private final String lookupPrefixAttribute(String ns) {
        if ("http://www.w3.org/XML/1998/namespace".equals(ns)) {
            return "xml";
        }
        HashSet<String> hidden = new HashSet<String>();
        for (StackNode node : this.stack) {
            for (PrefixMapping mapping : node.mappings) {
                if (mapping.prefix.length() != 0 && mapping.uri.equals(ns) && !hidden.contains(mapping.prefix)) {
                    return mapping.prefix;
                }
                hidden.add(mapping.prefix);
            }
        }
        return null;
    }

    private final String lookupUri(String prefix) {
        for (StackNode node : this.stack) {
            for (PrefixMapping mapping : node.mappings) {
                if (!mapping.prefix.equals(prefix)) continue;
                return mapping.uri;
            }
        }
        return null;
    }

    private final boolean xmlNsQname(String name) {
        if (name == null) {
            return false;
        }
        if ("xmlns".equals(name)) {
            return true;
        }
        return name.startsWith("xmlns:");
    }

    private final void writeAttributeValue(String val) throws IOException {
        boolean prevWasSpace = true;
        int last = val.length() - 1;
        block12: for (int i = 0; i <= last; ++i) {
            char c = val.charAt(i);
            switch (c) {
                case '<': {
                    this.writer.write("&lt;");
                    prevWasSpace = false;
                    continue block12;
                }
                case '>': {
                    this.writer.write("&gt;");
                    prevWasSpace = false;
                    continue block12;
                }
                case '&': {
                    this.writer.write("&amp;");
                    prevWasSpace = false;
                    continue block12;
                }
                case '\"': {
                    this.writer.write("&quot;");
                    prevWasSpace = false;
                    continue block12;
                }
                case '\r': {
                    this.writer.write("&#xD;");
                    prevWasSpace = false;
                    continue block12;
                }
                case '\t': {
                    this.writer.write("&#x9;");
                    prevWasSpace = false;
                    continue block12;
                }
                case '\n': {
                    this.writer.write("&#xA;");
                    prevWasSpace = false;
                    continue block12;
                }
                case ' ': {
                    if (prevWasSpace || i == last) {
                        this.writer.write("&#x20;");
                        prevWasSpace = false;
                        continue block12;
                    }
                    this.writer.write(32);
                    prevWasSpace = true;
                    continue block12;
                }
                case '\ufffe': {
                    this.writer.write(65533);
                    prevWasSpace = false;
                    continue block12;
                }
                case '\uffff': {
                    this.writer.write(65533);
                    prevWasSpace = false;
                    continue block12;
                }
                default: {
                    if (c < ' ') {
                        this.writer.write(65533);
                    } else {
                        this.writer.write(c);
                    }
                    prevWasSpace = false;
                }
            }
        }
    }

    private final void generatePrefix(String uri) throws SAXException {
        int counter = 0;
        String candidate = WELL_KNOWN_ATTRIBUTE_PREFIXES.get(uri);
        if (candidate == null) {
            candidate = "p" + counter++;
        }
        while (this.lookupUri(candidate) != null) {
            candidate = "p" + counter++;
        }
        this.startPrefixMappingPrivate(candidate, uri);
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        try {
            block12: for (int i = start; i < start + length; ++i) {
                char c = ch[i];
                switch (c) {
                    case '<': {
                        this.writer.write("&lt;");
                        continue block12;
                    }
                    case '>': {
                        this.writer.write("&gt;");
                        continue block12;
                    }
                    case '&': {
                        this.writer.write("&amp;");
                        continue block12;
                    }
                    case '\r': {
                        this.writer.write("&#xD;");
                        continue block12;
                    }
                    case '\t': {
                        this.writer.write(9);
                        continue block12;
                    }
                    case '\n': {
                        this.writer.write(10);
                        continue block12;
                    }
                    case '\ufffe': {
                        this.writer.write(65533);
                        continue block12;
                    }
                    case '\uffff': {
                        this.writer.write(65533);
                        continue block12;
                    }
                    default: {
                        if (c < ' ') {
                            this.writer.write(65533);
                            continue block12;
                        }
                        this.writer.write(c);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public final void endDocument() throws SAXException {
        try {
            this.stack.clear();
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.writer.write(60);
            this.writer.write(47);
            this.writer.write(this.pop());
            this.writer.write(62);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public final void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
        try {
            this.checkNCName(target);
            this.writer.write("<?");
            this.writer.write(target);
            this.writer.write(32);
            boolean prevWasQuestionmark = false;
            block10: for (int i = 0; i < data.length(); ++i) {
                char c = data.charAt(i);
                switch (c) {
                    case '?': {
                        this.writer.write(63);
                        prevWasQuestionmark = true;
                        continue block10;
                    }
                    case '>': {
                        if (prevWasQuestionmark) {
                            this.writer.write(" >");
                        } else {
                            this.writer.write(62);
                        }
                        prevWasQuestionmark = false;
                        continue block10;
                    }
                    case '\t': {
                        this.writer.write(9);
                        prevWasQuestionmark = false;
                        continue block10;
                    }
                    case '\n': 
                    case '\r': {
                        this.writer.write(10);
                        prevWasQuestionmark = false;
                        continue block10;
                    }
                    case '\ufffe': {
                        this.writer.write(65533);
                        prevWasQuestionmark = false;
                        continue block10;
                    }
                    case '\uffff': {
                        this.writer.write(65533);
                        prevWasQuestionmark = false;
                        continue block10;
                    }
                    default: {
                        if (c < ' ') {
                            this.writer.write(65533);
                        } else {
                            this.writer.write(c);
                        }
                        prevWasQuestionmark = false;
                    }
                }
            }
            this.writer.write("?>");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
    }

    @Override
    public final void startDocument() throws SAXException {
        try {
            this.writer.write("<?xml version='1.0' encoding='utf-8'?>\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.stack.clear();
        this.push(null, null, null);
    }

    @Override
    public final void startElement(String uri, String localName, String q, Attributes atts) throws SAXException {
        String attUri;
        String qName;
        String prefix;
        this.checkNCName(localName);
        if (uri.length() == 0) {
            prefix = "";
            qName = localName;
            this.startPrefixMappingPrivate(prefix, uri);
        } else {
            String lookup;
            prefix = WELL_KNOWN_ELEMENT_PREFIXES.get(uri);
            if (prefix == null) {
                prefix = "";
            }
            if ((lookup = this.lookupUri(prefix)) != null && !lookup.equals(uri)) {
                prefix = "";
            }
            this.startPrefixMappingPrivate(prefix, uri);
            qName = prefix.length() == 0 ? localName : prefix + ':' + localName;
        }
        int attLen = atts.getLength();
        for (int i = 0; i < attLen; ++i) {
            attUri = atts.getURI(i);
            if (attUri.length() == 0 || "http://www.w3.org/XML/1998/namespace".equals(attUri) || "http://www.w3.org/2000/xmlns/".equals(attUri) || atts.getLocalName(i).length() == 0 || this.xmlNsQname(atts.getQName(i)) || this.lookupPrefixAttribute(attUri) != null) continue;
            this.generatePrefix(attUri);
        }
        try {
            this.writer.write(60);
            this.writer.write(qName);
            for (PrefixMapping mapping : this.stack.getFirst().mappings) {
                this.writer.write(32);
                if (mapping.prefix.length() == 0) {
                    this.writer.write("xmlns");
                } else {
                    this.writer.write("xmlns:");
                    this.writer.write(mapping.prefix);
                }
                this.writer.write(61);
                this.writer.write(34);
                this.writeAttributeValue(mapping.uri);
                this.writer.write(34);
            }
            for (int i = 0; i < attLen; ++i) {
                attUri = atts.getURI(i);
                if ("http://www.w3.org/XML/1998/namespace".equals(attUri) || "http://www.w3.org/2000/xmlns/".equals(attUri) || atts.getLocalName(i).length() == 0 || this.xmlNsQname(atts.getQName(i))) continue;
                this.writer.write(32);
                if (attUri.length() != 0) {
                    this.writer.write(this.lookupPrefixAttribute(attUri));
                    this.writer.write(58);
                }
                String attLocal = atts.getLocalName(i);
                this.checkNCName(attLocal);
                this.writer.write(attLocal);
                this.writer.write(61);
                this.writer.write(34);
                this.writeAttributeValue(atts.getValue(i));
                this.writer.write(34);
            }
            this.writer.write(62);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.push(uri, qName, prefix);
    }

    @Override
    public final void comment(char[] ch, int start, int length) throws SAXException {
        try {
            boolean prevWasHyphen = false;
            this.writer.write("<!--");
            block9: for (int i = start; i < start + length; ++i) {
                char c = ch[i];
                switch (c) {
                    case '-': {
                        if (prevWasHyphen) {
                            this.writer.write(" -");
                            continue block9;
                        }
                        this.writer.write(45);
                        prevWasHyphen = true;
                        continue block9;
                    }
                    case '\t': {
                        this.writer.write(9);
                        prevWasHyphen = false;
                        continue block9;
                    }
                    case '\n': 
                    case '\r': {
                        this.writer.write(10);
                        prevWasHyphen = false;
                        continue block9;
                    }
                    case '\ufffe': {
                        this.writer.write(65533);
                        prevWasHyphen = false;
                        continue block9;
                    }
                    case '\uffff': {
                        this.writer.write(65533);
                        prevWasHyphen = false;
                        continue block9;
                    }
                    default: {
                        if (c < ' ') {
                            this.writer.write(65533);
                        } else {
                            this.writer.write(c);
                        }
                        prevWasHyphen = false;
                    }
                }
            }
            if (prevWasHyphen) {
                this.writer.write(32);
            }
            this.writer.write("-->");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public final void endCDATA() throws SAXException {
    }

    @Override
    public final void endDTD() throws SAXException {
    }

    @Override
    public final void endEntity(String name) throws SAXException {
    }

    @Override
    public final void startCDATA() throws SAXException {
    }

    @Override
    public final void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public final void startEntity(String name) throws SAXException {
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix.length() == 0 || uri.equals(this.lookupUri(prefix))) {
            return;
        }
        if (uri.equals(this.lookupUri(prefix))) {
            return;
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
            if ("xml".equals(prefix)) {
                return;
            }
            throw new SAXException("Attempt to declare a reserved NS uri.");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
            throw new SAXException("Attempt to declare a reserved NS uri.");
        }
        if (uri.length() == 0 && prefix.length() != 0) {
            throw new SAXException("Can bind a prefix to no namespace.");
        }
        this.checkNCName(prefix);
        Set<PrefixMapping> theSet = this.stack.getFirst().mappings;
        PrefixMapping mapping = new PrefixMapping(uri, prefix);
        if (theSet.contains(mapping)) {
            throw new SAXException("Attempt to map one prefix to two URIs on one element.");
        }
        theSet.add(mapping);
    }

    public final void startPrefixMappingPrivate(String prefix, String uri) throws SAXException {
        if (uri.equals(this.lookupUri(prefix))) {
            return;
        }
        this.stack.getFirst().mappings.add(new PrefixMapping(uri, prefix));
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
    }

    static {
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("adobe:ns:meta/", "x");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd", "sodipodi");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/AdobeIllustrator/10.0/", "i");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/", "a");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/Extensibility/1.0/", "x");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/illustrator/1.0/", "illustrator");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/pdf/1.3/", "pdf");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/photoshop/1.0/", "photoshop");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/tiff/1.0/", "tiff");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/xap/1.0/", "xap");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/xap/1.0/g/", "xapG");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/xap/1.0/mm/", "xapMM");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/xap/1.0/rights/", "xapRights");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/xap/1.0/sType/Dimensions#", "stDim");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/xap/1.0/sType/ResourceRef#", "stRef");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://ns.adobe.com/xap/1.0/t/pg/", "xapTPg");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://purl.org/dc/elements/1.1/", "dc");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://schemas.microsoft.com/visio/2003/SVGExtensions/", "v");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd", "sodipodi");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://w3.org/1999/xlink", "xlink");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://www.carto.net/attrib/", "attrib");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://www.iki.fi/pav/software/textext/", "textext");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://www.inkscape.org/namespaces/inkscape", "inkscape");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://www.justsystem.co.jp/hanako13/svg", "jsh");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://www.w3.org/1999/xlink", "xlink");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        WELL_KNOWN_ATTRIBUTE_PREFIXES.put("http://www.w3.org/1999/xlink", "xlink");
        WELL_KNOWN_ELEMENT_PREFIXES = new HashMap<String, String>();
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://www.w3.org/1999/XSL/Transform", "xsl");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://purl.org/dc/elements/1.1/", "dc");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://www.ascc.net/xml/schematron", "sch");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://purl.oclc.org/dsdl/schematron", "sch");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://www.inkscape.org/namespaces/inkscape", "inkscape");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd", "sodipodi");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/", "a");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/AdobeIllustrator/10.0/", "i");
        WELL_KNOWN_ELEMENT_PREFIXES.put("adobe:ns:meta/", "x");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/xap/1.0/", "xap");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/pdf/1.3/", "pdf");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/tiff/1.0/", "tiff");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://creativecommons.org/ns#", "cc");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd", "sodipodi");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/", "Iptc4xmpCore");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/exif/1.0/", "exif");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/Extensibility/1.0/", "x");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/illustrator/1.0/", "illustrator");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/pdfx/1.3/", "pdfx");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/photoshop/1.0/", "photoshop");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/Variables/1.0/", "v");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/xap/1.0/g/", "xapG");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/xap/1.0/g/img/", "xapGImg");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/xap/1.0/mm/", "xapMM");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/xap/1.0/rights/", "xapRights");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/xap/1.0/sType/Dimensions#", "stDim");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/xap/1.0/sType/Font#", "stFnt");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/xap/1.0/sType/ResourceRef#", "stRef");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://ns.adobe.com/xap/1.0/t/pg/", "xapTPg");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://product.corel.com/CGS/11/cddns/", "odm");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://schemas.microsoft.com/visio/2003/SVGExtensions/", "v");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://web.resource.org/cc/", "cc");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://www.freesoftware.fsf.org/bkchem/cdml", "cdml");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://www.opengis.net/gml", "gml");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://www.svgmaker.com/svgns", "svgmaker");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://xmlns.com/foaf/0.1/", "foaf");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://www.xml-cml.org/schema/stmml", "stm");
        WELL_KNOWN_ELEMENT_PREFIXES.put("http://www.iupac.org/foo/ichi", "ichi");
    }

    private final class StackNode {
        public final String uri;
        public final String prefix;
        public final String qName;
        public final Set<PrefixMapping> mappings = new HashSet<PrefixMapping>();

        public StackNode(String uri, String qName, String prefix) {
            this.uri = uri;
            this.qName = qName;
            this.prefix = prefix;
        }
    }

    private final class PrefixMapping {
        public final String uri;
        public final String prefix;

        public PrefixMapping(String uri, String prefix) {
            this.uri = uri;
            this.prefix = prefix;
        }

        public final boolean equals(Object obj) {
            if (obj instanceof PrefixMapping) {
                PrefixMapping other = (PrefixMapping)obj;
                return this.prefix.equals(other.prefix);
            }
            return false;
        }

        public final int hashCode() {
            return this.prefix.hashCode();
        }
    }
}

