/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

class ProcInstImpl
extends NodeImpl {
    String content;
    int nameCode;
    String systemId;
    int lineNumber = -1;

    public ProcInstImpl(int nameCode, String content) {
        this.nameCode = nameCode;
        this.content = content;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public String getStringValue() {
        return this.content;
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(new StringValue(this.getStringValue()));
    }

    public Value atomize() {
        return new StringValue(this.getStringValue());
    }

    public final int getNodeKind() {
        return 7;
    }

    public void setLocation(String uri, int lineNumber) {
        this.systemId = uri;
        this.lineNumber = lineNumber;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        out.processingInstruction(this.getLocalPart(), this.content, locationId, 0);
    }

    public String getTarget() {
        return this.getLocalPart();
    }

    public String getData() {
        return this.content;
    }

    public void rename(int newNameCode) {
        this.nameCode = newNameCode;
    }

    public void replaceStringValue(CharSequence stringValue) {
        this.content = ((Object)stringValue).toString();
    }
}

