/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class QuantifiedExpression
extends Assignation {
    private int operator;

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public int getOperator() {
        return this.operator;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.sequence = visitor.typeCheck(this.sequence, contextItemType);
        if (Literal.isEmptySequence(this.sequence)) {
            return Literal.makeLiteral(BooleanValue.get(this.operator != 31));
        }
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.sequence = ExpressionTool.unsorted(opt, this.sequence, false);
        SequenceType decl = this.getRequiredType();
        SequenceType sequenceType = SequenceType.makeSequenceType(decl.getPrimaryType(), 57344);
        RoleLocator role = new RoleLocator(3, this.getVariableQName(), 0);
        this.sequence = TypeChecker.strictTypeCheck(this.sequence, sequenceType, role, visitor.getStaticContext());
        ItemType actualItemType = this.sequence.getItemType(th);
        this.refineTypeInformation(actualItemType, 16384, null, this.sequence.getSpecialProperties(), visitor, this);
        this.action = visitor.typeCheck(this.action, contextItemType);
        XPathException err = TypeChecker.ebvError(this.action, visitor.getConfiguration().getTypeHierarchy());
        if (err != null) {
            err.setLocator(this);
            throw err;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.sequence = visitor.optimize(this.sequence, contextItemType);
        this.action = visitor.optimize(this.action, contextItemType);
        Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.action, visitor, contextItemType);
        if (ebv != null) {
            this.action = ebv;
            this.adoptChildExpression(ebv);
        }
        PromotionOffer offer = new PromotionOffer(opt);
        offer.containingExpression = this;
        offer.action = 11;
        offer.bindingList = new Binding[]{this};
        this.action = this.doPromotion(this.action, offer);
        if (offer.containingExpression instanceof LetExpression) {
            offer.containingExpression = visitor.optimize(visitor.typeCheck(offer.containingExpression, contextItemType), contextItemType);
        }
        return offer.containingExpression;
    }

    public void checkForUpdatingSubexpressions() throws XPathException {
        this.sequence.checkForUpdatingSubexpressions();
        this.action.checkForUpdatingSubexpressions();
    }

    public boolean isUpdatingExpression() {
        return false;
    }

    public Expression copy() {
        QuantifiedExpression qe = new QuantifiedExpression();
        qe.setOperator(this.operator);
        qe.setVariableQName(this.variableName);
        qe.setRequiredType(this.requiredType);
        qe.setSequence(this.sequence.copy());
        Expression newAction = this.action.copy();
        qe.setAction(newAction);
        qe.variableName = this.variableName;
        ExpressionTool.rebindVariableReferences(newAction, this, qe);
        return qe;
    }

    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.action;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Item it;
        SequenceIterator base = this.sequence.iterate(context);
        boolean some = this.operator == 31;
        int slot = this.getLocalSlotNumber();
        while ((it = base.next()) != null) {
            context.setLocalVariable(slot, it);
            if (some != this.action.effectiveBooleanValue(context)) continue;
            base.close();
            return some;
        }
        return !some;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement(Token.tokens[this.operator]);
        out.emitAttribute("variable", this.getVariableName());
        out.startSubsidiaryElement("in");
        this.sequence.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("satisfies");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

