/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.NameValue;
import io.mola.galimatias.URLUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public final class FormURLEncodedParser {
    private static final FormURLEncodedParser INSTANCE = new FormURLEncodedParser();

    private FormURLEncodedParser() {
    }

    @Deprecated
    public static FormURLEncodedParser getInstance() {
        return INSTANCE;
    }

    public static List<NameValue> parse(String input) {
        return FormURLEncodedParser.parse(input, Charset.forName("UTF-8"));
    }

    public static List<NameValue> parse(String input, Charset charset) {
        boolean isIndex = false;
        if (input == null) {
            throw new NullPointerException("input");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        String[] sequences = input.split("&");
        ArrayList<NameValue> pairs = new ArrayList<NameValue>();
        for (String bytes : sequences) {
            String value;
            String name;
            if (bytes.isEmpty()) continue;
            int equalsIndex = bytes.indexOf("=");
            if (equalsIndex != -1) {
                name = equalsIndex == 0 ? "" : bytes.substring(0, equalsIndex);
                value = equalsIndex == bytes.length() - 1 ? "" : bytes.substring(equalsIndex + 1);
            } else {
                name = bytes;
                value = "";
            }
            name = name.replace('+', ' ');
            value = value.replace('+', ' ');
            pairs.add(new NameValue(name, value));
        }
        return pairs;
    }

    private static String serialize(ByteBuffer bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        return FormURLEncodedParser.serialize(bytes.array(), bytes.arrayOffset(), bytes.limit());
    }

    private static String serialize(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = offset; i < offset + length; ++i) {
            byte b = bytes[i];
            if (32 == b) {
                sb.append(' ');
                continue;
            }
            if (42 == b || 45 == b || 46 == b || 48 <= b && b <= 57 || 65 <= b && b <= 90 || 95 == b || 97 <= b && b <= 122) {
                sb.appendCodePoint(b);
                continue;
            }
            URLUtils.percentEncode(b, sb);
        }
        return sb.toString();
    }

    public static String encode(String input) {
        return FormURLEncodedParser.encode(input, Charset.forName("UTF-8"));
    }

    public static String encode(String input, Charset charset) {
        return FormURLEncodedParser.encode(FormURLEncodedParser.parse(input), charset);
    }

    public static String encode(List<NameValue> input) {
        return FormURLEncodedParser.encode(input, Charset.forName("UTF-8"));
    }

    public static String encode(List<NameValue> input, Charset charset) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.size(); ++i) {
            NameValue pair = input.get(i);
            String outputName = FormURLEncodedParser.serialize(charset.encode(pair.name()));
            String outputValue = FormURLEncodedParser.serialize(charset.encode(pair.value()));
            if (i != 0) {
                sb.append('&');
            }
            sb.append(outputName).append('=').append(outputValue);
        }
        return sb.toString();
    }
}

