/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Pair;
import gnu.lists.Sequences;
import gnu.mapping.ArgList;
import gnu.mapping.ArgListBuilder;
import java.util.List;
import java.util.Map;

public class ArgListImpl
implements ArgList,
ArgListBuilder {
    Object[] values = new Object[8];
    protected int count;
    int firstKeyword;
    int numKeywords;
    short[] sortedKeywords;
    String[] keywords;

    public void printArgs() {
        System.err.print("args count:" + this.count);
        int i = 0;
        while (i < this.count) {
            System.err.print(" " + i + ": " + this.values[i]);
            if (++i == this.count) continue;
            System.err.print(';');
        }
        System.err.println();
    }

    public ArgListImpl() {
    }

    public ArgListImpl(ArgListImpl args) {
        int n;
        this.count = n = args.count;
        Object[] v = new Object[n];
        System.arraycopy(args.values, 0, v, 0, n);
        this.values = v;
        int nk = args.numKeywords;
        this.firstKeyword = args.firstKeyword;
        this.numKeywords = nk;
        String[] kw = args.keywords;
        if (kw != null && kw.length != nk) {
            String[] knew = new String[nk];
            System.arraycopy(kw, 0, knew, 0, nk);
            kw = knew;
        }
        this.keywords = kw;
        this.sortedKeywords = args.sortedKeywords;
    }

    @Override
    public int numArguments() {
        return this.count;
    }

    void resetArgCount(int size) {
        if (this.count > this.values.length) {
            throw new Error("bad count:" + this.count + " vlen:" + this.values.length);
        }
        int len = this.values.length;
        if (len < size || len > size + 64) {
            int nsize = size > 32 ? size : 2 * size;
            this.values = new Object[nsize];
        } else {
            for (int i = size; i < this.count; ++i) {
                this.values[i] = null;
            }
        }
        this.count = size;
        this.numKeywords = 0;
        this.keywords = null;
        this.sortedKeywords = null;
    }

    void ensureSpace(int size) {
        int osize = this.values.length;
        if (osize < size) {
            int nsize;
            int n = nsize = osize <= 16 ? 32 : osize + (osize >> 1);
            if (nsize < size) {
                nsize = size;
            }
            Object[] v = new Object[nsize];
            System.arraycopy(this.values, 0, v, 0, this.count);
            this.values = v;
        }
    }

    public Object popLast() {
        if (this.count == 0 || this.numKeywords <= 0 || this.firstKeyword + this.numKeywords >= this.count) {
            // empty if block
        }
        return this.values[--this.count];
    }

    public void shiftArgs(int toDrop) {
        this.count -= toDrop;
        this.firstKeyword -= toDrop;
        if (this.firstKeyword < 0) {
            if (this.numKeywords == 0) {
                this.firstKeyword = 0;
            } else {
                throw new Error("bad shiftArgs with keyword");
            }
        }
        System.arraycopy(this.values, toDrop, this.values, 0, this.count);
    }

    @Override
    public void clear() {
        this.resetArgCount(0);
    }

    @Override
    public void setArgs() {
        this.resetArgCount(0);
    }

    @Override
    public void setArgs(Object arg0) {
        this.resetArgCount(1);
        this.values[0] = arg0;
    }

    @Override
    public void setArgs(Object arg0, Object arg1) {
        this.resetArgCount(2);
        this.values[0] = arg0;
        this.values[1] = arg1;
    }

    @Override
    public void setArgs(Object arg0, Object arg1, Object arg2) {
        this.resetArgCount(3);
        this.values[0] = arg0;
        this.values[1] = arg1;
        this.values[2] = arg2;
    }

    @Override
    public void setArgs(Object arg0, Object arg1, Object arg2, Object arg3) {
        this.resetArgCount(4);
        this.values[0] = arg0;
        this.values[1] = arg1;
        this.values[2] = arg2;
        this.values[3] = arg3;
    }

    public void setArgsAll(Object[] args) {
        this.resetArgCount(args.length);
        System.arraycopy(args, 0, this.values, 0, args.length);
    }

    public void setArgsAll(Object[] args, int fromIndex, int toIndex) {
        int length = toIndex - fromIndex;
        this.resetArgCount(length);
        System.arraycopy(args, fromIndex, this.values, 0, length);
    }

    @Override
    public void add(Object arg) {
        int n = this.count;
        this.ensureSpace(n + 1);
        this.count = n + 1;
        this.values[n] = arg;
    }

    public void add(Object arg0, Object arg1, Object arg2, Object arg3) {
        int n = this.count;
        this.ensureSpace(n + 4);
        this.count = n + 4;
        this.values[n] = arg0;
        this.values[n + 1] = arg1;
        this.values[n + 2] = arg2;
        this.values[n + 3] = arg3;
    }

    @Override
    public void addAll(ArgList args) {
        int sz = args.numArguments();
        int k0 = args.firstKeyword();
        int nk = args.numKeywords();
        this.ensureSpace(this.count + sz);
        if (args instanceof ArgListImpl) {
            // empty if block
        }
        for (int i = 0; i < sz; ++i) {
            Object a = args.getArgAsObject(i);
            if (i >= k0 && i < k0 + nk) {
                this.addKey(args.getKeyword(i), a);
                continue;
            }
            this.add(a);
        }
    }

    public void addSequence(Object args) {
        List list = Sequences.coerceToSequence(args);
        for (Object v : list) {
            this.add(v);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addArgList(Object args) {
        block4: {
            block0: while (true) {
                if (args instanceof ArgList) {
                    this.addAll((ArgList)args);
                    break block4;
                }
                if (args instanceof Pair) {
                    pair = (Pair)args;
                    this.add(pair.getCar());
                    args = pair.getCdr();
                    continue;
                }
                if (!(args instanceof Map)) break;
                map = (Map)args;
                var3_3 = map.keySet().iterator();
                while (true) {
                    if (var3_3.hasNext()) ** break;
                    continue block0;
                    k = var3_3.next();
                    this.addKey(k.toString(), map.get(k));
                }
                break;
            }
            this.addSequence(args);
        }
    }

    @Override
    public void addAll(List<?> args) {
        int sz = args.size();
        int n = this.count;
        this.ensureSpace(n + sz);
        for (Object a : args) {
            this.values[n++] = a;
        }
        this.count = n;
    }

    @Override
    public void addKey(String keyword, Object arg) {
        if (this.numKeywords == 0) {
            this.firstKeyword = this.count;
        } else if (this.firstKeyword + this.numKeywords != this.count) {
            throw new RuntimeException("keyword arguments must be continuous");
        }
        this.add(arg);
        if (this.keywords == null) {
            this.keywords = new String[16];
        } else if (this.numKeywords == this.keywords.length) {
            String[] knew = new String[2 * this.numKeywords];
            System.arraycopy(this.keywords, 0, knew, 0, this.numKeywords);
            this.keywords = knew;
        }
        this.keywords[this.numKeywords++] = keyword;
        this.sortedKeywords = null;
    }

    @Override
    public Object getArgAsObject(int i) {
        return this.values[i];
    }

    @Override
    public int firstKeyword() {
        return this.firstKeyword;
    }

    @Override
    public int numKeywords() {
        return this.numKeywords;
    }

    @Override
    public String getKeyword(int index) {
        return index < this.firstKeyword || index >= this.firstKeyword + this.numKeywords ? null : this.keywords[index - this.firstKeyword];
    }

    public static int findKeyword(ArgList args, String key) {
        int numK = args.numKeywords();
        int firstK = args.firstKeyword();
        for (int i = 0; i < numK; ++i) {
            if (args.getKeyword(firstK + i) != key) continue;
            return firstK + i;
        }
        return -1;
    }

    @Override
    public int findKeyword(String key) {
        return ArgListImpl.findKeyword(this, key);
    }

    @Override
    public void setKeys(int numKeywords, String[] keys, short[] sorted) {
        this.numKeywords = numKeywords;
        this.keywords = keys;
        this.sortedKeywords = sorted;
        this.firstKeyword = this.count - numKeywords;
    }

    @Override
    public ArgList asArgList() {
        return this;
    }

    @Override
    public ArgList asFreshArgList() {
        return new ArgListImpl(this);
    }
}

